// -*-c++-*-

/*!
  \file color_setting_dialog.h
  \brief color setting dialog for the field canvas Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_QT3_COLOR_SETTING_DIALOG_H
#define SOCCERWINDOW2_QT3_COLOR_SETTING_DIALOG_H

#include <rcsc/types.h>

#include <qdialog.h>
#include <qpushbutton.h>

#include <map>

class QPen;
class QBrush;

class ColorButton;
class ColorSettingDialog;

class ColorButton
    : public QPushButton {

    Q_OBJECT

private:
    QString M_name;
    QColor M_default_color;
    QColor M_color;
    QPen * M_pen;
    QBrush * M_brush;

public:

    ColorButton( const QString & name,
                 QPen * pen,
                 QBrush * brush,
                 ColorSettingDialog * parent );
    const
    QString & name() const
      {
          return M_name;
      }

    const
    QColor & defaultColor() const
      {
          return M_default_color;
      }

    const
    QColor & color() const
      {
          return M_color;
      }

    void setColor( const QColor & color );

    void revert();
    void updateIcon();
    void checkColor();

private slots:

    void colorDialog();

signals:

    void colorChanged();
};


/*-------------------------------------------------------------------*/

/*!
  \class ColorSettingDialog
  \brief modal dialog to change color settings
 */
class ColorSettingDialog
    : public QDialog {

    Q_OBJECT

private:

    std::map< QString, ColorButton * > M_color_buttons;

public:

    ColorSettingDialog( QWidget * parent );

    ~ColorSettingDialog();

private:

    void createControls();

    QLayout * createColorButtons();
    QLayout * createAnswerButtons();

    void revert();

private slots:

    void setDefaultColors();

public slots:

    virtual
    void reject();

signals:

    void colorChanged();
};

#endif
