// -*-c++-*-

/*!
  \file ball_painter.cpp
  \brief ball painter class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// for compliers supporting precompling
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// for compliers NOT supporting precompling
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "ball_painter.h"

#include "draw_config.h"
// model
#include "main_data.h"
#include "monitor_view_data.h"

#include <rcsc/geom/vector_2d.h>
#include <rcsc/common/server_param.h>

#include <vector>

/*-------------------------------------------------------------------*/
/*!

*/
void
BallPainter::draw( wxDC & dc ) const
{
    MonitorViewConstPtr view = M_main_data.getViewData( M_main_data.viewIndex() );
    if ( ! view )
    {
        return;
    }

    const ViewConfig & vconf = M_main_data.viewConfig();
    const DrawConfig & dconf = DrawConfig::instance();

    const int ix = vconf.getScreenX( view->ball().x() );
    const int iy = vconf.getScreenY( view->ball().y() );
    // decide radius
    const int ball_radius = std::max( 1,
                                      ( vconf.isEnlarged()
                                        ? vconf.scale( 0.35 )
                                        : vconf.scale( rcsc::ServerParam::i().ballSize() ) )
                                      );

    // set GDI objects
    dc.SetPen( *wxTRANSPARENT_PEN );
    dc.SetBrush( dconf.ballBrush() );
    // draw ball body
    dc.DrawCircle( ix, iy, ball_radius );

    // draw setplay ball owner team color circle
    if ( view->playmode().isLeftSetPlay() )
    {
        dc.SetBrush( dconf.leftTeamBrush() );
        dc.DrawCircle( ix, iy, std::max( 1, ball_radius - 2 ) );
    }
    else if ( view->playmode().isRightSetPlay() )
    {
        dc.SetBrush( dconf.rightTeamBrush() );
        dc.DrawCircle( ix, iy, std::max( 1, ball_radius - 2 ) );
    }

    // draw additional circle
    if ( ! vconf.isEnlarged()
         || ball_radius <= 1  )
    {
        dc.SetPen( dconf.ballPen() );
        dc.SetBrush( *wxTRANSPARENT_BRUSH );
        dc.DrawCircle( vconf.getScreenX( view->ball().x() ),
                       vconf.getScreenY( view->ball().y() ),
                       vconf.scale( rcsc::ServerParam::i().defaultKickableMargin() ) );
    }

    // draw future status
    if ( vconf.ballFutureCycle() > 0
         && view->ball().hasDelta() )
    {
        drawFutureState( dc );
    }
}

/*-------------------------------------------------------------------*/
/*!

*/
void
BallPainter::drawFutureState( wxDC & dc ) const
{
    // draw future state
    MonitorViewConstPtr view = M_main_data.getViewData( M_main_data.viewIndex() );
    if ( ! view )
    {
        return;
    }

    const ViewConfig & vconf = M_main_data.viewConfig();
    const rcsc::ServerParam & sparam = rcsc::ServerParam::i();

    rcsc::Vector2D bpos( view->ball().x(),
                         view->ball().y() );
    rcsc::Vector2D bvel( view->ball().deltaX(),
                         view->ball().deltaY() );

    std::vector< wxPoint > points;
    points.push_back( wxPoint( vconf.getScreenX( bpos.x ),
                               vconf.getScreenY( bpos.y ) ) );
    const int last = vconf.ballFutureCycle();
    for ( int i = 0; i < last; ++i )
    {
        bpos += bvel;
        bvel *= sparam.ballDecay();

        wxPoint pt( vconf.getScreenX( bpos.x ),
                    vconf.getScreenY( bpos.y ) );
        if ( std::abs( points.back().x - pt.x ) < 1
             && std::abs( points.back().y - pt.y ) < 1 )
        {
            break;
        }
        points.push_back( pt );
    }

    dc.SetPen( DrawConfig::instance().ballPen() );
    dc.SetBrush( *wxTRANSPARENT_BRUSH );
    dc.DrawLine( points.front(), points.back() );

    const std::vector< wxPoint >::iterator end = points.end();
    for ( std::vector< wxPoint >::iterator it = points.begin() + 1;
          it != end;
              ++it )
    {
        dc.DrawCircle( *it, 1 );
    }
}
