// -*-c++-*-

/*!
  \file debug_painer.h
  \brief debug info painter class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_WX_DEBUG_PAINTER_H
#define SOCCERWINDOW2_WX_DEBUG_PAINTER_H

#include <rcsc/types.h>

#include "painter_interface.h"
#include "debug_view_data.h"

class MainData;

class ViewConfig;

class DebugPainter
    : private PainterInterface {
private:
    const MainData & M_main_data;

public:

    explicit
    DebugPainter( const MainData & main_data )
        : M_main_data( main_data )
      { }

    void draw( wxDC & dc ) const;

private:

    void drawSelf( wxDC & dc,
                   const rcsc::SideID player_side,
                   const DebugViewData & view ) const;
    void drawBall( wxDC & dc,
                   const rcsc::SideID player_side,
                   const DebugViewData & view ) const;
    void drawPlayers( wxDC &dc,
                      const rcsc::SideID player_side,
                      const DebugViewData::PlayerCont & players,
                      const int target_number,
                      const wxBrush & body_brush ) const;

    void drawLines( wxDC & dc,
                    const rcsc::SideID player_side,
                    const DebugViewData & view ) const;
    void drawTriangles( wxDC & dc,
                        const rcsc::SideID player_side,
                        const DebugViewData & view ) const;
    void drawRectangles( wxDC & dc,
                         const rcsc::SideID player_side,
                         const DebugViewData & view ) const;
    void drawCircles( wxDC & dc,
                      const rcsc::SideID player_side,
                        const DebugViewData & view ) const;

    void drawMessage( wxDC & dc,
                      const std::string & message ) const;

};

#endif
