// -*-c++-*-

/*!
  \file draw_config.cpp
  \brief draw object holder class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// for compliers supporting precompling
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// for compliers NOT supporting precompling
#ifndef WX_PRECOMP
#include <wx/wx.h>
#include <wx/config.h>
#include <wx/fileconf.h>
#endif

#include "draw_config.h"

#include "soccerwindow_app.h"

#include <iostream>

/*-------------------------------------------------------------------*/
const wxColor DrawConfig::SCORE_BOARD_COLOR = wxColor( 255, 255, 255 );
const wxColor DrawConfig::SCORE_BOARD_FONT_COLOR = wxColor( 0, 0, 0 );
const wxColor DrawConfig::FIELD_COLOR = wxColor( 31, 160, 31 );
const wxColor DrawConfig::FIELD_DARK_COLOR = wxColor( 15, 143, 15 ); //( 20, 150, 20 );
const wxColor DrawConfig::LINE_COLOR = wxColor( 255, 255, 255 );
const wxColor DrawConfig::BALL_PEN_COLOR = wxColor( 255, 255, 255 );
const wxColor DrawConfig::BALL_COLOR = wxColor( 255, 255, 255 );
const wxColor DrawConfig::BALL_FONT_COLOR = wxColor( 255, 255, 255 );
const wxColor DrawConfig::PLAYER_PEN_COLOR = wxColor( 0, 0, 0 );
const wxColor DrawConfig::REAL_BODY_PEN_COLOR = wxColor( 55, 255, 255 );
const wxColor DrawConfig::LEFT_TEAM_COLOR = wxColor( 255, 215, 0 );
const wxColor DrawConfig::LEFT_GOALIE_COLOR = wxColor( 40, 230, 30 );
const wxColor DrawConfig::RIGHT_TEAM_COLOR = wxColor( 240, 20, 20 );
const wxColor DrawConfig::RIGHT_GOALIE_COLOR = wxColor( 195, 55, 240 );
const wxColor DrawConfig::PLAYER_NUMBER_FONT_COLOR = wxColor( 255, 255, 255 );
const wxColor DrawConfig::PLAYER_STAMINA_FONT_COLOR = wxColor( 15, 255, 141 );//wxColor( 252, 232, 31 );
const wxColor DrawConfig::PLAYER_DETAIL_FONT_COLOR = wxColor( 255, 255, 255 );
const wxColor DrawConfig::SELECTED_PLAYER_FONT_COLOR = wxColor( 255, 255, 255 );
const wxColor DrawConfig::EFFORT_DECAYED_PEN_COLOR = wxColor( 255, 0, 0 );
const wxColor DrawConfig::RECOVERY_DECAYED_PEN_COLOR = wxColor( 252, 231, 31 );
const wxColor DrawConfig::VIEW_CONE_PEN_COLOR = wxColor( 55, 255, 255 );
const wxColor DrawConfig::VIEW_AREA_PEN_COLOR = wxColor( 255, 255, 255 );
const wxColor DrawConfig::KICK_PEN_COLOR = wxColor( 255, 255, 255 );
const wxColor DrawConfig::KICK_FAULT_COLOR = wxColor( 0, 255, 0 );
const wxColor DrawConfig::CATCH_COLOR = wxColor( 10, 80, 10 );
const wxColor DrawConfig::CATCH_FAULT_COLOR = wxColor( 10, 80, 150 );
const wxColor DrawConfig::COLLIDE_BALL_COLOR = wxColor( 5, 255, 255 );
const wxColor DrawConfig::COLLIDE_PLAYER_COLOR = wxColor( 105, 185, 255 );
const wxColor DrawConfig::TACKLE_COLOR = wxColor( 255, 136, 127 );
const wxColor DrawConfig::TACKLE_FAULT_COLOR = wxColor( 79, 159, 159 );
const wxColor DrawConfig::MEASURE_COLOR = wxColor( 0, 255, 255 );
const wxColor DrawConfig::MEASURE_FONT_COLOR = wxColor( 255, 191, 191 );
const wxColor DrawConfig::DEBUG_BALL_COLOR = wxColor( 255, 0, 127 );
const wxColor DrawConfig::DEBUG_SELF_COLOR = wxColor( 255, 127, 0 );
const wxColor DrawConfig::DEBUG_TEAMMATE_COLOR = wxColor( 0, 255, 95 );
const wxColor DrawConfig::DEBUG_OPPONENT_COLOR = wxColor( 0, 95, 255 );
const wxColor DrawConfig::DEBUG_UNKNOWN_TEAMMATE_COLOR = wxColor( 215, 255, 0 );
const wxColor DrawConfig::DEBUG_UNKNOWN_OPPONENT_COLOR = wxColor( 127, 95, 255 );
const wxColor DrawConfig::DEBUG_UNKNOWN_PLAYER_COLOR = wxColor( 191, 191, 191 );

/*-------------------------------------------------------------------*/
/*!
  constructor
*/
DrawConfig::DrawConfig()
    : M_score_board_brush( SCORE_BOARD_COLOR, wxSOLID )
    , M_score_board_font( 16,
                          wxFONTFAMILY_DEFAULT,
                          wxFONTSTYLE_NORMAL,
                          wxFONTWEIGHT_NORMAL,
                          false,
                          wxT( "" ),
                          wxFONTENCODING_ISO8859_1 ) //wxFONTENCODING_SYSTEM )
    , M_score_board_font_color( SCORE_BOARD_FONT_COLOR )
    , M_field_brush( FIELD_COLOR, wxSOLID )
    , M_field_dark_brush( FIELD_DARK_COLOR, wxSOLID )
    , M_line_pen( LINE_COLOR, 1, wxSOLID )
    , M_ball_pen( BALL_PEN_COLOR, 1, wxSOLID )
    , M_ball_brush( BALL_COLOR, wxSOLID )
    , M_ball_font( 10,
                   wxFONTFAMILY_DEFAULT,
                   wxFONTSTYLE_NORMAL,
                   wxFONTWEIGHT_NORMAL,
                   false, // underline
                   wxT( "" ), // facename
                   wxFONTENCODING_ISO8859_1 ) //wxFONTENCODING_SYSTEM )
    , M_ball_font_color( BALL_FONT_COLOR )
    , M_player_pen( PLAYER_PEN_COLOR, 1, wxSOLID )
    , M_real_body_pen( REAL_BODY_PEN_COLOR, 1, wxSOLID )
    , M_shadow_brush( wxColor( 0, 0, 0 ), wxSOLID )
    , M_left_team_pen( LEFT_TEAM_COLOR, 1, wxSOLID )
    , M_left_team_brush( LEFT_TEAM_COLOR, wxSOLID )
    , M_left_goalie_pen( LEFT_GOALIE_COLOR, 1, wxSOLID )
    , M_left_goalie_brush( LEFT_GOALIE_COLOR, wxSOLID )
    , M_right_team_pen( RIGHT_TEAM_COLOR, 1, wxSOLID )
    , M_right_team_brush( RIGHT_TEAM_COLOR, wxSOLID )
    , M_right_goalie_pen( RIGHT_GOALIE_COLOR, 1, wxSOLID )
    , M_right_goalie_brush( RIGHT_GOALIE_COLOR, wxSOLID )
    , M_player_font( 10,
                     wxFONTFAMILY_DEFAULT,
                     wxFONTSTYLE_NORMAL,
                     wxFONTWEIGHT_NORMAL,
                     false, // underline
                     wxT( "" ), // facename
                     wxFONTENCODING_ISO8859_1 ) //wxFONTENCODING_SYSTEM )
    , M_player_number_font_color( PLAYER_NUMBER_FONT_COLOR )
    , M_player_stamina_font_color( PLAYER_STAMINA_FONT_COLOR )
    , M_player_detail_font_color( PLAYER_DETAIL_FONT_COLOR )
    , M_selected_player_font_color( SELECTED_PLAYER_FONT_COLOR )
    , M_effort_decayed_pen( EFFORT_DECAYED_PEN_COLOR, 1, wxSOLID )
    , M_recovery_decayed_pen( RECOVERY_DECAYED_PEN_COLOR, 1, wxSOLID )
    , M_view_cone_pen( VIEW_CONE_PEN_COLOR, 1, wxSOLID )
    , M_view_area_pen( VIEW_AREA_PEN_COLOR, 1, wxSOLID )
    , M_kick_pen( KICK_PEN_COLOR, 2, wxSOLID )
    , M_kick_fault_pen( KICK_FAULT_COLOR, 2, wxSOLID )
    , M_kick_fault_brush( KICK_FAULT_COLOR, wxSOLID )
    , M_catch_brush( CATCH_COLOR, wxSOLID )
    , M_catch_fault_brush( CATCH_FAULT_COLOR, wxSOLID )
    , M_collide_ball_brush( COLLIDE_BALL_COLOR, wxSOLID )
    , M_collide_player_brush( COLLIDE_PLAYER_COLOR, wxSOLID )
    , M_tackle_pen( TACKLE_COLOR, 2, wxSOLID )
    , M_tackle_brush( TACKLE_COLOR, wxSOLID )
    , M_tackle_fault_brush( TACKLE_FAULT_COLOR, wxSOLID )
    , M_kick_accel_pen( wxColor( 0, 255, 0 ), 1, wxSOLID )
    , M_tackle_area_pen( TACKLE_COLOR, 1, wxSOLID )
    , M_measure_color( MEASURE_COLOR )
    , M_measure_pen( MEASURE_COLOR, 1, wxSOLID )
    , M_measure_font_color( MEASURE_FONT_COLOR )
    , M_measure_font( 10,
                      wxFONTFAMILY_DEFAULT,
                      wxFONTSTYLE_NORMAL,
                      wxFONTWEIGHT_NORMAL,
                      false, // underline
                      wxT( "" ), // facename
                      wxFONTENCODING_ISO8859_1 ) //wxFONTENCODING_SYSTEM )
    , M_debug_ball_pen( wxColor( 127, 127, 127 ), 1, wxSOLID )
    , M_debug_ball_brush( DEBUG_BALL_COLOR, wxSOLID )
    , M_debug_ball_trace_pen( DEBUG_BALL_COLOR, 1, wxSOLID )
    , M_debug_ball_trace_brush( DEBUG_BALL_COLOR, wxSOLID )
    , M_debug_player_pen( wxColor( 127, 127, 127 ), 1, wxSOLID )
    , M_debug_body_dir_pen( wxColor( 0, 0, 0 ), 1, wxSOLID )
    , M_debug_self_brush( DEBUG_SELF_COLOR, wxSOLID )
    , M_debug_teammate_brush( DEBUG_TEAMMATE_COLOR, wxSOLID )
    , M_debug_opponent_brush( DEBUG_OPPONENT_COLOR, wxSOLID )
    , M_debug_unknown_teammate_brush( DEBUG_UNKNOWN_TEAMMATE_COLOR, wxSOLID )
    , M_debug_unknown_opponent_brush( DEBUG_UNKNOWN_OPPONENT_COLOR, wxSOLID )
    , M_debug_unknown_player_brush( DEBUG_UNKNOWN_PLAYER_COLOR, wxSOLID )
    , M_debug_target_pen( DEBUG_SELF_COLOR, 2, wxSOLID )
    , M_debug_figure_pen( wxColor( 255, 127, 0 ), 1, wxSOLID )
    , M_debug_comment_font( 10,
                            wxFONTFAMILY_DEFAULT,
                            wxFONTSTYLE_NORMAL,
                            wxFONTWEIGHT_NORMAL,
                            false, // underline
                            wxT( "" ), // facename
                            wxFONTENCODING_ISO8859_1 ) //wxFONTENCODING_SYSTEM )
    , M_debug_comment_font_color( 191, 191, 191 )
    , M_debug_message_font( 14,
                            wxFONTFAMILY_DEFAULT,
                            wxFONTSTYLE_NORMAL,
                            wxFONTWEIGHT_NORMAL,
                            false, // underline
                            wxT( "" ), // facename
                            wxFONTENCODING_ISO8859_1 ) //wxFONTENCODING_SYSTEM )
    , M_debug_message_font_color( 255, 255, 255 )
{
    //std::cerr << "create DrawConfig" << std::endl;
    loadConfig();
}

/*-------------------------------------------------------------------*/
/*!
  destructor
*/
DrawConfig::~DrawConfig()
{
    //std::cerr << "delete DrawConfig" << std::endl;
    saveConfig();
}

/*-------------------------------------------------------------------*/
/*!
  load configuration from file.
*/
void
DrawConfig::loadConfig()
{
    wxFileConfig & config_file = SoccerWindowApp::get_config_file();
    wxString old_path = config_file.GetPath();
    config_file.SetPath( wxT( "/GDI" ) );

    wxString value_str;

    // score board
    if ( config_file.Read( wxT( "score_board_color" ), &value_str ) )
    {
        M_score_board_brush.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "score_board_font" ), &value_str ) )
    {
        M_score_board_font.SetNativeFontInfo( value_str );
    }
    if ( config_file.Read( wxT( "score_board_font_color" ), &value_str ) )
    {
        M_score_board_font_color = toColor( value_str );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    // field
    if ( config_file.Read( wxT( "field_color" ), &value_str ) )
    {
        M_field_brush.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "field_dark_color" ), &value_str ) )
    {
        M_field_dark_brush.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "line_color" ), &value_str ) )
    {
        M_line_pen.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    // ball
    if ( config_file.Read( wxT( "ball_pen_color" ), &value_str ) )
    {
        M_ball_pen.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "ball_color" ), &value_str ) )
    {
        M_ball_brush.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "ball_font" ), &value_str ) )
    {
        M_ball_font.SetNativeFontInfo( value_str );
    }
    if ( config_file.Read( wxT( "ball_font_color" ), &value_str ) )
    {
        M_ball_font_color = toColor( value_str );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    // player body
    if ( config_file.Read( wxT( "player_pen_color" ), &value_str ) )
    {
        M_player_pen.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "real_body_pen_color" ), &value_str ) )
    {
        M_real_body_pen.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "left_team_color" ), &value_str ) )
    {
        wxColor col = toColor( value_str );
        M_left_team_pen.SetColour( col );
        M_left_team_brush.SetColour( col );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "left_goalie_color" ), &value_str ) )
    {
        wxColor col = toColor( value_str );
        M_left_goalie_pen.SetColour( col );
        M_left_goalie_brush.SetColour( col );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "right_team_color" ), &value_str ) )
    {
        wxColor col = toColor( value_str );
        M_right_team_pen.SetColour( col );
        M_right_team_brush.SetColour( col );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "right_goalie_color" ), &value_str ) )
    {
        wxColor col = toColor( value_str );
        M_right_goalie_pen.SetColour( col );
        M_right_goalie_brush.SetColour( col );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    // player font
    if ( config_file.Read( wxT( "player_number_font" ), &value_str ) )
    {
        M_player_font.SetNativeFontInfo( value_str );
    }
    if ( config_file.Read( wxT( "player_number_font_color" ), &value_str ) )
    {
        M_player_number_font_color = toColor( value_str );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "player_stamina_font_color" ), &value_str ) )
    {
        M_player_stamina_font_color = toColor( value_str );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "player_detail_font_color" ), &value_str ) )
    {
        M_player_detail_font_color = toColor( value_str );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "selected_player_font_color" ), &value_str ) )
    {
        M_selected_player_font_color = toColor( value_str );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    // player pen
    if ( config_file.Read( wxT( "effort_decayed_pen_color" ), &value_str ) )
    {
        M_effort_decayed_pen.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "recovery_decayed_pen_color" ), &value_str ) )
    {
        M_recovery_decayed_pen.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "view_cone_pen_color" ), &value_str ) )
    {
        M_view_cone_pen.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "view_area_pen_color" ), &value_str ) )
    {
        M_view_area_pen.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    // player status
    if ( config_file.Read( wxT( "kick_pen_color" ), &value_str ) )
    {
        M_kick_pen.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "kick_fault_color" ), &value_str ) )
    {
        wxColor col = toColor( value_str );
        M_kick_fault_pen.SetColour( col );
        M_kick_fault_brush.SetColour( col );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "catch_color" ), &value_str ) )
    {
        M_catch_brush.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "catch_fault_color" ), &value_str ) )
    {
        M_catch_fault_brush.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "collide_ball_color" ), &value_str ) )
    {
        M_collide_ball_brush.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "collide_player_color" ), &value_str ) )
    {
        M_collide_player_brush.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "tackle_color" ), &value_str ) )
    {
        wxColor col = toColor( value_str );
        M_tackle_pen.SetColour( col );
        M_tackle_brush.SetColour( col );
        M_tackle_area_pen.SetColour( col );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "tackle_fault_color" ), &value_str ) )
    {
        M_tackle_fault_brush.SetColour( toColor( value_str ) );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "measure_font" ), &value_str ) )
    {
        M_measure_font.SetNativeFontInfo( value_str );
    }
    if ( config_file.Read( wxT( "measure_color" ), &value_str ) )
    {
        M_measure_color = toColor( value_str );
        M_measure_pen.SetColour( M_measure_color );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }
    if ( config_file.Read( wxT( "measure_font_color" ), &value_str ) )
    {
        M_measure_font_color = toColor( value_str );
    } //else { std::cerr << "load error" << __LINE__ << std::endl; }

    if ( config_file.Read( wxT( "debug_ball_pen_color" ), &value_str ) )
    {
        M_debug_ball_pen.SetColour( toColor( value_str ) );
    }
    if ( config_file.Read( wxT( "debug_ball_brush_color" ), &value_str ) )
    {
        M_debug_ball_brush.SetColour( toColor( value_str ) );
    }

    if ( config_file.Read( wxT( "debug_ball_trace_pen_color" ), &value_str ) )
    {
        M_debug_ball_trace_pen.SetColour( toColor( value_str ) );
    }
    if ( config_file.Read( wxT( "debug_ball_trace_brush_color" ), &value_str ) )
    {
        M_debug_ball_trace_brush.SetColour( toColor( value_str ) );
    }

    if ( config_file.Read( wxT( "debug_player_pen_color" ), &value_str ) )
    {
        M_debug_player_pen.SetColour( toColor( value_str ) );
    }
    if ( config_file.Read( wxT( "debug_body_dir_pen_color" ), &value_str ) )
    {
        M_debug_body_dir_pen.SetColour( toColor( value_str ) );
    }

    if ( config_file.Read( wxT( "debug_self_brush_color" ), &value_str ) )
    {
        M_debug_self_brush.SetColour( toColor( value_str ) );
    }
    if ( config_file.Read( wxT( "debug_teammate_brush_color" ), &value_str ) )
    {
        M_debug_teammate_brush.SetColour( toColor( value_str ) );
    }
    if ( config_file.Read( wxT( "debug_opponent_brush_color" ), &value_str ) )
    {
        M_debug_opponent_brush.SetColour( toColor( value_str ) );
    }
    if ( config_file.Read( wxT( "debug_unknown_teammate_brush_color" ), &value_str ) )
    {
        M_debug_unknown_teammate_brush.SetColour( toColor( value_str ) );
    }
    if ( config_file.Read( wxT( "debug_unknown_opponent_brush_color" ), &value_str ) )
    {
        M_debug_unknown_opponent_brush.SetColour( toColor( value_str ) );
    }
    if ( config_file.Read( wxT( "debug_unknown_player_brush_color" ), &value_str ) )
    {
        M_debug_unknown_player_brush.SetColour( toColor( value_str ) );
    }

    if ( config_file.Read( wxT( "debug_target_pen_color" ), &value_str ) )
    {
        M_debug_target_pen.SetColour( toColor( value_str ) );
    }

    if ( config_file.Read( wxT( "debug_comment_font_color" ), &value_str ) )
    {
        M_debug_comment_font_color = toColor( value_str );
    }
    if ( config_file.Read( wxT( "debug_message_font_color" ), &value_str ) )
    {
        M_debug_message_font_color = toColor( value_str );
    }

    config_file.SetPath( old_path );
}

/*-------------------------------------------------------------------*/
/*!
  save configuration to file.
*/
void
DrawConfig::saveConfig()
{
    //std::cerr << "DrawConfig::saveConfig" << std::endl;
    wxFileConfig & config_file = SoccerWindowApp::get_config_file();
    wxString old_path = config_file.GetPath();
    config_file.SetPath( wxT( "/GDI" ) );

    // score board
    config_file.Write( wxT( "score_board_color" ),
                       toString( scoreBoardBrush().GetColour() ) );
    config_file.Write( wxT( "score_board_font" ),
                       M_score_board_font.GetNativeFontInfoDesc() );
    config_file.Write( wxT( "score_board_font_color" ),
                       toString( scoreBoardFontColor() ) );
    // field
    config_file.Write( wxT( "field_color" ),
                       toString( fieldBrush().GetColour() ) );
    config_file.Write( wxT( "field_dark_color" ),
                       toString( fieldDarkBrush().GetColour() ) );
    config_file.Write( wxT( "line_color" ),
                       toString( linePen().GetColour() ) );
    // ball
    config_file.Write( wxT( "ball_pen_color" ),
                       toString( ballPen().GetColour() ) );
    config_file.Write( wxT( "ball_color" ),
                       toString( ballBrush().GetColour() ) );
    config_file.Write( wxT( "ball_font" ),
                       M_ball_font.GetNativeFontInfoDesc() );
    config_file.Write( wxT( "ball_font_color" ),
                       toString( ballFontColor() ) );
    // player body
    config_file.Write( wxT( "player_pen_color" ),
                       toString( playerPen().GetColour() ) );
    config_file.Write( wxT( "real_body_pen_color" ),
                       toString( realBodyPen().GetColour() ) );
    config_file.Write( wxT( "left_team_color" ),
                       toString( leftTeamPen().GetColour() ) );
    config_file.Write( wxT( "left_goalie_color" ),
                       toString( leftGoaliePen().GetColour() ) );
    config_file.Write( wxT( "right_team_color" ),
                       toString( rightTeamPen().GetColour() ) );
    config_file.Write( wxT( "right_goalie_color" ),
                       toString( rightGoaliePen().GetColour() ) );

    config_file.Write( wxT( "player_font" ),
                       M_player_font.GetNativeFontInfoDesc() );
    config_file.Write( wxT( "player_number_font_color" ),
                       toString( playerNumberFontColor() ) );
    config_file.Write( wxT( "player_stamina_font_color" ),
                       toString( playerStaminaFontColor() ) );
    config_file.Write( wxT( "player_detail_font_color" ),
                       toString( playerDetailFontColor() ) );
    config_file.Write( wxT( "selected_player_font_color" ),
                       toString( selectedPlayerFontColor() ) );
    // player pen
    config_file.Write( wxT( "effort_decayed_pen_color" ),
                       toString( effortDecayedPen().GetColour() ) );
    config_file.Write( wxT( "recovery_decayed_pen_color" ),
                       toString( recoveryDecayedPen().GetColour() ) );
    config_file.Write( wxT( "view_cone_pen_color" ),
                       toString( viewConePen().GetColour() ) );
    config_file.Write( wxT( "view_area_pen_color" ),
                       toString( viewAreaPen().GetColour() ) );
    // player status
    config_file.Write( wxT( "kick_pen_color" ),
                       toString( kickPen().GetColour() ) );
    config_file.Write( wxT( "kick_fault_color" ),
                       toString( kickFaultBrush().GetColour() ) );
    config_file.Write( wxT( "catch_color" ),
                       toString( catchBrush().GetColour() ) );
    config_file.Write( wxT( "catch_fault_color" ),
                       toString( catchFaultBrush().GetColour() ) );
    config_file.Write( wxT( "collide_ball_color" ),
                       toString( collideBallBrush().GetColour() ) );
    config_file.Write( wxT( "collide_player_color" ),
                       toString( collidePlayerBrush().GetColour() ) );
    config_file.Write( wxT( "tackle_color" ),
                       toString( tackleBrush().GetColour() ) );
    config_file.Write( wxT( "tackle_fault_color" ),
                       toString( tackleFaultBrush().GetColour() ) );

    config_file.Write( wxT( "measure_color" ),
                       toString( measureColor() ) );
    config_file.Write( wxT( "measure_font_color" ),
                       toString( measureFontColor() ) );
    config_file.Write( wxT( "measure_font" ),
                       M_measure_font.GetNativeFontInfoDesc() );

    config_file.Write( wxT( "debug_ball_pen_color" ),
                       toString( M_debug_ball_pen.GetColour() ) );
    config_file.Write( wxT( "debug_ball_brush_color" ),
                       toString( M_debug_ball_brush.GetColour() ) );

    config_file.Write( wxT( "debug_ball_trace_pan_color" ),
                       toString( M_debug_ball_trace_pen.GetColour() ) );
    config_file.Write( wxT( "debug_ball_trace_brush_color" ),
                       toString( M_debug_ball_trace_brush.GetColour() ) );

    config_file.Write( wxT( "debug_player_pen_color" ),
                       toString( M_debug_player_pen.GetColour() ) );
    config_file.Write( wxT( "debug_body_dir_pen_color" ),
                       toString( M_debug_body_dir_pen.GetColour() ) );
    config_file.Write( wxT( "debug_self_brush_color" ),
                       toString( M_debug_self_brush.GetColour() ) );
    config_file.Write( wxT( "debug_teammate_brush_color" ),
                       toString( M_debug_teammate_brush.GetColour() ) );
    config_file.Write( wxT( "debug_opponent_brush_color" ),
                       toString( M_debug_opponent_brush.GetColour() ) );
    config_file.Write( wxT( "debug_unknown_teammate_brush_color" ),
                       toString( M_debug_unknown_teammate_brush.GetColour() ) );
    config_file.Write( wxT( "debug_unknown_opponent_brush_color" ),
                       toString( M_debug_unknown_opponent_brush.GetColour() ) );
    config_file.Write( wxT( "debug_unknown_player_brush_color" ),
                       toString( M_debug_unknown_player_brush.GetColour() ) );
    config_file.Write( wxT( "debug_target_pen_color" ),
                       toString( M_debug_target_pen.GetColour() ) );
    config_file.Write( wxT( "debug_figure_color" ),
                       toString( M_debug_figure_pen.GetColour() ) );

    config_file.Write( wxT( "debug_comment_font" ),
                       M_debug_comment_font.GetNativeFontInfoDesc() );
    config_file.Write( wxT( "debug_comment_font_color" ),
                       toString( M_debug_comment_font_color ) );
    config_file.Write( wxT( "debug_message_font" ),
                       M_debug_message_font.GetNativeFontInfoDesc() );
    config_file.Write( wxT( "debug_message_font_color" ),
                       toString( M_debug_message_font_color ) );


    config_file.SetPath( old_path );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DrawConfig::resizeScoreBoardFont( const int size )
{
    M_score_board_font.SetPointSize( size );
}

/*-------------------------------------------------------------------*/
/*!

*/
wxColor
DrawConfig::toColor( const wxString & conf_str )
{
    unsigned int rgb;
    if ( std::sscanf(
#ifdef UNICODE
                     (const char*)(conf_str.mbc_str()),
#else
                     (const char*)(conf_str.c_str()),
#endif
                     //"#%x",
                     "%x",
                     &rgb ) != 1 )
    {
        std::cerr << __FILE__ << ':' << __LINE__ << ": "
                  << "color conversion error. ["
#ifdef UNICODE
                  << (const char*)conf_str.mbc_str()
#else
                  << (const char*)conf_str.c_str()
#endif
                  << "]"
                  << std::endl;
        return wxColor();
    }
    //std::cerr << "Load: color r=" << r << " g=" << g << " b=" << b
    //<< std::endl;
    return wxColor( rgb >> 16,
                    ( rgb >> 8 ) & 0x0000ff,
                    rgb & 0x0000ff );
}

/*-------------------------------------------------------------------*/
/*!

*/
wxString
DrawConfig::toString( const wxColor & color )
{
    wxString color_str;
    color_str.Printf( wxT( "%02x%02x%02x" ), //wxT( "#%02x%02x%02x" ),
                      color.Red(),
                      color.Green(),
                      color.Blue() );
    return color_str;
}

/*-------------------------------------------------------------------*/
/*!
  get const reference to the player's body brush
*/
const
wxBrush &
DrawConfig::getPlayerBodyBrush( const rcsc::SideID side,
                                const bool goalie ) const
{
    switch ( side ) {
    case rcsc::LEFT:
        if ( goalie )
        {
            return leftGoalieBrush();
        }
        else
        {
            return leftTeamBrush();
        }
        break;
    case rcsc::RIGHT:
        if ( goalie )
        {
            return rightGoalieBrush();
        }
        else
        {
            return rightTeamBrush();
        }
        break;
    case rcsc::NEUTRAL:
        break;
    default:
        break;
    }

    return shadowBrush();
}
