// -*-c++-*-

/*!
	\file field_canvas.h
	\brief field canvas class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.	If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_WX_FIELD_CANVAS_H
#define SOCCERWINDOW2_WX_FIELD_CANVAS_H

#include "mouse_state.h"

#include <boost/scoped_ptr.hpp>
#include <boost/signals.hpp>

#include <string>

class MainData;

///////////////////////////////////////////////////////////////////////
//! main soccer field canvas class
class FieldCanvas
		: public wxWindow {
private:

    //! main data supplier
    MainData & M_main_data;

    //! popup menu
    boost::scoped_ptr< wxMenu > M_normal_menu;
    //! popup menu
    boost::scoped_ptr< wxMenu > M_system_menu;
    //! popup menu
    boost::scoped_ptr< wxMenu > M_monitor_menu;

		//! bitmap buffer of draw area.
		wxBitmap M_canvas_bmp;


    //! 0: left, 1: middle, 2: right
    MouseState M_mouse_state[3];

public:
		//! constructor
		FieldCanvas( wxWindow * parent,
                 MainData & main_data );

		//! destructor
		~FieldCanvas();

private:

    void createWindows();
    void connectEvents();

		//----------------------------------------------
		//! event handler for EVT_PAINT
		void handlePaint( wxPaintEvent & event );

    void handleMenuEvent( wxCommandEvent & event );

		//--------------------------------------------------
		// Mouse Event handlers.
		void handleLeftDown( wxMouseEvent & event );
		void handleLeftUp( wxMouseEvent & event );
		void handleLeftDClick( wxMouseEvent & event );

		void handleMiddleDown( wxMouseEvent & event );
		void handleMiddleUp( wxMouseEvent & event );

		void handleRightDown( wxMouseEvent & event );
		void handleRightUp( wxMouseEvent & event );

		void handleMouseMotion( wxMouseEvent & event );

		void handleMouseWheel( wxMouseEvent & event );

		// Keyboard Event handlers.
		void handleChar( wxKeyEvent & event );
		void handleKeyDown( wxKeyEvent & event );

		// key code handling method
		bool doHandleKeyCode( wxKeyEvent & event );

    // menu actions: normal, system
    void handleOpenRCG( wxCommandEvent & event );
    void handleConnectMonitor( wxCommandEvent & event );
    void handleRestartServer( wxCommandEvent & event );
    void handleKillServer( wxCommandEvent & event );

    // menu actions: monitor
    void dropBall( wxCommandEvent & event );
    void freeKickLeft( wxCommandEvent & event );
    void freeKickRight( wxCommandEvent & event );
    void dropBallThere( wxCommandEvent & event );

public:
		//--------------------------------------------------
		//! redraw client DC
		void draw();

    void drawAll( wxDC & mem_dc );

private:
		//----------------------------------------------
		//! redraw all screen
		void draw( wxDC & dc );

		//! draw line of mouse measure
		void drawMouseMeasure( wxDC & mem_dc );


public:

    // slots:
    void updateView();

    void setRedrawAllFlag();

public:

    // signals

    boost::signal< void( const wxPoint & ) > emit_dropBall;
    boost::signal< void( const wxPoint & ) > emit_freeKickLeft;
    boost::signal< void( const wxPoint & ) > emit_freeKickRight;
    boost::signal< void() > emit_dropBallThere;

    boost::signal< void( const wxPoint & ) > emit_focusChanged;
    boost::signal< void( const wxPoint & ) > emit_mouseMoved;

    boost::signal< void() > emit_openRCG;
    boost::signal< void() > emit_connectMonitor;
    boost::signal< void() > emit_restartServer;
    boost::signal< void() > emit_killServer;

    boost::signal< void() > emit_wheelDown;
    boost::signal< void() > emit_wheelUp;

    // void( key_code, control, alt, shit )
    boost::signal< bool( int, bool, bool, bool ) > emit_keyPressed;

};

#endif
