// -*-c++-*-

/*!
  \file monitor_client.h
  \brief Monitor Client class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_MONITOR_CLIENT_H
#define SOCCERWINDOW2_MONITOR_CLIENT_H

#include <boost/scoped_ptr.hpp>

#include <rcsc/types.h>

namespace rcsc {
class UDPSocket;
class MonitorCommand;
}

class MainFrame;
class ViewHolder;

//! monitor client that connect to the rcssserver
class MonitorClient
    : public wxEvtHandler {
private:

    //! monitor protocol version
    int M_version;

    //! udp socket object
    boost::scoped_ptr< rcsc::UDPSocket > M_socket;

    //! receive check interval timer.
    wxTimer M_timer;

    MainFrame * M_main_frame;

    //! refence to the view data holder
    ViewHolder & M_view_holder;

    //! not used
    MonitorClient();
    //! nocopyable
    MonitorClient( const MonitorClient & );
    //! nocopyabne
    MonitorClient & operator=( const MonitorClient & );
public:
    //! constructor
    MonitorClient( const int version,
                   const char * hostname,
                   const int port,
                   MainFrame * main_frame,
                   ViewHolder & view_holder );

    ~MonitorClient();

    bool isConnected() const;

private:

    //! timer event handler
    void handleTimer( wxTimerEvent & event );


    void disconnect();

    void sendCommand( const rcsc::MonitorCommand & com );

public:

    void sendDispInit();
    void sendDispBye();
    void sendKickOff();
    void sendFreeKick( const  double & x,
                       const double & y,
                       const rcsc::SideID side );
    void sendDropBall( const double & x,
                       const double & y )
      {
          sendFreeKick( x, y, rcsc::NEUTRAL );
      }
    void sendFreeKickLeft( const double & x,
                           const double & y )
      {
          sendFreeKick( x, y, rcsc::LEFT );
      }
    void sendFreeKickRight( const double & x,
                            const double & y )
      {
          sendFreeKick( x, y, rcsc::RIGHT );
      }

    void sendMove( const rcsc::SideID side,
                   const int unum,
                   const double & x,
                   const double & y,
                   const double & angle );

    void sendDiscard( const rcsc::SideID side,
                      const int unum );

private:

    void recvDropBall( const boost::any * data );
    void recvFreeKickLeft( const boost::any * data );
    void recvFreeKickRight( const boost::any * data );
};

#endif
