// -*-c++-*-

/*!
  \file player_control_painter.cpp
  \brief player control painter class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// for compliers supporting precompling
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// for compliers NOT supporting precompling
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "player_control_painter.h"

#include "draw_config.h"
// model
#include "main_data.h"
#include "monitor_view_data.h"

#include <rcsc/common/player_type.h>
#include <rcsc/common/server_param.h>

/*-------------------------------------------------------------------*/
/*!

*/
void
PlayerControlPainter::draw( wxDC & dc ) const
{
    const ViewHolder & holder = M_main_data.viewHolder();
    int number = M_main_data.viewConfig().selectedNumber();
    if ( number == 0 )
    {
        return;
    }

    MonitorViewConstPtr view = M_main_data.getViewData( M_main_data.viewIndex() );
    if ( ! view )
    {
        return;
    }

    const Ball & ball = view->ball();
    const Player & player = view->players()[( number > 0 ? number - 1 : -number - 1 + 11 )];
    const rcsc::ServerParam & sparam = rcsc::ServerParam::i();
    const rcsc::PlayerType & ptype = holder.playerType( player.type() );

    if ( M_main_data.viewConfig().isShownControlArea()
         && ball.hasDelta() )
    {
        rcsc::Vector2D ppos( player.x(), player.y() );
        rcsc::Vector2D bpos( ball.x(), ball.y() );
        rcsc::Vector2D player_to_ball = bpos - ppos;
        player_to_ball.rotate( - player.body() );

        rcsc::Vector2D bnext( bpos.x + ball.deltaX(),
                              bpos.y + ball.deltaY() );
        double ball_dist = player_to_ball.r();
        if ( ball_dist < ptype.kickableArea() )
        {
            double max_kick_accel
                = sparam.maxPower()
                * sparam.kickPowerRate()
                * ( 1.0 - 0.25 * player_to_ball.th().abs() / 180.0
                    - 0.25
                    * ( ball_dist - ptype.playerSize() - sparam.ballSize() )
                    / ptype.kickableMargin() );
            if ( max_kick_accel > sparam.ballAccelMax() )
            {
                max_kick_accel = sparam.ballAccelMax();
            }
            int max_kick_accel_screen = M_main_data.viewConfig().scale( max_kick_accel );
            wxPoint bnext_screen( M_main_data.viewConfig().getScreenX( bnext.x ),
                                  M_main_data.viewConfig().getScreenY( bnext.y ) );

            dc.SetPen( DrawConfig::instance().kickAccelPen() );
            dc.SetBrush( *wxTRANSPARENT_BRUSH );
            // draw no noise next ball move only by inertia
            dc.DrawLine( M_main_data.viewConfig().getScreenX( bpos.x ),
                         M_main_data.viewConfig().getScreenY( bpos.y ),
                         bnext_screen.x,
                         bnext_screen.y );
            // draw next ball reachable area
            dc.DrawCircle( bnext_screen.x, bnext_screen.y,
                           max_kick_accel_screen );
            // draw kick info text
            dc.SetFont( DrawConfig::instance().playerFont() );
            dc.SetTextForeground( DrawConfig::instance().kickAccelPen().GetColour() );
            dc.SetBackgroundMode( wxTRANSPARENT );
            wxString msg;
            msg.Printf( wxT( "MaxAccel=%.3f" ), max_kick_accel );
            dc.DrawText( msg,
                         bnext_screen.x + 10,
                         bnext_screen.y );
        }
    }
}
