// -*-c++-*-

/*!
  \file player_panel.cpp
  \brief player info panel class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#include <wx/statline.h>
#endif

#include <iostream>
#include <cassert>

#include <rcsc/geom/vector_2d.h>

#include "id.h"
#include "monitor_view_data.h"
#include "main_data.h"

#include "player_panel.h"

namespace {
const int value_width = -1;
}

/*-------------------------------------------------------------------*/
/*!

*/
PlayerPanel::PlayerPanel( wxWindow * parent,
                          const MainData & main_data )
    : wxPanel( parent, -1 )
    , M_main_data( main_data )
    , M_number( new wxStaticText( this, -1, wxT( "   ?????      0" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_type( new wxStaticText( this, -1, wxT( "      0" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_pos( new wxStaticText( this, -1, wxT( " 000.00, 000.00" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_vel( new wxStaticText( this, -1, wxT( " 000.00, 000.00" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_polar( new wxStaticText( this, -1, wxT( " 00.000, 0000.0" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_last_move( new wxStaticText( this, -1, wxT( " 000.00, 000.00" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_last_move_dist( new wxStaticText( this, -1, wxT( " 00.000" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_body( new wxStaticText( this, -1, wxT( " 0000.0" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_head( new wxStaticText( this, -1, wxT( " 0000.0(0000.0)" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_ball_rel( new wxStaticText( this, -1, wxT( " 000.00, 000.00" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_ball_polar( new wxStaticText( this, -1, wxT( "000.000, 0000.0" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_ball_vel_rel( new wxStaticText( this, -1, wxT( " 000.00, 000.00" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_stamina( new wxStaticText( this, -1, wxT( " 0000.0" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_effort( new wxStaticText( this, -1, wxT( " 0.000 / 0.000" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_recovery( new wxStaticText( this, -1, wxT( " 0.000 / 1.0" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_kick_count( new wxStaticText( this, -1, wxT( "  00000" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_dash_count( new wxStaticText( this, -1, wxT( "  00000" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_turn_count( new wxStaticText( this, -1, wxT( "  00000" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_say_count( new wxStaticText( this, -1, wxT( "  00000" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_turn_neck_count( new wxStaticText( this, -1, wxT( "  00000" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_catch_count( new wxStaticText( this, -1, wxT( "  00000" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_move_count( new wxStaticText( this, -1, wxT( "  00000" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_change_view_count( new wxStaticText( this, -1, wxT( "  00000" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
{
    assert( parent );

		wxBoxSizer * panel_sizer = new wxBoxSizer( wxVERTICAL );

    const int label_width = 70;
		const int label_rate = 0; // label width rate for sizer
		const int value_rate = 0; // value width rate for sizer
    const int side_space = 8; // side space in each value box
    const int left_space = 0; // left space in top panel box

    const int label_style = 0;//wxLEFT;
    const int value_style = wxLEFT;//wxRIGHT;
    const int box_style = 0;//wxALIGN_LEFT | wxLEFT | wxEXPAND;

		// number
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "ID" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_number,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// type
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Type" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_type,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// pos
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Pos" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_pos,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// vel
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Vel" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_vel,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// polar vel
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "PolarVel" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_polar,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
    }
		// last move
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "LastMove" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_last_move,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// last move dist
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "MoveDist" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_last_move_dist,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// body
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Body" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_body,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// global & relative neck angle
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Head" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_head,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// stamina
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Stamina" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_stamina,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// effort
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Effort" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_effort,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// recovery
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Recovery" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_recovery,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// kick
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Kick" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_kick_count,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// dash
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Dash" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_dash_count,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// turn
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Turn" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_turn_count,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// say
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Say" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_say_count,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// turn neck
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "TurnNeck" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_turn_neck_count,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// catch
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Catch" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_catch_count,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// move
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Move" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_move_count,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// change view
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "ChgView" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_change_view_count,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}

    // -----------------------------------------------------------
#if 0
    {
        wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticLine( this, -1 ),
                    1, 0, 0 );
        panel_sizer->Add( sizer, 0, wxLEFT | wxRIGHT | wxEXPAND, 5 );
    }
#endif

		// ball rel
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "RelBall" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_ball_rel,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// ball polar
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "PolarBall" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_ball_polar,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// ball rel vel
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "RelBVel" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_ball_vel_rel,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		panel_sizer->SetSizeHints( this );
		this->SetAutoLayout( true );
		this->SetSizer( panel_sizer );
}

/*-------------------------------------------------------------------*/
/*!

*/
PlayerPanel::~PlayerPanel()
{
    //std::cerr << "delete PlayerPanel" << std::endl;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
PlayerPanel::update()
{
    if ( ! IsShown() )
    {
        return;
    }

    int number = M_main_data.viewConfig().selectedNumber();
    if ( number == 0 || std::abs( number ) > 11 )
    {
        return;
    }

    MonitorViewConstPtr v = M_main_data.getViewData( M_main_data.viewIndex() );
    if ( ! v )
    {
        std::cerr << __FILE__ << ":" << __LINE__
                  << " Null view data" << std::endl;
        return ;
    }

    //rcsc::SideID side = rcsc::LEFT;
    //int number = 5;
    //int idx = number - 1 + ( side == rcsc::rcg::LEFT ? 0 : 11 );
    int idx = std::abs( number ) - 1 + ( number > 0 ? 0 : 11 );
    const Player & p = v->players()[idx];
    const Ball & b = v->ball();
    const rcsc::PlayerType & ptype = M_main_data.viewHolder().playerType( p.type() );

		wxString temp;

    // side, number, type
    temp.Printf( wxT( "%s     %2d" ),
                 number > 0 ? wxT( "   Left" ) : wxT( "   Right" ),
                 number > 0 ? number : -number );
    M_number->SetLabel( temp );

    temp.Printf( wxT( " %d" ), p.type() );
    M_type->SetLabel( temp );

    // pos
		temp.Printf( wxT( " %6.2f, %6.2f" ), p.x(), p.y() );
		M_pos->SetLabel( temp );

    // velocity, speed, speed dir
		if ( p.hasDelta() )
		{
				rcsc::Vector2D vel( p.deltaX(), p.deltaY() );

        temp.Printf( wxT( " %6.2f, %6.2f" ), b.deltaX() - vel.x, b.deltaY() - vel.y );
        M_ball_vel_rel->SetLabel( temp );

				temp.Printf( wxT( " %6.2f, %6.2f" ), vel.x, vel.y );
				M_vel->SetLabel( temp );

				temp.Printf( wxT( " %6.3f, %6.1f" ), vel.r(), vel.th().degree() );
				M_polar->SetLabel( temp );

        vel /= ptype.playerDecay();
				temp.Printf( wxT( " %6.2f, %6.2f" ), vel.x, vel.y );
				M_last_move->SetLabel( temp );

				temp.Printf( wxT( " %6.3f" ), vel.r() );
				M_last_move_dist->SetLabel( temp );
		}

    // body angle
    temp.Printf( wxT( " %6.1f" ), p.body() );
    M_body->SetLabel( temp );

    // neck, head angle
    if ( p.hasView() )
    {
        rcsc::AngleDeg neck = p.head() - p.body();

        temp.Printf( wxT( " %6.1f(%6.1f)" ), p.head(), neck.degree() );
        M_head->SetLabel( temp );
    }

    // stamina, effort, recovery
    if ( p.hasStamina() )
    {
        temp.Printf( wxT( " %6.1f" ), p.stamina() );
        M_stamina->SetLabel( temp );

        temp.Printf( wxT( " %5.3f / %5.3f" ), p.effort(), ptype.effortMax() );
        M_effort->SetLabel( temp );

        temp.Printf( wxT( " %5.3f / 1.0" ), p.recovery() );
        M_recovery->SetLabel( temp );
    }

    // command count
    if ( p.hasCommandCount() )
    {
        temp.Printf( wxT( "  %5d" ), p.kickCount() );
        M_kick_count->SetLabel( temp );

        temp.Printf( wxT( "  %5d" ), p.dashCount() );
        M_dash_count->SetLabel( temp );

        temp.Printf( wxT( "  %5d" ), p.turnCount() );
        M_turn_count->SetLabel( temp );

        temp.Printf( wxT( "  %5d" ), p.sayCount() );
        M_say_count->SetLabel( temp );

        temp.Printf( wxT( "  %5d" ), p.turnNeckCount() );
        M_turn_neck_count->SetLabel( temp );

        temp.Printf( wxT( "  %5d" ), p.catchCount() );
        M_catch_count->SetLabel( temp );

        temp.Printf( wxT( "  %5d" ), p.moveCount() );
        M_move_count->SetLabel( temp );

        temp.Printf( wxT( "  %5d" ), p.changeViewCount() );
        M_change_view_count->SetLabel( temp );
    }


    // ball related info
    {
        rcsc::Vector2D player_to_ball( b.x() - p.x(), b.y() - p.y ());

        temp.Printf( wxT( " %6.2f, %6.2f" ), player_to_ball.x, player_to_ball.y );
        M_ball_rel->SetLabel( temp );

        temp.Printf( wxT( "%7.3f, %6.1f" ), player_to_ball.r(), player_to_ball.th().degree() );
        M_ball_polar->SetLabel( temp );
    }
}
