// -*-c++-*-

/*!
  \file player_panel.h
  \brief player info panel class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_WX_PLAYER_PANEL_H
#define SOCCERWINDOW2_WX_PLAYER_PANEL_H

class MainData;

//! player info panel
class PlayerPanel
    : public wxPanel {
private:
    const MainData & M_main_data;

    wxStaticText * M_number;
    wxStaticText * M_type;

    wxStaticText * M_pos;
    wxStaticText * M_vel;
    wxStaticText * M_polar;

    wxStaticText * M_last_move;
    wxStaticText * M_last_move_dist;

    wxStaticText * M_body;
    wxStaticText * M_head;

    wxStaticText * M_ball_rel;
    wxStaticText * M_ball_polar;

    wxStaticText * M_ball_vel_rel;

    //wxStaticText * M_view_width;
    //wxStaticText * M_view_quality;

    wxStaticText * M_stamina;
    wxStaticText * M_effort;
    wxStaticText * M_recovery;

    wxStaticText * M_kick_count;
    wxStaticText * M_dash_count;
    wxStaticText * M_turn_count;
    wxStaticText * M_say_count;
    wxStaticText * M_turn_neck_count;
    wxStaticText * M_catch_count;
    wxStaticText * M_move_count;
    wxStaticText * M_change_view_count;

    //! not used
    PlayerPanel();
    //! not used
    PlayerPanel( const PlayerPanel & );
    //! not used
    PlayerPanel & operator=( const PlayerPanel & );
public:
    //! constructor
    PlayerPanel( wxWindow * parent,
                 const MainData & main_data );

    ~PlayerPanel();

    void update();

};

#endif
