// -*-c++-*-

/*!
  \file player_type_dialog.cpp
  \brief player type list dialog Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#include <wx/grid.h>
#endif

#include "player_type_dialog.h"

#include "player_type_grid.h"
#include "id.h"
// model
#include "main_data.h"

#include <iostream>

/*-------------------------------------------------------------------*/
/*!

*/
PlayerTypeDialog::PlayerTypeDialog( wxWindow * parent,
                                    const MainData & main_data )
    : wxDialog( parent,
                -1,
                wxT( "Player Type Paramaters" ),
                wxPoint( 200, 0 ), //wxDefaultPosition // position
                wxDefaultSize,
                wxCAPTION | wxSYSTEM_MENU | wxCLOSE_BOX
                | wxRESIZE_BORDER
                )
    , M_main_data( main_data )
{
    M_player_type_table = new PlayerTypeGrid( this );
}

/*-------------------------------------------------------------------*/
/*!

*/
PlayerTypeDialog::~PlayerTypeDialog()
{
    //std::cerr << "delete PlayerTypeDialog" << std::endl; 
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
PlayerTypeDialog::Show( bool show )
{
    if ( show )
    {
        updateData();
        wxSize grid_size = M_player_type_table->GetVirtualSize();
        this->SetClientSize( std::min( 1000, grid_size.GetWidth() + 16 ),
                             grid_size.GetHeight() + 16 );
    }

    return wxDialog::Show( show );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
PlayerTypeDialog::updateData()
{
    M_player_type_table->setValues( M_main_data.viewHolder().playerTypeCont() );
}
