// -*-c++-*-

/*!
  \file score_board_painter.cpp
  \brief score board painter class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// for compliers supporting precompling
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// for compliers NOT supporting precompling
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "score_board_painter.h"

#include "draw_config.h"
// model
#include "main_data.h"
#include "monitor_view_data.h"

#include <iostream>

/*-------------------------------------------------------------------*/
/*!
*/
void
ScoreBoardPainter::draw( wxDC & dc ) const
{
    MonitorViewConstPtr view = M_main_data.getViewData( M_main_data.viewIndex() );

    if ( ! view )
    {
        return;
    }

    const ViewConfig & vconf = M_main_data.viewConfig();
    const DrawConfig & dconf = DrawConfig::instance();

    dc.SetPen( *wxTRANSPARENT_PEN );
    dc.SetBrush( dconf.scoreBoardBrush() );

    // screen coordinates
    wxCoord board_left_x = 0;
    wxCoord board_top_y = 0;
    // check score board width & start point x
    wxCoord board_width = vconf.canvasWidth();

    //------------------------------------------------
    // draw backbround
    dc.DrawRectangle( board_left_x,
                      board_top_y,
                      board_width,
                      vconf.scoreBoardHeight() );
    // draw left background
    dc.SetBrush( dconf.leftTeamBrush() );
    dc.DrawRectangle( board_left_x,
                      board_top_y,
                      board_width/3,
                      vconf.scoreBoardHeight() );
    // draw right background
    dc.SetBrush( dconf.rightTeamBrush() );
    dc.DrawRectangle( board_left_x + board_width*2/3,
                      board_top_y,
                      board_width/3 + 1,
                      vconf.scoreBoardHeight() );

    // draw team name, playmode & cycle
    dc.SetFont( dconf.scoreBoardFont() );
    dc.SetTextForeground( dconf.scoreBoardFontColor() );
    dc.SetTextBackground( dconf.scoreBoardFontColor() );

    wxString temp_str;
    wxCoord string_w, string_h, string_left_x, string_top_y;

    //------------------------------------------------
    // draw left team info
    if ( view->leftTeam().name().empty() )
    {
        temp_str = wxT( "left team" );
    }
    else
    {
        wxString tmp( view->leftTeam().name().c_str(),
                      *wxConvCurrent );
        tmp << wxT( "  " ) << view->leftTeam().score();
        temp_str = tmp;
        //temp_str.Printf( wxT( "%s  %2d" ),
        //view->leftTeam().name().c_str(),
        //view->leftTeam().score() );
    }
    // get the dimension of the string with current font
    dc.GetTextExtent( temp_str, &string_w, &string_h );
    string_left_x = board_left_x
        + ( ( board_width/3 - string_w ) / 2 );
    string_top_y = board_top_y
        + ( ( vconf.scoreBoardHeight() - string_h ) / 2 );
    dc.DrawText( temp_str, string_left_x, string_top_y );

    //------------------------------------------------
    // draw right team info
    if ( view->rightTeam().name().empty() )
    {
        temp_str = wxT( "right team" );
    }
    else
    {
        wxString tmp( view->rightTeam().name().c_str(),
                      *wxConvCurrent );
        tmp << wxT( "  " ) << view->rightTeam().score();
        temp_str = tmp;
        //temp_str.Printf( wxT( "%s  %2d" ),
        //view->rightTeam().name().c_str(),
        //view->rightTeam().score() );
    }
    // get the dimension of the string with current font
    dc.GetTextExtent( temp_str, &string_w, &string_h );
    string_left_x = board_left_x
        + board_width*2/3
        + ( ( board_width/3 - string_w ) / 2 );
    string_top_y = board_top_y
        + ( ( vconf.scoreBoardHeight() - string_h ) / 2 );
    dc.DrawText( temp_str, string_left_x, string_top_y );

    //------------------------------------------------
    // draw playmode & game cycle
    {
        wxString tmp( view->playmode().name().c_str(),
                      *wxConvCurrent );
        tmp << wxT( " " ) << view->cycle();
        temp_str = tmp;
    }
    // get the dimension of the string with current font
    dc.GetTextExtent( temp_str, &string_w, &string_h );
    string_left_x = board_left_x
        + board_width / 3
        + ( ( board_width/3 - string_w ) / 2 );
    string_top_y = board_top_y
        + ( ( vconf.scoreBoardHeight() - string_h ) / 2 );
    dc.DrawText( temp_str, string_left_x, string_top_y );
}
