// -*-c++-*-

/*!
  \file coach_config.h
  \brief coach configuration Header File
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCSC_COACH_CONFIG_H
#define RCSC_COACH_CONFIG_H

#include <string>

namespace rcsc {

class ParamMap;

/*!
  \class CoachConfig
  \brief coach configuration parameters
 */
class CoachConfig {
private:

    // basic setting

    std::string M_team_name; //!< our team name string
    std::string M_coach_name; //!< coach name string
    double      M_version; //!< client version

    //! if true coach should send its name by init command
    bool M_use_coach_name;

    //! select timeout interval
    int M_interval_msec;
    //! max server message wait time by second
    int M_server_wait_seconds;

    //! server host name
    std::string M_rcssserver_host;
    //! server port number
    int M_rcssserver_port;

    //! zlib compression level for the compression command
    int M_compression;

    //! if true, coach should send (eye on) command
    bool M_use_eye;

    //! if true, coach will try to analyze opponent team players' player type
    bool M_analyze_player_type;

    //! if true, coach send advise
    bool M_use_advise;
    //! if true, coach send freeform message
    bool M_use_freeform;

    //! use hetero player
    bool M_use_hetero;


public:

    /*!
      \brief init variables by default value. create parametermap
     */
    CoachConfig();

    /*!
      \brief nothing to do
     */
    ~CoachConfig();

    /*!
      \brief create parameter map
      \param param_map reference to the parameter map instance
     */
    void createParamMap( ParamMap & param_map );

private:
    /*!
      \brief set default value
    */
    void setDefaultParam();

public:

    // basic settings

    const
    std::string & teamName() const
      {
          return M_team_name;
      }
    const
    double & version() const
      {
          return M_version;
      }
    const
    std::string & coachName() const
      {
          return M_coach_name;
      }

    bool useCoachName() const
      {
          return M_use_coach_name;
      }

    int intervalMSec() const
      {
          return M_interval_msec;
      }

    int serverWaitSeconds() const
      {
          return M_server_wait_seconds;
      }

    const
    std::string & host() const
      {
          return M_rcssserver_host;
      }

    int port() const
      {
          return M_rcssserver_port;
      }

    int compression() const
      {
          return M_compression;
      }

    bool useEye() const
      {
          return M_use_eye;
      }

    bool analyzePlayerType() const
      {
          return M_analyze_player_type;
      }

    bool useAdvise() const
      {
          return M_use_advise;
      }

    bool useFreeForm() const
      {
          return M_use_freeform;
      }


    bool useHetero() const
      {
          return M_use_hetero;
      }

};

}

#endif
