#!/bin/sh

DIR=`dirname $0`

player="${DIR}/helios_player"
teamname="HELIOS2008"
host="localhost"

config="${DIR}/player.conf"
config_dir="${DIR}/formations-433"

number=0
goalie=

debugopt=""
coachdebug=""

usage()
{
  (echo "Usage: $0 [options]"
   echo "Possible options are:"
   echo "      --help                print this"
   echo "  -h, --host HOST           specifies server host"
   echo "  -n, --number NUMBER       specifies the reconnect player number"
   echo "  -g, --goalie              reconnect as a goalie") 1>&2
}

while [ $# -gt 0 ]
	do
	case $1 in

    --help)
      usage
      exit 0
      ;;

    -h|--host)
      if [ $# -lt 2 ]; then
        usage
        exit 1
      fi
      host=$2
      shift 1
      ;;

    -n|--number)
      if [ $# -lt 2 ]; then
        usage
        exit 1
      fi
      number=$2
      shift 1
      ;;

    -g|--goalie)
      goalie="-g"
      ;;

    *)
      usage
      exit 1
      ;;
  esac

  shift 1
done

if [ $number -eq 0 ]; then
  echo "ERROR: The reconnect player number is a mandatory option."
  echo ""
  usage
  exit 1
fi

OPT="-h ${host} -t ${teamname} -r ${number} ${goalie}"
OPT="${OPT} --player-config ${config} --config_dir ${config_dir}"
OPT="${OPT} ${debugopt}"

$player ${OPT} &

