// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "bhv_block_ball_kicker.h"

#include "bhv_basic_move.h"
#include "bhv_basic_tackle.h"

#include <rcsc/action/basic_actions.h>
#include <rcsc/action/bhv_go_to_point_look_ball.h>
#include <rcsc/action/body_go_to_point.h>
#include "body_intercept2008.h"
#include <rcsc/action/neck_turn_to_ball_or_scan.h>
#include <rcsc/action/neck_scan_field.h>

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>

#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

/*-------------------------------------------------------------------*/
/*!
  execute action
*/
bool
Bhv_BlockBallKicker::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        __FILE__": Bhv_BlockBallKicker" );

    // opponent not exist
    if ( agent->world().opponentsFromBall().empty() )
    {
        return Bhv_BasicMove( M_home_pos ).execute( agent );
    }

    // not kickable
    if ( ! agent->world().existKickableOpponent() )
    {
        if ( rcsc::Body_Intercept2008().execute( agent ) )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                __FILE__": chase ball" );
            agent->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
            return true;
        }
    }

    //////////////////////////////////////////////////
    // tackle
    if ( Bhv_BasicTackle( 0.75, 80.0 ).execute( agent ) )
    {
        return true;
    }

    const rcsc::PlayerObject * opp = agent->world().opponentsFromBall().front();
    if ( ! opp )
    {
        rcsc::Bhv_GoToPointLookBall( M_home_pos,
                                     0.5,
                                     45.0
                                     ).execute( agent );
        return true;
    }

    rcsc::Vector2D target_point = opp->pos();


    double buffer = std::min( 7.0, opp->distFromSelf() );
    buffer = std::max( buffer, 2.0 );
    double dash_power = rcsc::ServerParam::i().maxPower();

    if ( opp->distFromSelf() < buffer )
    {
        target_point.x -= 0.2;
        if ( agent->world().self().pos().dist( target_point ) < 2.5 )
        {
            dash_power *= 0.5;
        }
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": attack to (%.1f, %.1f)",
                            target_point.x, target_point.y );
        rcsc::Body_GoToPoint( target_point,
                              0.1,
                              rcsc::ServerParam::i().maxPower()
                              ).execute( agent );
        agent->setNeckAction( new rcsc::Neck_TurnToBall() );
        return true;
    }


    target_point.x -= buffer;

    if ( agent->world().self().pos().dist( target_point ) < 1.3 )
    {
        dash_power *= 0.5;
    }
    else
    {
        dash_power *= 0.7;
    }

    agent->debugClient().addMessage( "block" );
    agent->debugClient().setTarget( target_point );
    agent->debugClient().addCircle( target_point, 0.5 );
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        __FILE__": go to (%.1f, %.1f)",
                        target_point.x, target_point.y );
    rcsc::Bhv_GoToPointLookBall( target_point,
                                 0.5,
                                 dash_power
                                 ).execute( agent );
    return true;
}
