// -*-c++-*-

/*!
  \file home_positions.h
  \brief home position holder Header File
*/

/*
 *Copyright:

  Copyright (C) Hidehisa AKIYAMA

  This code is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  This code is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this code; see the file COPYING.  If not, write to
  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef HELIOS_HOME_POSITIONS_H
#define HELIOS_HOME_POSITIONS_H

#include <rcsc/geom/vector_2d.h>

#include <iostream>
#include <vector>

namespace rcsc {

class Formation;
class GameTime;

}

/*!
  \class HomePositions
  \brief singleton class
*/
class HomePositions {
public:
    enum SideType {
        SIDE = -1, //!< original type, consider all region
        MIRROR = 1, //!< copy type, refere SIDE
        CENTER = 0, //!< original type, consider half region
    };

private:

    int M_number; //!< my position number

    std::vector< SideType > M_side_types;

    std::vector< rcsc::Vector2D > M_positions;

    // not used
    HomePositions( const HomePositions & );
    HomePositions & operator=( const HomePositions & );

    //! private for singleton
    HomePositions();
public:

    static
    HomePositions & instance();

    static
    const
    HomePositions & i()
      {
          return instance();
      }

    void update( const int my_number,
                 const rcsc::Formation & formation,
                 const rcsc::Vector2D & focus_point,
                 const rcsc::GameTime & current );

    int number() const
      {
          return M_number;
      }

    rcsc::Vector2D get( const int number ) const
      {
          if ( number < 1 || 11 < number )
          {
              std::cerr << __FILE__ << ' ' << __LINE__
                        << ": Illegal number : " << number
                        << std::endl;
              return rcsc::Vector2D::INVALIDATED;
          }
          return M_positions[number - 1];
      }

    SideType sideType( const int number ) const
      {
          if ( number < 1 || 11 < number )
          {
              std::cerr << __FILE__ << ' ' << __LINE__
                        << ": Illegal number : " << number
                        << std::endl;
              return CENTER;
          }
          return M_side_types[number - 1];
      }

};

#endif
