/*
 *	vc8_std_define_supply.h
 *
 *	NOTE
 *
 *	1. You have to remove the following including manually
 *
 *	<sys/time.h>		- time.cpp
 *	<unistd.h>			- basic_client.cpp
 *	<sys/select.h>		- basic_client.cpp
 *	<sys/time.h>		- basic_client.cpp
 *	<sys/types.h>		- basic_client.cpp
 *
 *	2. Also you may choose to define one of the following types
 *
 *	ROBOCUP_TRAINER for trainer ( implemented in main_trainer.cpp )
 *	ROBOCUP_PLAYER	for client	( implemented in main_player.cpp )
 *	ROBOCUP_COACH	for coach	( implemented in main_coach.cpp )
 *
 *	3. To start socket under windows os, you should initialize network 
 *
 *	(udp_socket.cpp)
 *
 *	WSADATA wsaData;
 *	int iResult = WSAStartup(MAKEWORD(2,2), &wsaData);
 *
 *	4. To start player you may use parameter as
 *
 *	(coach)
 *	-g -h 127.0.0.1 --player-config player.conf --config_dir .\formations-dt
 *	(player)
 *	-h 127.0.0.1 --player-config player.conf --config_dir .\formations-dt
 *
 *
 *
 *	Created by huqian 2007/08/28
 */

#ifndef VC8_STD_DEFINE_SUPPLY_H
#define VC8_STD_DEFINE_SUPPLY_H

#if !defined(ROBOCUP_TRAINER) && !defined(ROBOCUP_COACH)
	#define ROBOCUP_PLAYER
#endif


#ifdef _MSC_VER

	#ifndef WINVER
		#define  WINVER  0x0400
	#endif

	// remove std warning under VC6
	#pragma   warning   (disable   :   4786)

	// deprecated warning
	#pragma   warning   (disable   :   4996)

	// 'this' : used in base member initializer list
	#pragma   warning   (disable   :   4355)

	// supply the std function that lost under VC6
	#include <ctype.h>
	#include <TIME.H>
	#include <cstdlib>
	#include <cstring>
	#include <iostream>
	#include <fstream>
	#include <vector>
	#include <list>
	#include <set>
	#include <utility>
	#include <string>
	#include <algorithm>

	#include <afxmt.h>
	#include <WINSOCK2.H>
	#include <MATH.H>
	#include <float.h>
	#include <sys/timeb.h>

	// remove max and min define
	#ifdef max
	#undef max
	#endif

	#ifdef min
	#undef min
	#endif

	// debug printf( #define DEBUG ) takes a lot of time, so I disable it
	#ifdef DEBUG
	#undef DEBUG
	#endif

	// we can use socket in VC8
	#define HAVE_SOCKET
	#define HAVE_GETHOSTBYNAME

	// implement linux rint()
	inline double rint(double x)
	{
		return floor(x+.5);
	};

	// implement linux gettimeofday()
	inline int gettimeofday( struct timeval* t, void* timezone )
	{
		struct _timeb timebuffer;
		_ftime( &timebuffer );
		t->tv_sec = (long)timebuffer.time;
		t->tv_usec = 1000*timebuffer.millitm;
		return 0;
	};

	// some of std functions still have not been supported by microsoft vc
	// so use the os default function instead of std.
	namespace std{

		using ::isspace;
		using ::srand;
		using ::time; 
		using ::size_t;
		using ::memset;
		using ::strncpy;

		using ::fabs;
		using ::cos;
		using ::sin;
		using ::tan;
		using ::acos;
		using ::asin;
		using ::pow;
		using ::exp;
		using ::log;
		using ::atan;
		using ::atan2;
		using ::rint;
		using ::sqrt;
		using ::floor;
		using ::ceil;
		using ::strlen;

		using ::sscanf;
		using ::strncmp;
		using ::sprintf;

		using ::strtod;
		using ::strtol;

		using ::atoi;
		using ::strcpy;
		using ::fopen;
		using ::strcmp;

		using ::isdigit;

		inline int snprintf(
			   char *buffer,
			   size_t count,
			   const char *format,
			   ... 
			)
		{
			va_list argptr;
			va_start(argptr,format);
			int iRet =vsprintf(buffer, format, argptr);
			va_end(argptr);
			return iRet;
		};

	};
	
	// implement some linux network functions and const

	inline int fcntl(...){return 0;};
	inline int close( int socket ){ return closesocket( socket ); };

	const int F_SETFD		=0;
	const int FD_CLOEXEC	=0;
	const int F_GETFL		=0;
	const int F_SETFL		=0;
	const int O_NONBLOCK	=0;

	typedef signed long int32_t;
	typedef int		socklen_t;
	const int EWOULDBLOCK = WSAEWOULDBLOCK;

	const double M_PI = 3.14159265358979323846;

#endif

#endif
