#include "StdAfx.h"
#include "CommandList.h"


CCommandList* CCommandList::_instance	= NULL;

CCommandList::CCommandList(void)
: m_bAvaliable(false)
{
}

CCommandList::~CCommandList(void)
{
}

bool CCommandList::Load(const char *szRCL_Filename)
{
	

	CStdioFile	file;
	if( !file.Open( szRCL_Filename, CFile::modeRead ) )
		return false;

	Clear();
	CString strLine;
	while( file.ReadString( strLine ) )
	{
		strLine.TrimRight();
		strLine.TrimLeft();
		if( strLine.GetLength() == 0 ||
			strLine.Find("Recv ") == -1 ||
			strLine.Find(": ") == -1 )
		{
			continue;
		}

		size_t nLoop(0), nNum(0);
		std::string	strTeamname;

		nLoop = atol( (LPCTSTR) strLine );
		CString str = strLine.Mid( strLine.Find("Recv ")+5,
			strLine.Find(": ")-strLine.Find("Recv ")-5 );
		if(str.Right( str.GetLength() - str.ReverseFind('_') - 1 ).GetLength() > 2)
			continue;

		nNum = atol( (LPCTSTR) str.Right( str.GetLength() - str.ReverseFind('_') - 1 ) );
		nNum--;
		strTeamname = (LPCTSTR)str.Left( str.ReverseFind('_') );

		if( m_strLeftTeamname.empty() )
		{
			m_strLeftTeamname = strTeamname;
		}
		else if( m_strLeftTeamname.compare( strTeamname ) == 0 )
		{
		}
		else if( m_strRightTeamname.empty() )
		{
			m_strRightTeamname = strTeamname;
			nNum += 11;
		}
		else if( m_strRightTeamname.compare( strTeamname ) == 0 )
		{
			nNum += 11;
		}
		else
			continue;

		if( nNum >= 22 )
			continue;

		if( m_cmdlist[nNum].find(nLoop) == m_cmdlist[nNum].end() )
		{
			m_cmdlist[nNum][nLoop] = "";
		}
		m_cmdlist[nNum][nLoop] = (LPCTSTR)(CString(m_cmdlist[nNum][nLoop].c_str()) + 
			strLine.Right( strLine.GetLength() - strLine.Find(": ") - 2 ));
	}
	file.Close();
	m_bAvaliable = true;

	return true;
}

void CCommandList::Clear()
{
	for( size_t i=0; i<22; i++ )
	{
		m_cmdlist[i].clear();
	}

	m_strLeftTeamname = m_strRightTeamname = "";
	m_bAvaliable = false;
}

bool CCommandList::GetPlayer(size_t nNum, std::map<int,std::string> **ppcmdlist )
{
	if( nNum >= 22 )
		return false;

	*ppcmdlist = &( m_cmdlist[nNum] );
	return true;
}
