/*
 *	StepDebug_Define.h
 *
 *
 *	If you get the error
 *		error LNK2005: "void * __cdecl operator new(unsigned int)" already defined
 *	You can resolve it by following step
 *		Configuration Settings-->Build-->Compiler-->Preprocessor Options: -D_AFXDLL -MD
 *		Configuration Settings-->Build-->Linker-->Link Flags: /nodefaultlib:msvcrt 
 *
 *	Created by huqian 2007/09/03
 */

#ifndef STEPDEUB_DEFINE_H
#define STEPDEUB_DEFINE_H

// _dbRegCode
enum
{
	// ----- STEPDEBUG_INDEX struct ----- 

	REGCODE_INDEX_LOG				= 0xABCE0000,

	// ----- WorldModel object ----- 

	REGCODE_WorldModel				= 0xABCD0001,

	REGCODE_Localization			= 0xABCD0002,
	REGCODE_InterceptTable			= 0xABCD0003,
	REGCODE_InterceptTable1			= 0xABCD0004,	// InterceptTable::M_ball_pos_cache
	REGCODE_InterceptTable2			= 0xABCD0005,	// InterceptTable::M_self_cache
	REGCODE_PenaltyKickState		= 0xABCD0006,

	REGCODE_WM_PlayerCont			= 0xABCD0005,
	REGCODE_WM_PlayerPtrCont		= 0xABCD0006,
	REGCODE_SelfObject				= 0xABCD0007,

	// ----- PlayerConfig object ----- 

	REGCODE_PlayerConfig			= 0xABCD0010,

	// ----- ActionEffector object ----- 

	REGCODE_ActionEffector			= 0xABCD0020,

	// ----- PlayerAgentImpl object ----- 

	REGCODE_PlayerAgentImpl			= 0xABCD0030,
	REGCODE_PAI_VisualSensor		= 0xABCD0031,
	REGCODE_PAI_AudioSensor			= 0xABCD0032,
	REGCODE_PAI_FullstateSensor		= 0xABCD0033,
	REGCODE_PAI_arm_action_			= 0xABCD0034,
	REGCODE_PAI_neck_action_		= 0xABCD0035,
	REGCODE_PAI_view_action_		= 0xABCD0036,
	REGCODE_PAI_intention_			= 0xABCD0037,

	REGCODE_PAI_VisualSensor_BallCont	= 0xABCD0038,
	REGCODE_PAI_VisualSensor_MarkerCont	= 0xABCD0039,
	REGCODE_PAI_VisualSensor_LineCont	= 0xABCD003A,
	REGCODE_PAI_VisualSensor_PlayerCont	= 0xABCD003B,

	REGCODE_PAI_AudioSensor_info			= 0xABCD003C,

	REGCODE_PAI_FullstateSensor_PlayerCont	= 0xABCD003D

};

// the head structure before each object data piece, in data log file (*.dlog)
struct STEPDEBUG_HEAD
{
	DWORD	_dwRegCode;
	DWORD	_dwSize;
	char	_pData[1];

	STEPDEBUG_HEAD()
	{
		memset( this, 0, sizeof( STEPDEBUG_HEAD ) );
	}

	size_t size()
	{
		return 2 * sizeof( DWORD );
	}

};

// the structure of data, in index log file (*.ilog)
struct STEPDEBUG_INDEX
{
	DWORD	_dwRegCode;
	DWORD	_dwPosition;
	DWORD	_dwIndex;
	DWORD	_dwLoop;

	STEPDEBUG_INDEX()
	{
		memset( this, 0, sizeof( STEPDEBUG_INDEX ) );
		_dwRegCode = REGCODE_INDEX_LOG;
	}
};

#endif