// -*-c++-*-

/*!
  \file body_stop_dash.cpp
  \brief try to change the agent's velocity to 0.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 3 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "body_stop_dash.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

namespace rcsc {

/*-------------------------------------------------------------------*/
/*!

*/
bool
Body_StopDash::execute( PlayerAgent * agent )
{
    dlog.addText( Logger::ACTION,
                  __FILE__": Body_StopDash" );

    const WorldModel & wm = agent->world();

    if ( ! wm.self().velValid() )
    {
        dlog.addText( Logger::ACTION,
                      __FILE__": self vel is invalid" );
        agent->doTurn( 0.0 );
        return false;
    }

    // velocity relative to body angle
    Vector2D rotated_vel = wm.self().vel();
    rotated_vel.rotate( - wm.self().body() );

    if ( rotated_vel.absX() < 0.05 )
    {
        dlog.addText( Logger::ACTION,
                      __FILE__": stop dash is not required. relative vel=%f",
                      rotated_vel.x );
        return false;
    }

    // calc the power to reduce current speed
    double power = - rotated_vel.x / wm.self().dashRate();

    power = ServerParam::i().normalizePower( power );

    if ( M_save_recovery )
    {
        power = wm.self().getSafetyDashPower( power );
    }

    if ( std::fabs( power ) < 0.5 )
    {
        dlog.addText( Logger::ACTION,
                      __FILE__": too small dash power=%f",
                      power );
        return false;
    }

    dlog.addText( Logger::ACTION,
                  __FILE__": stop dash power=%.1f, accel=%.3f",
                  power, power * wm.self().dashRate() );

    return agent->doDash( power );
}

}
