// -*-c++-*-

/*!
  \file stete debug_client_parser.h
  \brief state debug client paket parser class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA, Hiroki SHIMORA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef STATE_DEBUG_CLIENT_PARSER_H
#define STATE_DEBUG_CLIENT_PARSER_H

namespace rcsc
{
class StaticPredictState;
}

/*!
  \class StaticPredictState
  \brief the class that is used to parse debug client packat to state.
*/
class StateDebugClientParser {
private:
    char M_side; //!< sender's side
    int M_unum; //!< sender's unum
    int M_cycle; //!< cycle of sent data

public:
    StateDebugClientParser()
        : M_side( 'n' )
        , M_unum( 0 )
        , M_cycle( -1 )
      { }

    bool parse( const char * msg,
                rcsc::StaticPredictState * state );

private:
    bool parseV2( const char * msg,
                  rcsc::StaticPredictState * state );


    int parseTime( const char * tok,
                   rcsc::StaticPredictState * debug_view );

    int parseBall( const char * tok,
                   rcsc::StaticPredictState * debug_view );
    int parseSelf( const char * tok,
                   rcsc::StaticPredictState * debug_view );
    int parsePlayer( const char * tok,
                     rcsc::StaticPredictState * debug_view );
    int parseLine( const char * tok,
                   rcsc::StaticPredictState * debug_view );
    int parseTriangle( const char * tok,
                       rcsc::StaticPredictState * debug_view );
    int parseRectangle( const char * tok,
                        rcsc::StaticPredictState * debug_view );
    int parseCircle( const char * tok,
                     rcsc::StaticPredictState * debug_view );
    int parseTargetTeammate( const char * tok,
                             rcsc::StaticPredictState * debug_view );
    int parseTargetPoint( const char * tok,
                          rcsc::StaticPredictState * debug_view );
    int parseMessage( const char * tok,
                      rcsc::StaticPredictState * debug_view );
    int parseSayMessage( const char * tok,
                         rcsc::StaticPredictState * debug_view );
    int parseHearMessage( const char * tok,
                          rcsc::StaticPredictState * debug_view );

};

#endif
