// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hiroki SHIMORA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "file_evolutional_repository.h"
#include <fstream>
#include <iostream>

namespace {
static std::string replace_white_spaces( const std::string & str );
}



namespace rcsc {

FileEvolutionalRepository::FileEvolutionalRepository( const std::string & path )
    : M_path( path )
    , M_file_found( false )
    , M_values()
{
    std::ifstream file( path.c_str() );

    if ( file )
    {
        M_file_found = true;
    }
    else
    {
        std::cerr << "Can't open file: " << M_path << std::endl;
        M_file_found = false;
        return;
    }

    for(;;)
    {
        std::string line;
        std::getline( file, line );

        if ( file.eof() || ! file )
        {
            break;
        }

        if ( line.empty() || line[0] == '#' )
        {
            continue;
        }


        std::string key;
        bool colon_found = false;
        size_t i = 0;

        for ( i = 0; i < line.length(); ++i )
        {
            if ( line[i] == ':' )
            {
                colon_found = true;
                i ++;
                break;
            }

            key += line[i];
        }

        for ( ; i < line.length(); ++ i )
        {
            if ( line[i] != ' ' && line[i] != '\t' )
            {
                break;
            }
        }

        std::string value( line, i );

        if ( ! colon_found )
        {
            std::cerr << "parse error: [" << line << "]" << std::endl;
            return;
        }


        value = replace_white_spaces( value );

        if ( value.empty() || value == "{" )
        {
            for(;;)
            {
                std::string value_line;
                std::getline( file, value_line );

                if ( file.eof() || ! file )
                {
                    std::cerr << "parse error: unexpected EOF" << std::endl;
                    return;
                }

                if ( value_line.empty() || line[0] == '#' )
                {
                    continue;
                }

                value_line = replace_white_spaces( value_line );

                value += value_line;

                if ( value_line == "}" )
                {
                    break;
                }
            }
        }

        M_values.insert( MapType::value_type( key, value ) );
    }
}

FileEvolutionalRepository::~FileEvolutionalRepository()
{
}

bool
FileEvolutionalRepository::isValid() const
{
    return M_file_found;
}

void
FileEvolutionalRepository::getValue( const std::string & name,
                                     std::string * value,
                                     std::string * id )
{
    MapType::const_iterator it = M_values.find( name );

    if ( it == M_values.end() )
    {
        std::cerr << name << ": not found in file \"" << M_path << "\"."
                  << std::endl;

        *value = "";
    }
    else
    {
        *value = (*it).second;
    }

    *id = "";
}

void
FileEvolutionalRepository::evaluate( const std::string &,
                                     const std::string &,
                                     double )
{
    // no operation is needed for evaluate()
}

void
FileEvolutionalRepository::evaluationCancel( const std::string &,
                                             const std::string & )
{
    // no operation is needed for evaluationCancel()
}

}

namespace {

static
std::string replace_white_spaces( const std::string & str )
{
    std::string ret;

    for ( size_t i = 0 ; i < str.length() ; ++i )
    {
        if ( str[i] != ' ' && str[i] != '\t' )
        {
            ret += str[i];
        }
    }

    return ret;
}

}

