// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hiroki SHIMORA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCSC_EVS_FILE_EVOLUTIONAL_REPOSITORY_H
#define RCSC_EVS_FILE_EVOLUTIONAL_REPOSITORY_H

#include "evolutional_repository.h"
#include <map>
#include <string>
#include <fstream>
#include <cctype>

namespace rcsc {

class FileEvolutionalRepository : public EvolutionalRepository {
private:
    typedef std::map<std::string, std::string> MapType;

private:
    const std::string M_path;
    bool M_file_found;
    MapType M_values;

public:
    FileEvolutionalRepository( const std::string &  path );

    virtual
    ~FileEvolutionalRepository();

    virtual
    bool isValid() const;

    virtual
    void getValue( const std::string & name,
                   std::string * value,
                   std::string * id );

    virtual
    void evaluate( const std::string &,
                   const std::string &,
                   double );

    virtual
    void evaluationCancel( const std::string &,
                           const std::string & );
};

}

#endif
