// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hiroki SHIMORA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "variable_repository.h"

using namespace rcsc;

VariableRepository * VariableRepository::S_instance;

/*-------------------------------------------------------------------*/
/*!

*/
bool
VariableRepository::initialize( const boost::shared_ptr<EvolutionalRepository> & rep )
{
    S_instance = new VariableRepository( rep );

    return S_instance->isValid();
}


/*-------------------------------------------------------------------*/
/*!

*/
VariableRepository &
VariableRepository::instance()
{
    return *S_instance;
}

/*-------------------------------------------------------------------*/
/*!

*/
VariableRepository &
VariableRepository::i()
{
    return instance();
}


/*-------------------------------------------------------------------*/
/*!

*/
VariableRepository::VariableRepository( const boost::shared_ptr<EvolutionalRepository> & rep )
    : M_rep( rep )
{
}


/*-------------------------------------------------------------------*/
/*!

*/
bool
VariableRepository::isValid() const
{
    return M_rep && M_rep->isValid();
}


/*-------------------------------------------------------------------*/
/*!

*/
double
VariableRepository::getFloatValue( const std::string & realm,
                                   const std::string & name ) const
{
    CacheMapType::const_iterator it = M_cache.find( realm );
    if ( it == M_cache.end() )
    {
        boost::shared_ptr< EvolutionalStruct >
            s( new rcsc::EvolutionalStruct( M_rep, realm ) );

        M_cache[ realm ] = s;

        return s ->getFloatValue( name );
    }

    return ((*it).second)->getFloatValue( name );
}
