// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hiroki SHIMORA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef VARIABLE_REPOSITORY_H
#define VARIABLE_REPOSITORY_H

#include "evolutional_variable.h"
#include "evolutional_repository.h"
#include <rcsc/game_time.h>

#include <boost/shared_ptr.hpp>

#include <map>
#include <string>


namespace rcsc {

class VariableRepository {

private:
    //! evolutional repository
    boost::shared_ptr<EvolutionalRepository> M_rep;

private:
    //! time to handle cache
    GameTime M_cache_time;

    //! cache type definition
    typedef std::map< std::string, boost::shared_ptr< rcsc::EvolutionalStruct > > CacheMapType;
    //! cache
    mutable CacheMapType M_cache;

public:
    bool isValid() const;

    double getFloatValue( const std::string & realm,
                          const std::string & name ) const;

private:
    VariableRepository( const boost::shared_ptr<EvolutionalRepository> & rep );

    //! inhibit instantiation, no implementation
    VariableRepository( const VariableRepository & );
    //! inhibit instantiation, no implementation
    VariableRepository& operator = ( const VariableRepository & );

    static VariableRepository * S_instance;

public:
    static
    bool initialize( const boost::shared_ptr<EvolutionalRepository> & rep );

    static
    VariableRepository & instance();

    static
    VariableRepository & i();
};

}

#endif
