// -*-c++-*-

/*!
  \file cross_generator.h
  \brief cross pass generator Header File
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef CROSS_GENERATOR_H
#define CROSS_GENERATOR_H

#include "pass.h"

#include <rcsc/player/abstract_player_object.h>
#include <rcsc/geom/vector_2d.h>
#include <rcsc/game_time.h>

#include <vector>

namespace rcsc {
class PlayerObject;
class WorldModel;
}


class CrossGenerator {
private:
    int M_total_count;

    const rcsc::AbstractPlayerObject * M_passer; //!< estimated passer player
    rcsc::GameTime M_start_time;
    rcsc::Vector2D M_first_point;

    rcsc::AbstractPlayerCont M_receiver_candidates;

    std::vector< Pass::Ptr > M_courses;


    // private for singleton
    CrossGenerator();

    // not used
    CrossGenerator( const CrossGenerator & );
    CrossGenerator & operator=( const CrossGenerator & );

public:

    static
    CrossGenerator & instance();

    void update( const rcsc::WorldModel & wm );

    const std::vector< Pass::Ptr > courses( const rcsc::WorldModel & wm )
      {
          update( wm );
          return M_courses;
      }

private:

    void clear();

    void updatePasser( const rcsc::WorldModel & wm );
    void createReceivers( const rcsc::WorldModel & wm );

    void createCourses( const rcsc::WorldModel & wm );
    void createCourses( const rcsc::WorldModel & wm,
                        const rcsc::AbstractPlayerObject * receiver );
    int predictReceiverReachStep( const rcsc::AbstractPlayerObject * receiver,
                                  const rcsc::Vector2D & first_ball_pos,
                                  const rcsc::Vector2D & first_ball_vel );
    int predictOpponentReachStep( const rcsc::WorldModel & wm,
                                  const rcsc::Vector2D & first_ball_pos,
                                  const rcsc::Vector2D & first_ball_vel,
                                  const int max_step );
    int predictOpponentReachStep( const rcsc::PlayerObject & opponent,
                                  const rcsc::Vector2D & first_ball_pos,
                                  const rcsc::Vector2D & first_ball_vel,
                                  const rcsc::AngleDeg & ball_move_angle,
                                  const int max_step );
};

#endif
