/*-----------------------------------------------------------------------------
Modul Name : Agentsock.cpp
Date       : 30.10.97
-------------------------------------------------------------------------------
Author     : Klaus Dorer

Description: Socket class for communication with soccerserver

Comments   : _
-----------------------------------------------------------------------------*/

#include "stdafx.h"
#include "Soccermonitor.h"
#include "Agentsock.h"
#include "SoccermonitorDoc.h"
#include "TLogPlayer.h"

#include <stddef.h>
//#include "atlconv.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNAMIC(CAgentSocket, CAsyncSocket)


/*-----------------------------------------------------------------------------
Function: CAgentSocket::CAgentSocket(CSoccermonitorDoc* pDoc)
Date    : 30.10.97
-------------------------------------------------------------------------------
Parameter: pointer to the Agent Object containing this socket
Description: constructor
-----------------------------------------------------------------------------*/
CAgentSocket::CAgentSocket(CSoccermonitorDoc* pDoc)
{
	m_pDoc = pDoc;
	m_uiPort = 0;
	m_sSocketAddress = _T("");
}

CAgentSocket::CAgentSocket()
{
	m_pDoc = NULL;
	m_uiPort = 0;
	m_sSocketAddress = _T("");
}

/*-----------------------------------------------------------------------------
Function: void CAgentSocket::OnReceive(int nErrorCode)
Date    : 30.10.97
-------------------------------------------------------------------------------
Parameter: error code ?
Returnval: (void)
Description: called when a messege is on the socket, which can be read
-----------------------------------------------------------------------------*/
void CAgentSocket::OnReceive(int nErrorCode)
{
	CAsyncSocket::OnReceive(nErrorCode);
	ReceiveMsg();	
}

void CAgentSocket::OnClose(int nErrorCode)
{
#ifdef _DEBUG
	TRACE2("Socket closed: %d, Last Error: %d\n", nErrorCode, GetLastError());
#endif
}

/*-----------------------------------------------------------------------------
Function: BOOL CAgentSocket::ConnectSocket(LPCTSTR lpszAddress, UINT nPort)
Date    : 31.10.97
-------------------------------------------------------------------------------
Parameter: string containing the servers address
			  port of the socket
Returnval: TRUE, if the socket could be created and bound
Description: creates a socket 
-----------------------------------------------------------------------------*/
BOOL CAgentSocket::ConnectSocket(LPCTSTR lpszAddress, UINT nPort)
{
	// create the socket
	if (!Create(nPort, SOCK_DGRAM
				  , FD_READ | FD_WRITE | FD_CLOSE, lpszAddress))
	{
		// socket could not be created
		#ifdef _DEBUG
			afxDump << "socket could not be created or bound \n";
		#endif
		return FALSE;
	}
	
	return TRUE;
}

/*-----------------------------------------------------------------------------
Function: void CAgentSocket::SendMsg(LPCSTR strText)
Date    : 18.11.97
-------------------------------------------------------------------------------
Parameter: message to be sent
Returnval: (void)
Description: the message is sent to the socket by SendTo (unconnected socket)
-----------------------------------------------------------------------------*/
void CAgentSocket::SendMsg(LPCSTR text)
{
	int		iLength;
	CString	strText(text);
	
	// send the buffer
	iLength = SendTo(strText, strText.GetLength()
						 , m_uiPort, m_sSocketAddress, 0);
	if ( iLength != strText.GetLength() )
	{
		// an error occured
		#ifdef _DEBUG
			TRACE1("Error sending via socket: %d\n", GetLastError());
		#endif
	}
}

/*-----------------------------------------------------------------------------
Function: void CAgentSocket::ReceiveMsg()
Date    : 18.11.97
-------------------------------------------------------------------------------
Parameter: none
Returnval: (void)
Description: a message is received from the socket and processed by the agent
-----------------------------------------------------------------------------*/
void CAgentSocket::ReceiveMsg()
{
	int  iLength = 0;
	UINT iPort = m_uiPort;
	int  iPosition = 0;
    TLogPlayer *player = m_pDoc->logplayer();
    int ver = 1;
/*
	int	size;
	int	bufsize = sizeof(int);
	GetSockOpt( SO_RCVBUF, (void*) &size, &bufsize);
*/
	// read a message from the socket
    if ( player && player->protocolVersion() >= 2 )
    {
    	iLength = ReceiveFrom((char*)&m_tInfo2, sizeof(dispinfo_t2),
                              m_sSocketAddress, iPort, 0);
        ver = 2;
    }
    else
    {
        iLength = ReceiveFrom((char*)&m_tInfo, sizeof(dispinfo_t),
                              m_sSocketAddress, iPort, 0);
    }

#ifdef _DEBUG
	int i = GetLastError();
	if ( i != 0 )
    {
		TRACE1("Receive: %d\n", i);
    }
#endif

	// the port may have changed
	m_uiPort = iPort;

	if ( iLength > 0 )
	{
        if ( ver == 2 )
        {
    		// no error occured
	    	// now all shorts have to be converted from high endian to low endian
		    ConvShort(m_tInfo2.mode);
    		switch ( m_tInfo2.mode )
	    	{
               	case NO_INFO:
                    break;
    			case SHOW_MODE:
	    			// show info was received
		    		m_pDoc->NewInfo(&m_tInfo2.body.show);
			    	break;
    			case MSG_MODE:
                    // msg was received
                    //ConvShort(m_tInfo2.body.msg.board);
                    //m_pDoc->NewMsg(&m_tInfo2.body.msg);
                    break;
                case DRAW_MODE:
                    break;
                case BLANK_MODE:
                    break;
                case PM_MODE: // playmode
                    break;
                case TEAM_MODE:
                    break;
                case PT_MODE:
                    m_pDoc->newParam(&m_tInfo2.body.ptinfo);
                    break;
                case PARAM_MODE:
                    m_pDoc->newParam(&m_tInfo2.body.sparams);
                    break;
                case PPARAM_MODE:
                    m_pDoc->newParam(&m_tInfo2.body.pparams);
                    break;
                default:
                    break;
            }
        }
        else
        {
		    ConvShort(m_tInfo.mode);
    		switch ( m_tInfo.mode )
	    	{
               	case NO_INFO:
                    break;
    			case SHOW_MODE:
	    			// show info was received
		    		m_pDoc->newInfo(&m_tInfo.body.show);
			    	break;
    			case MSG_MODE:
                    // msg was received
                    //ConvShort(m_tInfo2.body.msg.board);
                    //m_pDoc->NewMsg(&m_tInfo.body.msg);
                    break;
                default:
                    break;
            }
        }
	}
	else
	{
		// an error occured
		#ifdef _DEBUG
			TRACE1("Error reading socket: %d\n", GetLastError());
		#endif
	}
}


/*-----------------------------------------------------------------------------
Function: BOOL CAgentSocket::Create(UINT nSocketPort, int nSocketType
												, long lEvent, LPCTSTR lpszSocketAddress)
Date    : 30.10.97
-------------------------------------------------------------------------------
Parameter: port number
			  type of the socket (DATAGRAM for soccerserver, otherwise STREAM)
			  events on which this object should get a notification
			  string containing the internet address of the server
Returnval: TRUE, if the socket could be created and bind
			  FALSE otherwise
Description: this function is identical to CAsyncSocket::Create. It has been 
				 copied, because the bind function had to be modified and create
				 calls Bind.
-----------------------------------------------------------------------------*/
BOOL CAgentSocket::Create(UINT nSocketPort, int nSocketType
									, long lEvent, LPCTSTR lpszSocketAddress)
{
	// create the socket
	if ( Socket(nSocketType, lEvent) )
	{
		// try to bind the socket to any address
		if ( Bind(nSocketPort,lpszSocketAddress) )
        {
			return TRUE;
        }
		
		// an error occured
		int nResult = GetLastError();
		Close();
		WSASetLastError(nResult);
	}
	return FALSE;
}

BOOL CAgentSocket::Create(UINT nSocketPort, LPCTSTR lpszSocketAddress)
{
	int	nSocketType = SOCK_DGRAM;
	long	lEvent = FD_READ | FD_WRITE | FD_ACCEPT | FD_CONNECT | FD_CLOSE;

	// create the socket
	if ( Socket(nSocketType, lEvent) )
	{
		// try to bind the socket to any address
		if ( Bind(nSocketPort, lpszSocketAddress) )
        {
			return TRUE;
        }
		
		// an error occured
		int nResult = GetLastError();
		Close();
		WSASetLastError(nResult);
	}
	return FALSE;
}
/*-----------------------------------------------------------------------------
Function: BOOL CAgentSocket::Bind(UINT nSocketPort, LPCTSTR lpszSocketAddress)
Date    : 30.10.97
-------------------------------------------------------------------------------
Parameter: port number of the socket
			  address of the server as string
Returnval: TRUE, if the socket has been successfully bound to any address
			  FALSE otherwise
Description: this function is a modified version of CAsyncSocket::Bind. It uses
				 the sockAddr as class variable so it is able to react on changing
				 ports while transmitting. It binds to any address INADDR_ANY, but fills
				 in the sockAddr class variable with proper values of port and server 
				 afterwards.
-----------------------------------------------------------------------------*/
BOOL CAgentSocket::Bind(UINT nSocketPort, LPCTSTR lpszSocketAddress)
{
//	USES_CONVERSION;
	int	result;

	// bind to INADDR_ANY
	memset(&sockAddr, 0, sizeof(sockAddr));
	sockAddr.sin_family = AF_INET;
	sockAddr.sin_addr.s_addr = htonl(INADDR_ANY);
	sockAddr.sin_port = htons(0);
	result = CAsyncSocket::Bind((SOCKADDR*)&sockAddr, sizeof(sockAddr));

	// set the proper values of port and address for the following SendTo commands
	memset(&sockAddr, 0, sizeof(sockAddr));
//	LPSTR lpszAscii = T2A((LPTSTR)lpszSocketAddress);
	LPSTR lpszAscii = (LPTSTR)lpszSocketAddress;
    sockAddr.sin_family			= AF_INET ;
    sockAddr.sin_addr.s_addr	= inet_addr(lpszAscii) ;
	if (sockAddr.sin_addr.s_addr == INADDR_NONE)
	{
		// get the address from a nameserver
		LPHOSTENT lphost;
		lphost = gethostbyname(lpszAscii);
		if (lphost != NULL)
			sockAddr.sin_addr.s_addr = ((LPIN_ADDR)lphost->h_addr)->s_addr;
		else
		{
			WSASetLastError(WSAEINVAL);
			return FALSE;
		}
	}
	sockAddr.sin_port	= htons((u_short)nSocketPort) ;
	
	// return the result of the Bind command
	return result;
}

/*-----------------------------------------------------------------------------
Function: int CAgentSocket::ReceiveFrom(void* lpBuf, int nBufLen, CString& rSocketAddress
													, UINT& rSocketPort, int nFlags)
Date    : 30.10.97
-------------------------------------------------------------------------------
Parameter: buffer for the message
			  length of the message received
			  reference to the string containing the socket address
			  pointer to the port
			  Flags for the receive
Returnval: number of correctly sent bytes, -1 in case of an error
Description: this is an almost identical copy of CAsyncSocket::ReceiveFrom.
				 The difference is, that sockAddr is a member variable.
-----------------------------------------------------------------------------*/
int CAgentSocket::ReceiveFrom(void* lpBuf, int nBufLen, CString& rSocketAddress
										, UINT& rSocketPort, int nFlags)
{
	// try to receive data
	memset(&sockAddr, 0, sizeof(sockAddr));
	int nSockAddrLen = sizeof(sockAddr);
	int nResult = CAsyncSocket::ReceiveFrom(lpBuf, nBufLen, (SOCKADDR*)&sockAddr
														 , &nSockAddrLen, nFlags);
	if(nResult != SOCKET_ERROR)
	{
		// succesfull
		rSocketPort = ntohs(sockAddr.sin_port);
		rSocketAddress = inet_ntoa(sockAddr.sin_addr);
	}

	return nResult;
}

/*-----------------------------------------------------------------------------
Function: int CAgentSocket::SendTo(const void* lpBuf, int nBufLen, UINT nHostPort
								 , LPCTSTR lpszHostAddress, int nFlags)
Date    : 30.10.97
-------------------------------------------------------------------------------
Parameter: pointer to the buffer
			  length of the message to be sent
			  port of the socket
			  reference to the string of the address
			  Flags
Returnval: number of bytes sent
Description: insted of calculating the internet address from the string, this SendTo
				 uses the information in the sockAddr member variable
-----------------------------------------------------------------------------*/
int CAgentSocket::SendTo(const void* lpBuf, int nBufLen, UINT nHostPort
								 , LPCTSTR lpszHostAddress, int nFlags)
{
	// send the buffer
	return CAsyncSocket::SendTo(lpBuf, nBufLen, (SOCKADDR*)&sockAddr, sizeof(sockAddr), nFlags);
}

