/*-----------------------------------------------------------------------------
Modul Name : Agentsock.h
Date       : 30.10.97
-------------------------------------------------------------------------------
Author     : Klaus Dorer

Description: Socket class for Soccerserver communication

Comments   : _
-----------------------------------------------------------------------------*/
#ifndef __AGENTSOCK_H__
#define __AGENTSOCK_H__

#include "Soccermonitor.h"
class CSoccermonitorDoc;

/*-----------------------------------------------------------------------------
Class   : CAgentSocket
Date    : 30.10.97
-------------------------------------------------------------------------------
Base Class: CAsyncSocket

Description: _
-----------------------------------------------------------------------------*/
class CAgentSocket : public CAsyncSocket
{
	DECLARE_DYNAMIC(CAgentSocket);

	public:
		CAgentSocket(CSoccermonitorDoc* pDoc);
		CAgentSocket();
		
		// functions from CAsyncsocket adapted for this use
		BOOL Create(UINT nSocketPort, int nSocketType, long lEvent, LPCTSTR lpszSocketAddress);
		BOOL Create(UINT nSocketPort, LPCTSTR lpszSocketAddress);
		BOOL Bind(UINT nSocketPort, LPCTSTR lpszSocketAddress);
		BOOL Connect(LPCTSTR lpszHostAddress, UINT nHostPort);
		int  ReceiveFrom(void* lpBuf, int nBufLen, CString& rSocketAddress, UINT& rSocketPort
								, int nFlags);
		int  SendTo(const void* lpBuf, int nBufLen, UINT nHostPort, LPCTSTR lpszHostAddress
								, int nFlags);

		BOOL ConnectSocket(LPCTSTR lpszAddress, UINT nPort);
		void SendMsg(LPCSTR strText);
		void ReceiveMsg();



		// get and set functions
		void			SetPort(UINT port) { m_uiPort = port; };
		UINT			GetPort(void) { return m_uiPort; };
		CString		GetAddress(void) { return m_sSocketAddress; };

	protected:
		// notification functions
		virtual void	OnReceive(int nErrorCode);
		virtual void	OnClose(int nErrorCode);

		SOCKADDR_IN sockAddr;
		UINT    m_uiPort;
		CString	m_sSocketAddress;
		CSoccermonitorDoc* m_pDoc;

	private:
		// convert the byte ordering of shorts
		void	ConvShort(short &val) { val = ((val >> 8) & 0x00ff) | (val << 8); };

        dispinfo_t m_tInfo;
		dispinfo_t2	m_tInfo2;

};

#endif // __AGENTSOCK_H__
