// DCycleSlider.cpp : implementation file
//

#include "stdafx.h"
#include "Soccermonitor.h"
#include "SoccermonitorDoc.h"
#include "DCycleSlider.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



#define WS_EX_LAYERED	0x80000
#define LWA_COLORKEY	1
#define LWA_ALPHA		2
typedef BOOL (WINAPI *SLWA)(HWND, COLORREF, BYTE, DWORD);

/////////////////////////////////////////////////////////////////////////////
// DCycleSlider dialog


DCycleSlider::DCycleSlider(CWnd* pParent /*=NULL*/)
	: CDialog(DCycleSlider::IDD, pParent)
{
	//{{AFX_DATA_INIT(DCycleSlider)
	m_sStartNum = _T("");
	m_sStopNum = _T("");
	m_iPos = 0;
	//}}AFX_DATA_INIT
}


void DCycleSlider::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(DCycleSlider)
	DDX_Control(pDX, IDC_SLIDER1, m_cSlider);
	DDX_Text(pDX, IDC_STARTNUM, m_sStartNum);
	DDV_MaxChars(pDX, m_sStartNum, 5);
	DDX_Text(pDX, IDC_STOPNUM, m_sStopNum);
	DDV_MaxChars(pDX, m_sStopNum, 5);
	DDX_Text(pDX, IDC_Cycle, m_iPos);//cycle);
	DDV_MinMaxInt(pDX, m_iPos, 0, 20000);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(DCycleSlider, CDialog)
	//{{AFX_MSG_MAP(DCycleSlider)
	ON_WM_HSCROLL()
	ON_EN_KILLFOCUS(IDC_Cycle, OnKillfocusCycle)

	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// DCycleSlider message handlers



BOOL DCycleSlider::OnInitDialog() 
{
    SetWindowStyleLayered();

	CDialog::OnInitDialog();

    m_cSlider.SetRangeMin(m_iMin);
	m_cSlider.SetRangeMax(m_iMax);
	m_cSlider.ClearSel();
	m_cSlider.SetPos(m_iPos);

    SetLayeredWindowAttributes(0/**/, 160, LWA_ALPHA);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void DCycleSlider::OnOK() 
{
	// TODO: Add extra validation here
	CDialog::OnOK();
}

void DCycleSlider::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// the user	has draged the slider
	if ( nSBCode == SB_ENDSCROLL )
    {
		nPos = m_cSlider.GetPos();
	}

	if ( nSBCode == SB_THUMBPOSITION
         || nSBCode == SB_THUMBTRACK
         || nSBCode == SB_ENDSCROLL )
    {
        m_pDoc->setGameCycle(nPos);
		m_iPos = nPos;		
		if ( m_iPos > m_iMax )
        {
			m_iPos = m_iMax;
        }
	}
	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
	UpdateData(FALSE);
}

void DCycleSlider::OnKillfocusCycle() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if ( m_iPos != m_cSlider.GetPos()
         && m_iMin <= m_iPos
         && m_iPos <= m_iMax )
    {
        m_cSlider.SetPos(m_iPos);
        m_pDoc->setGameCycle(m_iPos);
	}
}


BOOL DCycleSlider::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	//if(pMsg->wParam = 
	return CDialog::PreTranslateMessage(pMsg);
}






BOOL DCycleSlider::SetWindowStyleLayered()
{
	BOOL ret = FALSE;
	HMODULE hModule = LoadLibrary("user32.dll");
	if ( hModule ) {
		SLWA slwa = (SLWA)GetProcAddress(hModule, "SetLayeredWindowAttributes");
		if ( slwa ) {
			SetWindowLong(GetSafeHwnd(), GWL_EXSTYLE,
				GetWindowLong(GetSafeHwnd(), GWL_EXSTYLE) | WS_EX_LAYERED
				);
			ret = TRUE;
		}
		FreeLibrary(hModule);
	}
	return ret;
}


BOOL DCycleSlider::WindowStyleLayered()
{
	return ((GetWindowLong(GetSafeHwnd(), GWL_EXSTYLE) & WS_EX_LAYERED) != 0) ? TRUE : FALSE;
}


BOOL DCycleSlider::SetLayeredWindowAttributes(COLORREF crKey, BYTE bAlpha, DWORD dwFlags)
{
	BOOL ret = FALSE;
	HMODULE hModule = LoadLibrary("user32.dll");
	if ( hModule ) {
		SLWA slwa = (SLWA)GetProcAddress(hModule, "SetLayeredWindowAttributes");
		if ( slwa ) {
			ret = slwa(GetSafeHwnd(), crKey, bAlpha, dwFlags);
		}
		FreeLibrary(hModule);
	}
	return ret;
}

