#include "StdAfx.h"
#include "gzfile.h"

CGZFile::CGZFile(CString strName, CGZFile::Mode mode)
{
	M_gzmode = mode;
	if ( mode == ModeOpen )
    {
		M_gzfile = gzopen(strName,"rb");
	}
    else
    {
		M_gzfile = gzopen(strName,"wb");
	}
}

CGZFile::~CGZFile(void)
{
	if ( M_gzfile )
    {
		gzclose(M_gzfile);
		M_gzfile = NULL;
	}
}

int CGZFile::Read( void* p,UINT len )
{
	if ( M_gzfile && M_gzmode == ModeOpen )
    {
		return gzread(M_gzfile, p, len);
	}
	return 0;
}

char* CGZFile::Gets(char *buf, int len)
{
    if ( M_gzfile && M_gzmode == ModeOpen )
    {
        return gzgets(M_gzfile, buf, len);
    }
    return NULL;
}

int CGZFile::Write(const voidp p, UINT len)
{
	if ( M_gzfile && M_gzmode == ModeSave )
    {
		return gzwrite(M_gzfile, p, len);
	}
	return 0;
}

int CGZFile::Rewind()
{
    if ( M_gzfile )
    {
        return gzrewind(M_gzfile);
    }
    return 0;
}

bool CGZFile::Good()
{
	if ( M_gzfile )
    {
		return ! gzeof(M_gzfile);
	}
	return false;
}

int CGZFile::Write(short s)
{
	if ( M_gzfile && M_gzmode == ModeSave )
    {
		return gzwrite(M_gzfile, &s, sizeof(s));
	}
	return 0;
}

void CGZFile::Close()
{
	if ( M_gzfile )
    {
		gzclose(M_gzfile);
		M_gzfile = NULL;
	}
}

int CGZFile::Tell()
{
    if ( M_gzfile )
    {
        return (int)gztell(M_gzfile);
    }
    return 0;
}

