// SoccermonitorView.cpp : implementation of the CSoccermonitorView class
//

#include "stdafx.h"
#include "Soccermonitor.h"
#include "SoccermonitorDoc.h"
#include "SoccermonitorView.h"
#include "MainFrm.h"
#include "TLogPlayer.h"
#include "TCoachAgent.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const int CSoccermonitorView::S_DEFAULT_CONNECTION_TIMEOUT_SEC = 5;

/////////////////////////////////////////////////////////////////////////////
// CSoccermonitorView

IMPLEMENT_DYNCREATE(CSoccermonitorView, CView)

BEGIN_MESSAGE_MAP(CSoccermonitorView, CView)
	//{{AFX_MSG_MAP(CSoccermonitorView)
	ON_WM_TIMER()
	ON_WM_CONTEXTMENU()
	ON_WM_DESTROY()
	ON_WM_CHAR()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_DROPFILES()
	ON_COMMAND(ID_COACH_START, OnCoachStart)
	ON_WM_MOUSEWHEEL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSoccermonitorView construction/destruction

CSoccermonitorView::CSoccermonitorView()
{
    M_set_connect_timer = false;
    M_connect_timer_id = 0;
    M_set_coach_timer = false;
	M_coach_timer_id = 0;
    M_connect_timeout_sec = S_DEFAULT_CONNECTION_TIMEOUT_SEC;	
}

CSoccermonitorView::~CSoccermonitorView()
{
}

BOOL CSoccermonitorView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

    // t@C̃hbOAhhbv
    cs.dwExStyle |= WS_EX_ACCEPTFILES;

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CSoccermonitorView drawing

void CSoccermonitorView::OnDraw(CDC* pDC)
{
	CSoccermonitorDoc *pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	pDoc->RedrawDoc();
}


void CSoccermonitorView::startConnectTimer()
{
    M_set_connect_timer = true;
    M_connect_timer_id = CONNECTION_TIMER;
	M_connect_timer_id = SetTimer(M_connect_timer_id,
                                  M_connect_timeout_sec * 1000,
                                  NULL);
}

void CSoccermonitorView::stopConnectTimer()
{
	KillTimer(M_connect_timer_id);
    M_set_connect_timer = false;
	M_connect_timer_id = 0;
}

void CSoccermonitorView::OnTimer(UINT nIDEvent) 
{
	CSoccermonitorDoc *pDoc = GetDocument();

	ASSERT_VALID(pDoc);

    if( nIDEvent == (UINT)M_connect_timer_id )
	{
		// got a timeout connecting to the server
        stopConnectTimer();
		pDoc->ConnectionTimeout();		
	}
    else
    {
        if ( pDoc->coach()->isRunning() )
        {
			pDoc->coach()->DoCoaching();
        }
		else
        {
	    	KillTimer(M_coach_timer_id);
        }
	}
	
	CView::OnTimer(nIDEvent);
}

/////////////////////////////////////////////////////////////////////////////
// CSoccermonitorView diagnostics

#ifdef _DEBUG
void CSoccermonitorView::AssertValid() const
{
	CView::AssertValid();     
}

void CSoccermonitorView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CSoccermonitorDoc* CSoccermonitorView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSoccermonitorDoc)));
	return (CSoccermonitorDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSoccermonitorView message handlers


void CSoccermonitorView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	// store the position of the foul 
	// point is relative to the frame, but we need coordinates relative to the view
	CRect	rect;
	GetWindowRect(&rect);

	// make sure window is active
	GetParentFrame()->ActivateFrame();

    CSoccermonitorDoc *pDoc = GetDocument();
	CMenu menu;
    if ( ! pDoc || ! pDoc->isConnected() )
    {
    	if ( menu.LoadMenu(IDR_POPUP_MAIN) )
	    {
		    CMenu* pPopup = menu.GetSubMenu(0);
    		ASSERT(pPopup != NULL);

    		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
                                   point.x, point.y,
                                   AfxGetMainWnd()); // use main window for cmds
        }
    }
    else
    {
    	if ( menu.LoadMenu(ID_MENU_FOUL) )
	    {
            M_referee_foul_point = point - rect.TopLeft();
            M_referee_foul_point.x -= 2;
            M_referee_foul_point.y -= 2;

		    CMenu* pPopup = menu.GetSubMenu(0);
    		ASSERT(pPopup != NULL);

    		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
                                   point.x, point.y,
                                   AfxGetMainWnd()); // use main window for cmds
        }
	}
}


void CSoccermonitorView::OnDestroy() 
{
	CView::OnDestroy();
	
    if ( M_set_connect_timer )
    {
		KillTimer(M_connect_timer_id);
    }

    if ( M_set_coach_timer )
    {
		KillTimer(M_coach_timer_id);
    }
}

void CSoccermonitorView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	switch ( nChar ) {
		case 'q':
			{
			// for test the monitor reads all messages on the socket
			CSoccermonitorDoc		*pDoc = GetDocument();
			ASSERT_VALID(pDoc);
			pDoc->TestSocket();
			}
			break;	
		default:
			CView::OnChar(nChar, nRepCnt, nFlags);
	}
}

void CSoccermonitorView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default		
	CSoccermonitorDoc *pDoc = GetDocument();	

    Vector2D coordinates = pDoc->convertPoint(point);

    if ( pDoc->isMonitorDiscardPlayer() )
    {
        int pnum = pDoc->FindPlayer(coordinates);
        pDoc->doDiscardPlayer(pnum);
    }
    else if ( pDoc->isMonitorMovePlayer() )
    {
        int pnum = pDoc->FindPlayer(coordinates);
        if ( pnum > 0 )
        {
            pDoc->setSelectPlayer(pnum);
            SetCapture();
            pDoc->setLButtonDown(point);
        }
    }
    else if ( pDoc->focusType() == CSoccermonitorDoc::FOCUS_POINT )
    {
        if ( fabs(coordinates.x) < 60.0 && fabs(coordinates.y) < 40.0 )
        {
            pDoc->setFocusPoint(coordinates.x, coordinates.y);
            if ( ! pDoc->logplayer()->isRunning() )
            {
                pDoc->RedrawDoc();
            }
        }
    }
    else if ( pDoc->isViewMeasure() )
    {
        // }EX̓Ɛ
        SetCapture();
        pDoc->setLButtonDown(point);
        M_old_cursor = ::GetCursor();
        HCURSOR hCursor = AfxGetApp()->LoadStandardCursor(IDC_CROSS);
        ::SetCursor(hCursor);
        if ( ! pDoc->logplayer()->isRunning() )
        {
            pDoc->RedrawDoc();
        }
    }
    else if ( pDoc->isDragZoom() )
    {
        SetCapture(); // ̃EChEł̃}EX̓Ɛ
        pDoc->setLButtonDown(point);
        M_old_cursor = ::GetCursor();
        HCURSOR hCursor = AfxGetApp()->LoadStandardCursor(IDC_CROSS);
        ::SetCursor(hCursor);
    }
    else
    {
        if ( ! pDoc->isPlayerAutoSelect() )
        {
            int pnum = pDoc->FindPlayer(coordinates);
            if ( pnum > 0 )
            {
                pDoc->selectPlayer(pnum);
            }
        }
    }

    CView::OnLButtonDown(nFlags, point);
}


void CSoccermonitorView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default	
	CSoccermonitorDoc *pDoc = GetDocument();
	bool redraw = false;

    if ( pDoc->isLButtonDown() )
    {
        // }EX̊J
        ReleaseCapture();
   		pDoc->setLButtonUp();

        if ( pDoc->isMonitorMovePlayer() )
        {
            pDoc->doMovePlayer(point);
    	}
    	else if ( pDoc->isViewMeasure() )
	    {
	    	//redraw = true;
            // J[\ɖ߂
            ::SetCursor(M_old_cursor);
    	}
        else if ( pDoc->isDragZoom() )
        {
            // J[\ɖ߂
            ::SetCursor(M_old_cursor);
            // change field scale
            pDoc->doDragZoom();
            redraw = true;
        }
    }

	if ( redraw )
    {
        if ( ! pDoc->logplayer()->isRunning() )
        {
        	pDoc->RedrawDoc();
        }
    }
	CView::OnLButtonUp(nFlags, point);
}

void CSoccermonitorView::OnCoachStart() 
{
	// TODO: Add your command handler code here
	CSoccermonitorDoc* pDoc = GetDocument();
    if ( pDoc->coach()->isRunning() )
	{
		// the coach is already running, so stop it
		KillTimer(M_coach_timer_id);
		M_coach_timer_id = 0;
        M_set_coach_timer = false;
        pDoc->coach()->reset();
	}
	else
	{
		// start the timer
		GetDocument()->coach()->ResetValues();
        if ( ! GetDocument()->coach()->isEarOn() )
        {
    		GetDocument()->coach()->doEar();
        }
        if ( ! GetDocument()->coach()->isEyeOn() )
        {
    	    GetDocument()->coach()->doEye();
        }

		M_coach_timer_id = SetTimer(COACH_TIMER, 75, NULL);
        M_set_coach_timer = true;
		GetDocument()->coach()->start();
	}
	
}

void CSoccermonitorView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    CSoccermonitorDoc *pDoc = GetDocument();

    CMainFrame* pFrame  = (CMainFrame*)AfxGetApp()->m_pMainWnd;
    CStatusBar* pStatus = pFrame->getStatusBar();

    if ( pStatus )
    {
        CString str;
        Vector2D coord = pDoc->convertPoint(point);
        str.Format("(%.2f, %.2f)", coord.x, coord.y);
        pStatus->SetPaneText(1, str);
    }

  	if ( ( pDoc->isMonitorMovePlayer()
           || pDoc->isViewMeasure()
           || pDoc->isDragZoom() )
         && pDoc->isLButtonDown() )
    {
        pDoc->setLButtonDrag(point);
        if ( ! pDoc->logplayer()->isRunning() )
        {
            pDoc->RedrawDoc();
        }
    }
	CView::OnMouseMove(nFlags, point);
}

void CSoccermonitorView::OnDropFiles(HDROP hDropInfo) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
    if ( GetDocument()->isConnected() )
    {
        return;
    }

    char file_path[512];
    int file_num = ::DragQueryFile(hDropInfo, -1, NULL, 0);
    TRACE1("dragged file path %s\n", file_path);
    if ( file_num > 0 )
    {
        ::DragQueryFile(hDropInfo, 0, file_path, 512);
        GetDocument()->OnOpenDocument(file_path);
    }
    DragFinish(hDropInfo);

	CView::OnDropFiles(hDropInfo);
}


BOOL CSoccermonitorView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
    CSoccermonitorDoc *pDoc = GetDocument();

    if ( ! pDoc )
    {
        return CView::OnMouseWheel(nFlags, zDelta, pt);
    }

    /////////////////////////////////////////////////
    // zoom-in & zoom-out

    if ( nFlags & MK_CONTROL )
    {
        if ( zDelta < 0 ) // O
        {
            pDoc->zoom(true); // zoom-out
        }
        else // 
        {
            pDoc->zoom(false); // zoom-in
        }
        if ( ! pDoc->logplayer()->isRunning() )
        {
            pDoc->RedrawDoc();
        }
    }
    /////////////////////////////////////////////////
    // step & step-back
    else
    {
        if ( pDoc->isConnected() )
        {
            return CView::OnMouseWheel(nFlags, zDelta, pt);
        }
        if ( ! pDoc->logplayer()->hasData() )
        {
            return CView::OnMouseWheel(nFlags, zDelta, pt);
        }

        if ( zDelta < 0 ) // O
        {
            pDoc->logplayer()->step();
        }
        else // 
        {
            pDoc->logplayer()->stepBack();
        }
    }
   	return CView::OnMouseWheel(nFlags, zDelta, pt);
}
