// TParseString.cpp: implementation of the TParseString class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TParseString.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


/*-----------------------------------------------------------------------------
Function: CParseString TParseString::ParseBracket()
Date    : 10.11.97
-------------------------------------------------------------------------------
Parameter: reference to the current position in the string
			  reference to the string that gets the content of the bracket
Returnval: TRUE if a closing bracket could be found
Description: returns the content between two brackets. iposition has to be the 
				 position of an opening bracket. This function allows nested brackets.
-----------------------------------------------------------------------------*/
BOOL TParseString::ParseBracket(TParseString &retString)
{
	int		iNoOfOpenBrackets = 1;
	int		iRightPosition = m_iPosition + 1;	
	int		iLen = GetLength();

	m_bErrorOccured = FALSE;
	// iposition must index an opening bracket
	if ((m_iPosition >= iLen) || GetAt(m_iPosition) != '(' )
		return FALSE;

	while (iNoOfOpenBrackets > 0)
	{
		// reached the end of the string ? error
		if (iRightPosition >= iLen)
			return FALSE;

		// look at the next character
		switch (GetAt(iRightPosition))
		{
			case '(':
				iNoOfOpenBrackets++;
				break;

			case ')':
				iNoOfOpenBrackets--;
				break;
		}
		iRightPosition++;
	}
	
	// only the content within the brackets
	// overread a space following the last closing bracket
	retString.CString::operator=(Mid(m_iPosition + 1, iRightPosition - m_iPosition - 2));	
	m_iPosition = iRightPosition + 1;// Do not exchange this line and the next line
	retString.m_iPosition=0;
	
	return TRUE;
}

/*-----------------------------------------------------------------------------
Function: BOOL TParseString::ParseString(CString &str)
Date    : 07.11.97
-------------------------------------------------------------------------------
Parameter: reference to the current position in the string
			  reference to the string to parse into
Returnval: TRUE, if there has been a valid string
Description: reads in a string from strCurrentMsg at Position iPosition into str.
				 terminator is either ' ' or ')'. iPosition points behind terminator
-----------------------------------------------------------------------------*/
BOOL TParseString::ParseString(CString &str)
{
	int		iRightPos;
	BOOL		bReady = FALSE;
	int		len = GetLength();
	char		tmp;

	m_bErrorOccured = FALSE;
	OverreadLeadingSpaces();
	iRightPos = m_iPosition + 1;

	// check, if there is a string
	if (m_iPosition - 1 >= len)
	{
		// the expected string is not there
		m_iPosition++;
		return FALSE;
	}

	// search for a ' ' or ')'
	bReady = FALSE;
	while (!bReady && (iRightPos < len))
	{
		tmp = GetAt(iRightPos);
		switch (tmp)
		{
			case ' ':
			case ')':
			case '\r':
			case '\n':
				bReady = TRUE;
				break;
			
			default:
				iRightPos++;
		}
	}

	// get the string
	str = Mid(m_iPosition, iRightPos - m_iPosition);
	m_iPosition = iRightPos + 1;

	return TRUE;
}

BOOL TParseString::ToString(CString &str){
	if (m_iPosition <= GetLength()){
		str = Mid(m_iPosition);
		return TRUE;
	}
	else
		return FALSE;
}

/*-----------------------------------------------------------------------------
Function: int TParseString::ParseInteger()
Date    : 07.11.97
-------------------------------------------------------------------------------
Parameter: reference to the current position in the string
			  reference to return the parsed number
Returnval: TRUE, if a number has been in str at iPosition
Description: reads in a signed integer value. assumes a ' ' at the end of the 
				 number, which is overread
-----------------------------------------------------------------------------*/
int TParseString::ParseInteger()
{
	int	iValue = 0;
	BOOL	bSign = FALSE;
	BOOL	bReady = FALSE;
	char	cChar;
	int	len = GetLength();

	m_bErrorOccured = TRUE;
	OverreadLeadingSpaces();
	// read in the number
	while (!bReady && (m_iPosition < len))
	{
		cChar = GetAt(m_iPosition);
		switch(cChar)
		{
			case '-':
				// only one - sign expected
				bSign = TRUE;
				m_iPosition++;
				break;
			
			case '+':
				m_iPosition++;
				break;

			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				iValue = 10 * iValue + cChar - '0';
				m_bErrorOccured = FALSE;
				m_iPosition++;
				break;
			
			case ' ':
				m_iPosition++;
				// no break here

			default:
				bReady = TRUE;
		}
	}
	
	// convert the number if neccessary
	if (bSign)
		iValue = -iValue;
	
	return iValue;
}

/*-----------------------------------------------------------------------------
Function: double TParseString::ParseDouble()
Date    : 07.11.97
-------------------------------------------------------------------------------
Parameter: none
Returnval: value of the number
Description: reads in a double value. assumes a ' ' at the end of the 
				 number, which is overread
-----------------------------------------------------------------------------*/
double TParseString::ParseDouble()
{
	double	dValue = 0.0;
	double	dNumber;
	BOOL		bSign = FALSE;
	BOOL		bReady = FALSE;
	BOOL		bDot = FALSE;
	double	dDivisor = 1.0;
	char		cChar;
	int		len = GetLength();

	m_bErrorOccured = TRUE;
	// read in the number
	while (!bReady && (m_iPosition < len))
	{
		cChar = GetAt(m_iPosition);
		switch(cChar)
		{
			case '-':
				// only one - sign expected
				bSign = TRUE;
				m_iPosition++;
				break;
			
			case '+':
				m_iPosition++;
				break;

			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				dValue = 10.0 * dValue + (double) (cChar - '0');
				dDivisor *= 10.0;
				m_bErrorOccured = FALSE;
				m_iPosition++;
				break;
			
			case '.':
			case ',':
				dDivisor = 1.0;
				bDot = TRUE;
				m_iPosition++;
				break;

			case ' ':
				m_iPosition++;
				// no break here

			default:
				bReady = TRUE;
		}
	}
	
	// convert the number if neccessary
	if (bDot)
		dNumber = dValue / dDivisor;
	else
		dNumber = dValue;

	if (bSign)
		dNumber = -dNumber;
	
	return dNumber;
}

/*-----------------------------------------------------------------------------
Function: void TParseString::OverreadLeadingSpaces()
Date    : 14.01.98
-------------------------------------------------------------------------------
Parameter: none
Returnval: (void)
Description: overreads leading spaces starting from m_iPosition and ending, when
			 a character other than SPACE or the end of the string is reached
-----------------------------------------------------------------------------*/
void TParseString::OverreadLeadingSpaces()
{
	char		tmp;

	// overread inital spaces, returns and new lines
	while (m_iPosition < GetLength())
	{
		tmp = GetAt(m_iPosition);
		switch (tmp)
		{
			case ' ':
			case '\r':
			case '\n':
				m_iPosition++;
				break;
		
			default:
				return;
		}
	}
}