#include "stdafx.h"
#include "geometry.h"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

const double AngleDeg::DEG2RAD = M_PI / 180.0;
const double AngleDeg::RAD2DEG = 180.0 / M_PI;




/*-----------------------------------------------------------------------------*
 * compare the slope of this and Line
 * if it is same, return true
 * bool isSameSlope(Line l);
 *-----------------------------------------------------------------------------*/
bool
Line2D::isSameSlope(const Line2D &line) const
{
    if ( fabs(M_b) < 0.0001 && fabs(line.B()) < 0.0001 )
    {
        return true;
    }
    if ( fabs(M_a / M_b - line.A() / line.B()) < 0.0001 )
    {
        return true;
    }

    return false;
}

/*-----------------------------------------------------------------------------*
 * calculate intersection point, this line and l.
 *
 *-----------------------------------------------------------------------------*/
bool
Line2D::intersection(const Line2D &line,
                     Vector2D &sol) const
{
    if ( isSameSlope(line) )
    {
        return false;
    }

    double x;
    if ( fabs(M_b) < 0.0001 )
    {
        x = -M_c / M_a;
        sol.assign(x, line.getY(x));
        return true;
    }

    if ( fabs(line.B()) < 0.0001 )
    {
        x = -line.C() / line.A();
    }
    else
    {
        x = (M_c * line.B() - M_b * line.C()) / (line.A() * M_b - M_a * line.B());
    }
    sol.assign(x, this->getY(x));

    return true;
}
