#include "stdafx.h"
#include "param.h"
#include <math.h>

inline
double rint(const double &val)
{
    if ( fabs(val) < 0.5 )
    {
        return 0.0; 
    }
    return (double)(long)(val + (val > 0 ? 0.5 : - 0.5));
}

PlayerParam::PlayerParam()
{
    player_types = 7;
    subs_max = 3;
    pt_max = 3;
    player_speed_max_delta_min = 0.0;
    player_speed_max_delta_max = 0.0;
    stamina_inc_max_delta_factor = 0.0;
    player_decay_delta_min = 0.0;
    player_decay_delta_max = 0.2;
    inertia_moment_delta_factor = 25.0;
    dash_power_rate_delta_min = 0.0;
    dash_power_rate_delta_max = 0.0;
    player_size_delta_factor = -100.0;
    kickable_margin_delta_min = 0.0;
    kickable_margin_delta_max = 0.2;
    kick_rand_delta_factor = 0.5;
    extra_stamina_delta_min = 0.0;
    extra_stamina_delta_max = 100.0;
    effort_max_delta_factor = -0.002;
    effort_min_delta_factor = -0.002;
    random_seed = -1;
    new_dash_power_rate_delta_min = 0.0;
    new_dash_power_rate_delta_max = 0.002;
    new_stamina_inc_max_delta_factor = -10000.0;
    // double sparedouble5;
    // double sparedouble6;
    // double sparedouble7;
    //double sparedouble8;
    //double sparedouble9;
    //double sparedouble10;

  //int spareint1;
  //int spareint2;
  //int spareint3;
  //int spareint4;
  //int spareint5;
  //int spareint6;
  //int spareint7;
  //int spareint8;
  //int spareint9;
  //int spareint10;
}

void PlayerParam::convert(player_params_t *pparam)
{
    player_types = (int)ntohs(pparam->player_types);
    subs_max = (int)ntohs(pparam->subs_max);
    pt_max = (int)ntohs(pparam->pt_max);
    player_speed_max_delta_min = nltohd(pparam->player_speed_max_delta_min);
    player_speed_max_delta_max = nltohd(pparam->player_speed_max_delta_max);
    stamina_inc_max_delta_factor = nltohd(pparam->stamina_inc_max_delta_factor);
    player_decay_delta_min = nltohd(pparam->player_decay_delta_min);
    player_decay_delta_max = nltohd(pparam->player_decay_delta_max);
    inertia_moment_delta_factor = nltohd(pparam->inertia_moment_delta_factor);
    dash_power_rate_delta_min = nltohd(pparam->dash_power_rate_delta_min);
    dash_power_rate_delta_max = nltohd(pparam->dash_power_rate_delta_max);
    player_size_delta_factor = nltohd(pparam->player_size_delta_factor);
    kickable_margin_delta_min = nltohd(pparam->kickable_margin_delta_min);
    kickable_margin_delta_max = nltohd(pparam->kickable_margin_delta_max);
    kick_rand_delta_factor = nltohd(pparam->kick_rand_delta_factor);
    extra_stamina_delta_min = nltohd(pparam->extra_stamina_delta_min);
    extra_stamina_delta_max = nltohd(pparam->extra_stamina_delta_max);
    effort_max_delta_factor = nltohd(pparam->effort_max_delta_factor);
    effort_min_delta_factor = nltohd(pparam->effort_min_delta_factor);
    random_seed = (int)ntohl(pparam->random_seed);
    new_dash_power_rate_delta_min = nltohd(pparam->new_dash_power_rate_delta_min);
    new_dash_power_rate_delta_max = nltohd(pparam->new_dash_power_rate_delta_max);
    new_stamina_inc_max_delta_factor = nltohd(pparam->new_stamina_inc_max_delta_factor);
    // double sparedouble5;
    // double sparedouble6;
    // double sparedouble7;
    //double sparedouble8;
    //double sparedouble9;
    //double sparedouble10;

  //int spareint1;
  //int spareint2;
  //int spareint3;
  //int spareint4;
  //int spareint5;
  //int spareint6;
  //int spareint7;
  //int spareint8;
  //int spareint9;
  //int spareint10;
}

void PlayerParam::toStruct(player_params_t *pparam)
{
  pparam->player_types = htons( (short) player_types );
  pparam->subs_max = htons( (short) subs_max );
  pparam->pt_max = htons( (short) pt_max );
    
  pparam->player_speed_max_delta_min = htonl( (long)rint((SHOWINFO_SCALE2 * player_speed_max_delta_min) ));
  pparam->player_speed_max_delta_max = htonl( (long)rint((SHOWINFO_SCALE2 * player_speed_max_delta_max) ));
  pparam->stamina_inc_max_delta_factor = htonl( (long)rint((SHOWINFO_SCALE2 * stamina_inc_max_delta_factor) ));
    
  pparam->player_decay_delta_min = htonl( (long)rint((SHOWINFO_SCALE2 * player_decay_delta_min) ));
  pparam->player_decay_delta_max = htonl( (long)rint((SHOWINFO_SCALE2 * player_decay_delta_max) ));
  pparam->inertia_moment_delta_factor = htonl( (long)rint((SHOWINFO_SCALE2 * inertia_moment_delta_factor) ));

  pparam->dash_power_rate_delta_min = htonl( (long)rint((SHOWINFO_SCALE2 * dash_power_rate_delta_min) ));
  pparam->dash_power_rate_delta_max = htonl( (long)rint((SHOWINFO_SCALE2 * dash_power_rate_delta_max) ));
  pparam->player_size_delta_factor = htonl( (long)rint((SHOWINFO_SCALE2 * player_size_delta_factor) ));

  pparam->kickable_margin_delta_min = htonl( (long)rint((SHOWINFO_SCALE2 * kickable_margin_delta_min) ));
  pparam->kickable_margin_delta_max = htonl( (long)rint((SHOWINFO_SCALE2 * kickable_margin_delta_max) ));
  pparam->kick_rand_delta_factor = htonl( (long)rint((SHOWINFO_SCALE2 * kick_rand_delta_factor) ));

  pparam->extra_stamina_delta_min = htonl( (long)rint((SHOWINFO_SCALE2 * extra_stamina_delta_min) ));
  pparam->extra_stamina_delta_max = htonl( (long)rint((SHOWINFO_SCALE2 * extra_stamina_delta_max) ));
  pparam->effort_max_delta_factor = htonl( (long)rint((SHOWINFO_SCALE2 * effort_max_delta_factor) ));
  pparam->effort_min_delta_factor = htonl( (long)rint((SHOWINFO_SCALE2 * effort_min_delta_factor) ));
  pparam->random_seed = htonl( (long)random_seed );

  pparam->new_dash_power_rate_delta_min = htonl( (long)rint((SHOWINFO_SCALE2 * new_dash_power_rate_delta_min) ));
  pparam->new_dash_power_rate_delta_max = htonl( (long)rint((SHOWINFO_SCALE2 * new_dash_power_rate_delta_max) ));
  pparam->new_stamina_inc_max_delta_factor = htonl( (long)rint((SHOWINFO_SCALE2 * new_stamina_inc_max_delta_factor) ));
}





PlayerType::PlayerType()
{
    setDefaultParam();
}

void PlayerType::setDefaultParam()
{
    id = 0;
    player_speed_max = 1.2;
    stamina_inc_max = 45.0;
    player_decay = 0.4;
    inertia_moment = 5.0;
    dash_power_rate = 0.6;
    player_size = 0.3;
    kickable_margin = 0.7;
    kick_rand = 0.0;
    extra_stamina = 0.0;
    effort_max = 1.0;
    effort_min = 0.5;

    //double sparedouble1;
    //double sparedouble2;
    //double sparedouble3;
    //double sparedouble4;
    //double sparedouble5;
    //double sparedouble6;
    //double sparedouble7;
    //double sparedouble8;
    //double sparedouble9;
    //double sparedouble10;
}

void PlayerType::convert(player_type_t *ptinfo)
{
    id = (int)ntohs(ptinfo->id);
    player_speed_max = nltohd(ptinfo->player_speed_max);
    stamina_inc_max = nltohd(ptinfo->stamina_inc_max);
    player_decay = nltohd(ptinfo->player_decay);
    inertia_moment = nltohd(ptinfo->inertia_moment);
    dash_power_rate = nltohd(ptinfo->dash_power_rate);
    player_size = nltohd(ptinfo->player_size);
    kickable_margin = nltohd(ptinfo->kickable_margin);
    kick_rand = nltohd(ptinfo->kick_rand);
    extra_stamina = nltohd(ptinfo->extra_stamina);
    effort_max = nltohd(ptinfo->effort_max);
    effort_min = nltohd(ptinfo->effort_min);

    //double sparedouble1;
    //double sparedouble2;
    //double sparedouble3;
    //double sparedouble4;
    //double sparedouble5;
    //double sparedouble6;
    //double sparedouble7;
    //double sparedouble8;
    //double sparedouble9;
    //double sparedouble10;
}

void PlayerType::toStruct(player_type_t *ptinfo)
{
    ptinfo->id = htons ( id );
    ptinfo->player_speed_max = htonl ( (long)rint((player_speed_max * SHOWINFO_SCALE2) ));
    ptinfo->stamina_inc_max = htonl ( (long)rint((stamina_inc_max * SHOWINFO_SCALE2) ));
    ptinfo->player_decay = htonl ( (long)rint((player_decay * SHOWINFO_SCALE2) ));
    ptinfo->inertia_moment = htonl ( (long)rint((inertia_moment * SHOWINFO_SCALE2) ));
    ptinfo->dash_power_rate = htonl ( (long)rint((dash_power_rate * SHOWINFO_SCALE2) ));
    ptinfo->player_size = htonl ( (long)rint((player_size * SHOWINFO_SCALE2) ));
    ptinfo->kickable_margin = htonl ( (long)rint((kickable_margin * SHOWINFO_SCALE2) ));
    ptinfo->kick_rand = htonl ( (long)rint((kick_rand * SHOWINFO_SCALE2) ));
    ptinfo->extra_stamina = htonl ( (long)rint((extra_stamina * SHOWINFO_SCALE2) ));
    ptinfo->effort_max = htonl ( (long)rint((effort_max * SHOWINFO_SCALE2) ));
    ptinfo->effort_min = htonl ( (long)rint((effort_min * SHOWINFO_SCALE2) ));
}

void PlayerType::toString(CString &to)
{
    to.Format("player_type %d (speed_max %.4f) (stamina_inc_max %.3f) (decay %.4f) (inertia_moment %.4f) (dash_power_rate %.5f) (size %.4f) (kickable_margin %.4f) (kick_rand %.4f) (extra_stamina %5.2f) (effort_max %.4f) (effort_min %.4f)\n",
        id,
        player_speed_max,
        stamina_inc_max,
        player_decay,
        inertia_moment,
        dash_power_rate,
        player_size,
        kickable_margin,
        kick_rand,
        extra_stamina,
        effort_max,
        effort_min);

}



ServerParam::ServerParam()
{
    setDefaultParam();
}

void ServerParam::setDefaultParam()
{
    gwidth = 14.02;
    inertia_moment = 5.0;
    psize = 0.3;
    pdecay = 0.4;
    prand = 0.1;
    pweight = 60.0;
    pspeed_max = 1.2;
    paccel_max = 1.0;
    stamina_max = 4000;
    stamina_inc = 45.0;
    recover_init = 1.0;
    recover_dthr = 0.3;
    recover_min = 0.5;
    recover_dec = 0.002;
    effort_init = 1.0;
    effort_dthr = 0.3;
    effort_min = 0.6;
    effort_dec = 0.005;
    effort_ithr = 0.6;
    effort_inc = 0.01;
    kick_rand = 0.0;
    team_actuator_noise = 0; // false
    prand_factor_l = 1.0;
    prand_factor_r = 1.0;
    kick_rand_factor_l = 1.0;
    kick_rand_factor_r = 1.0;

    bsize = 0.085;
    bdecay = 0.94;
    brand = 0.05;
    bweight = 0.2;
    bspeed_max = 2.7;
    baccel_max = 2.7;
    dprate = 0.006;
    kprate = 0.027;
    kmargin = 0.7;
    ctlradius = 2.0;
    ctlradius_width = ctlradius - psize;
    maxp = 100.0;
    minp = -100.0;
    maxm = 180.0;
    minm = -180.0;
    maxnm = 180.0;
    minnm = -180.0;
    maxn = 90.0;
    minn = 90.0;
    visangle = 90.0;
    visdist = 3.0;
    windir = 0.0;
    winforce = 0.0;
    winang = 0.0;
    winrand = 0.0;
    kickable_area = 0.7;
    catch_area_l = 2.0;
    catch_area_w = 1.0;
    catch_prob = 1.0;
    goalie_max_moves = 2;
    ckmargin = 1.0;
    offside_area = 2.5;
    win_no = 0;	// false
    win_random = 0;	// false
    say_cnt_max = 128;
    SayCoachMsgSize = 128;
    clang_win_size = 300;
    clang_define_win = 1;
    clang_meta_win = 1;
    clang_advice_win = 1;
    clang_info_win = 1;
    clang_mess_delay = 50;
    clang_mess_per_cycle = 1;
    half_time = 3000;
    sim_st = 100;
    send_st = 150;
    recv_st = 10;
    sb_step = 100;
    lcm_st = 300;
    SayMsgSize = 10;
    hear_max = 1;
    hear_inc = 1;
    hear_decay = 1;
    cban_cycle = 5;
    slow_down_factor = 1;
    useoffside = 1; // true
    kickoffoffside = 1; // true
    offside_kick_margin = 9.15;
    audio_dist = 50.0;
    dist_qstep = 0.1;
    land_qstep = 0.01;
    dir_qstep = 0.0;
    dist_qstep_l = dist_qstep;
    dist_qstep_r  = dist_qstep;
    land_qstep_l = land_qstep;
    land_qstep_r = land_qstep;
    dir_qstep_l = dir_qstep;
    dir_qstep_r = dir_qstep;
    CoachMode = 0; // false
    CwRMode = 0; // false
    old_hear = 0; // false
    sv_st = 100;

    slowness_on_top_for_left_team = 1.0;
    slowness_on_top_for_right_team = 1.0;
    ka_length = 20.0;
    ka_width = 20.0;
    //double sparedouble5;
    //double sparedouble6;
    //double sparedouble7;
    //double sparedouble8;
    //double sparedouble9;
    //double sparedouble10;

    start_goal_l = 0;
    start_goal_r = 0;
    fullstate_l = 0;
    fullstate_r = 0;
    drop_time = 200;
    synch_mode = 0; // false
    synch_offset = 60;
    synch_micro_sleep = 1;
    point_to_ban = 5;
    point_to_duration = 20;


#if 0    
    // server version 8
    M_tackle_dist = 2.5;
    M_tackle_back_dist = 0.5;
#else
    // server version 9
    M_tackle_dist = 2.0;
    M_tackle_back_dist = 0.5;
#endif
    M_tackle_width = 1.25;
    M_tackle_exponent = 6.0;
    M_tackle_cycles = 10;
    M_tackle_power_rate = 0.027;
}

void ServerParam::convert(server_params_t *sparam)
{
    gwidth = nltohd(sparam->gwidth);
    inertia_moment = nltohd(sparam->inertia_moment);
    psize = nltohd(sparam->psize);
    pdecay = nltohd(sparam->pdecay);
    prand = nltohd(sparam->prand);
    pweight = nltohd(sparam->pweight);
    pspeed_max = nltohd(sparam->pspeed_max);
    paccel_max = nltohd(sparam->paccel_max);
    stamina_max = nltohd(sparam->stamina_max);
    stamina_inc = nltohd(sparam->stamina_inc);
    recover_init = nltohd(sparam->recover_init);
    recover_dthr = nltohd(sparam->recover_dthr);
    recover_min = nltohd(sparam->recover_min);
    recover_dec = nltohd(sparam->recover_dec);
    effort_init = nltohd(sparam->effort_init);
    effort_dthr = nltohd(sparam->effort_dthr);
    effort_min = nltohd(sparam->effort_min);
    effort_dec = nltohd(sparam->effort_dec);
    effort_ithr = nltohd(sparam->effort_ithr);
    effort_inc = nltohd(sparam->effort_inc);
    kick_rand = nltohd(sparam->kick_rand);
    team_actuator_noise = (int)ntohs(sparam->team_actuator_noise); // false
    prand_factor_l = nltohd(sparam->prand_factor_l);
    prand_factor_r = nltohd(sparam->prand_factor_r);
    kick_rand_factor_l = nltohd(sparam->kick_rand_factor_l);
    kick_rand_factor_r = nltohd(sparam->kick_rand_factor_r);

    bsize = nltohd(sparam->bsize);
    bdecay = nltohd(sparam->bdecay);
    brand = nltohd(sparam->brand);
    bweight = nltohd(sparam->bweight);
    bspeed_max = nltohd(sparam->bspeed_max);
    baccel_max = nltohd(sparam->baccel_max);
    dprate = nltohd(sparam->dprate);
    kprate = nltohd(sparam->kprate);
    kmargin = nltohd(sparam->kmargin);
    ctlradius = nltohd(sparam->ctlradius);
    ctlradius_width = nltohd(sparam->ctlradius_width);
    maxp = nltohd(sparam->maxp);
    minp = nltohd(sparam->minp);
    maxm = nltohd(sparam->maxm);
    minm = nltohd(sparam->minm);
    maxnm = nltohd(sparam->maxnm);
    minnm = nltohd(sparam->minnm);
    maxn = nltohd(sparam->maxn);
    minn = nltohd(sparam->minn);
    visangle = nltohd(sparam->visangle);
    visdist = nltohd(sparam->visdist);
    windir = nltohd(sparam->windir);
    winforce = nltohd(sparam->winforce);
    winang = nltohd(sparam->winang);
    winrand = nltohd(sparam->winrand);
    kickable_area = nltohd(sparam->kickable_area);
    catch_area_l = nltohd(sparam->catch_area_l);
    catch_area_w = nltohd(sparam->catch_area_w);
    catch_prob = nltohd(sparam->catch_prob);
    goalie_max_moves = (int)ntohs(sparam->goalie_max_moves);
    ckmargin = nltohd(sparam->ckmargin);
    offside_area = nltohd(sparam->offside_area);
    win_no = (int)ntohs(sparam->win_no);	// false
    win_random = (int)ntohs(sparam->win_random);	// false
    say_cnt_max = (int)ntohs(sparam->say_cnt_max);
    SayCoachMsgSize = (int)ntohs(sparam->SayCoachMsgSize);
    clang_win_size = (int)ntohs(sparam->clang_win_size);
    clang_define_win = (int)ntohs(sparam->clang_define_win);
    clang_meta_win = (int)ntohs(sparam->clang_meta_win);
    clang_advice_win = (int)ntohs(sparam->clang_advice_win);
    clang_info_win = (int)ntohs(sparam->clang_info_win);
    clang_mess_delay = (int)ntohs(sparam->clang_mess_delay);
    clang_mess_per_cycle = (int)ntohs(sparam->clang_mess_per_cycle);
    half_time = (int)ntohs(sparam->half_time);
    sim_st = (int)ntohs(sparam->sim_st);
    send_st = (int)ntohs(sparam->send_st);
    recv_st = (int)ntohs(sparam->recv_st);
    sb_step = (int)ntohs(sparam->sb_step);
    lcm_st = (int)ntohs(sparam->lcm_st);
    SayMsgSize = (int)ntohs(sparam->SayMsgSize);
    hear_max = (int)ntohs(sparam->hear_max);
    hear_inc = (int)ntohs(sparam->hear_inc);
    hear_decay = (int)ntohs(sparam->hear_decay);
    cban_cycle = (int)ntohs(sparam->cban_cycle);
    slow_down_factor = (int)ntohs(sparam->slow_down_factor);
    useoffside = (int)ntohs(sparam->useoffside); // true
    kickoffoffside = (int)ntohs(sparam->kickoffoffside); // true
    offside_kick_margin = nltohd(sparam->offside_kick_margin);
    audio_dist = nltohd(sparam->audio_dist);
    dist_qstep = nltohd(sparam->dist_qstep);
    land_qstep = nltohd(sparam->land_qstep);
    dir_qstep = nltohd(sparam->dir_qstep);
    dist_qstep_l = nltohd(sparam->dist_qstep_l);
    dist_qstep_r  = nltohd(sparam->dist_qstep_r);
    land_qstep_l = nltohd(sparam->land_qstep_l);
    land_qstep_r = nltohd(sparam->land_qstep_r);
    dir_qstep_l = nltohd(sparam->dir_qstep_l);
    dir_qstep_r = nltohd(sparam->dir_qstep_r);
    CoachMode = (int)ntohs(sparam->CoachMode); // false
    CwRMode = (int)ntohs(sparam->CwRMode); // false
    old_hear = (int)ntohs(sparam->old_hear); // false
    sv_st = (int)ntohs(sparam->sv_st);

    slowness_on_top_for_left_team = nltohd(sparam->slowness_on_top_for_left_team);
    slowness_on_top_for_right_team = nltohd(sparam->slowness_on_top_for_right_team);
    ka_length = nltohd(sparam->ka_length);
    ka_width = nltohd(sparam->ka_width);
    //double sparedouble5;
    //double sparedouble6;
    //double sparedouble7;
    //double sparedouble8;
    //double sparedouble9;
    //double sparedouble10;

    start_goal_l = (int)ntohs(sparam->start_goal_l);
    start_goal_r = (int)ntohs(sparam->start_goal_r);
    fullstate_l = (int)ntohs(sparam->fullstate_l);
    fullstate_r = (int)ntohs(sparam->fullstate_r);
    drop_time = (int)ntohs(sparam->drop_time);
    synch_mode = (int)ntohs(sparam->synch_mode); // false
    synch_offset = (int)ntohs(sparam->synch_offset);
    synch_micro_sleep = (int)ntohs(sparam->synch_micro_sleep);
    point_to_ban = (int)ntohs(sparam->point_to_ban);
    point_to_duration = (int)ntohs(sparam->point_to_duration);
}

void ServerParam::convert(server_params_t2 *sparam)
{
    gwidth = nltohd(sparam->gwidth);
    inertia_moment = nltohd(sparam->inertia_moment);
    psize = nltohd(sparam->psize);
    pdecay = nltohd(sparam->pdecay);
    prand = nltohd(sparam->prand);
    pweight = nltohd(sparam->pweight);
    pspeed_max = nltohd(sparam->pspeed_max);
    paccel_max = nltohd(sparam->paccel_max);
    stamina_max = nltohd(sparam->stamina_max);
    stamina_inc = nltohd(sparam->stamina_inc);
    recover_init = nltohd(sparam->recover_init);
    recover_dthr = nltohd(sparam->recover_dthr);
    recover_min = nltohd(sparam->recover_min);
    recover_dec = nltohd(sparam->recover_dec);
    effort_init = nltohd(sparam->effort_init);
    effort_dthr = nltohd(sparam->effort_dthr);
    effort_min = nltohd(sparam->effort_min);
    effort_dec = nltohd(sparam->effort_dec);
    effort_ithr = nltohd(sparam->effort_ithr);
    effort_inc = nltohd(sparam->effort_inc);
    kick_rand = nltohd(sparam->kick_rand);
    team_actuator_noise = (int)ntohs(sparam->team_actuator_noise); // false
    prand_factor_l = nltohd(sparam->prand_factor_l);
    prand_factor_r = nltohd(sparam->prand_factor_r);
    kick_rand_factor_l = nltohd(sparam->kick_rand_factor_l);
    kick_rand_factor_r = nltohd(sparam->kick_rand_factor_r);

    bsize = nltohd(sparam->bsize);
    bdecay = nltohd(sparam->bdecay);
    brand = nltohd(sparam->brand);
    bweight = nltohd(sparam->bweight);
    bspeed_max = nltohd(sparam->bspeed_max);
    baccel_max = nltohd(sparam->baccel_max);
    dprate = nltohd(sparam->dprate);
    kprate = nltohd(sparam->kprate);
    kmargin = nltohd(sparam->kmargin);
    ctlradius = nltohd(sparam->ctlradius);
    ctlradius_width = nltohd(sparam->ctlradius_width);
    maxp = nltohd(sparam->maxp);
    minp = nltohd(sparam->minp);
    maxm = nltohd(sparam->maxm);
    minm = nltohd(sparam->minm);
    maxnm = nltohd(sparam->maxnm);
    minnm = nltohd(sparam->minnm);
    maxn = nltohd(sparam->maxn);
    minn = nltohd(sparam->minn);
    visangle = nltohd(sparam->visangle);
    visdist = nltohd(sparam->visdist);
    windir = nltohd(sparam->windir);
    winforce = nltohd(sparam->winforce);
    winang = nltohd(sparam->winang);
    winrand = nltohd(sparam->winrand);
    kickable_area = nltohd(sparam->kickable_area);
    catch_area_l = nltohd(sparam->catch_area_l);
    catch_area_w = nltohd(sparam->catch_area_w);
    catch_prob = nltohd(sparam->catch_prob);
    goalie_max_moves = (int)ntohs(sparam->goalie_max_moves);
    ckmargin = nltohd(sparam->ckmargin);
    offside_area = nltohd(sparam->offside_area);
    win_no = (int)ntohs(sparam->win_no);	// false
    win_random = (int)ntohs(sparam->win_random);	// false
    say_cnt_max = (int)ntohs(sparam->say_cnt_max);
    SayCoachMsgSize = (int)ntohs(sparam->SayCoachMsgSize);
    clang_win_size = (int)ntohs(sparam->clang_win_size);
    clang_define_win = (int)ntohs(sparam->clang_define_win);
    clang_meta_win = (int)ntohs(sparam->clang_meta_win);
    clang_advice_win = (int)ntohs(sparam->clang_advice_win);
    clang_info_win = (int)ntohs(sparam->clang_info_win);
    clang_mess_delay = (int)ntohs(sparam->clang_mess_delay);
    clang_mess_per_cycle = (int)ntohs(sparam->clang_mess_per_cycle);
    half_time = (int)ntohs(sparam->half_time);
    sim_st = (int)ntohs(sparam->sim_st);
    send_st = (int)ntohs(sparam->send_st);
    recv_st = (int)ntohs(sparam->recv_st);
    sb_step = (int)ntohs(sparam->sb_step);
    lcm_st = (int)ntohs(sparam->lcm_st);
    SayMsgSize = (int)ntohs(sparam->SayMsgSize);
    hear_max = (int)ntohs(sparam->hear_max);
    hear_inc = (int)ntohs(sparam->hear_inc);
    hear_decay = (int)ntohs(sparam->hear_decay);
    cban_cycle = (int)ntohs(sparam->cban_cycle);
    slow_down_factor = (int)ntohs(sparam->slow_down_factor);
    useoffside = (int)ntohs(sparam->useoffside); // true
    kickoffoffside = (int)ntohs(sparam->kickoffoffside); // true
    offside_kick_margin = nltohd(sparam->offside_kick_margin);
    audio_dist = nltohd(sparam->audio_dist);
    dist_qstep = nltohd(sparam->dist_qstep);
    land_qstep = nltohd(sparam->land_qstep);
    dir_qstep = nltohd(sparam->dir_qstep);
    dist_qstep_l = nltohd(sparam->dist_qstep_l);
    dist_qstep_r  = nltohd(sparam->dist_qstep_r);
    land_qstep_l = nltohd(sparam->land_qstep_l);
    land_qstep_r = nltohd(sparam->land_qstep_r);
    dir_qstep_l = nltohd(sparam->dir_qstep_l);
    dir_qstep_r = nltohd(sparam->dir_qstep_r);
    CoachMode = (int)ntohs(sparam->CoachMode); // false
    CwRMode = (int)ntohs(sparam->CwRMode); // false
    old_hear = (int)ntohs(sparam->old_hear); // false
    sv_st = (int)ntohs(sparam->sv_st);

    slowness_on_top_for_left_team = nltohd(sparam->slowness_on_top_for_left_team);
    slowness_on_top_for_right_team = nltohd(sparam->slowness_on_top_for_right_team);
    ka_length = nltohd(sparam->ka_length);
    ka_width = nltohd(sparam->ka_width);
    //double sparedouble5;
    //double sparedouble6;
    //double sparedouble7;
    //double sparedouble8;
    //double sparedouble9;
    //double sparedouble10;

    start_goal_l = (int)ntohs(sparam->start_goal_l);
    start_goal_r = (int)ntohs(sparam->start_goal_r);
    fullstate_l = (int)ntohs(sparam->fullstate_l);
    fullstate_r = (int)ntohs(sparam->fullstate_r);
    drop_time = (int)ntohs(sparam->drop_time);
    synch_mode = (int)ntohs(sparam->synch_mode); // false
    synch_offset = (int)ntohs(sparam->synch_offset);
    synch_micro_sleep = (int)ntohs(sparam->synch_micro_sleep);
    point_to_ban = (int)ntohs(sparam->point_to_ban);
    point_to_duration = (int)ntohs(sparam->point_to_duration);
}


void ServerParam::toStruct(server_params_t *sparam)
{
  sparam->gwidth = htonl( (long)(SHOWINFO_SCALE2 * gwidth) );
  sparam->inertia_moment = htonl( (long)(SHOWINFO_SCALE2 * inertia_moment) );
  sparam->psize = htonl( (long)(SHOWINFO_SCALE2 * psize) );
  sparam->pdecay = htonl( (long)(SHOWINFO_SCALE2 * pdecay) );
  sparam->prand = htonl( (long)(SHOWINFO_SCALE2 * prand) );
  sparam->pweight = htonl( (long)(SHOWINFO_SCALE2 * pweight) );
  sparam->pspeed_max = htonl( (long)(SHOWINFO_SCALE2 * pspeed_max) );
  sparam->paccel_max = htonl( (long)(SHOWINFO_SCALE2 * paccel_max) );
  sparam->stamina_max = htonl( (long)(SHOWINFO_SCALE2 * stamina_max) );
  sparam->stamina_inc = htonl( (long)(SHOWINFO_SCALE2 * stamina_inc) );
  sparam->recover_init = htonl( (long)(SHOWINFO_SCALE2 * recover_init) );
  sparam->recover_dthr = htonl( (long)(SHOWINFO_SCALE2 * recover_dthr) );
  sparam->recover_min = htonl( (long)(SHOWINFO_SCALE2 * recover_min) );
  sparam->recover_dec = htonl( (long)(SHOWINFO_SCALE2 * recover_dec) );
  sparam->effort_init = htonl( (long)(SHOWINFO_SCALE2 * effort_init) );
  sparam->effort_dthr = htonl( (long)(SHOWINFO_SCALE2 * effort_dthr) );
  sparam->effort_min = htonl( (long)(SHOWINFO_SCALE2 * effort_min) );
  sparam->effort_dec = htonl( (long)(SHOWINFO_SCALE2 * effort_dec) );
  sparam->effort_ithr = htonl( (long)(SHOWINFO_SCALE2 * effort_ithr) );
  sparam->effort_inc = htonl( (long)(SHOWINFO_SCALE2 * effort_inc) );
  sparam->kick_rand = htonl( (long)(SHOWINFO_SCALE2 * kick_rand) );                                
  sparam->team_actuator_noise = htons( (short) team_actuator_noise );                        
  sparam->prand_factor_l = htonl( (long)(SHOWINFO_SCALE2 * prand_factor_l ) );                           
  sparam->prand_factor_r = htonl( (long)(SHOWINFO_SCALE2 * prand_factor_r ) );                           
  sparam->kick_rand_factor_l = htonl( (long)(SHOWINFO_SCALE2 * kick_rand_factor_l ) );
  sparam->kick_rand_factor_r = htonl( (long)(SHOWINFO_SCALE2 * kick_rand_factor_r ) );                       
  sparam->bsize = htonl( (long)(SHOWINFO_SCALE2 * bsize) );
  sparam->bdecay = htonl( (long)(SHOWINFO_SCALE2 * bdecay) );
  sparam->brand = htonl( (long)(SHOWINFO_SCALE2 * brand) );
  sparam->bweight = htonl( (long)(SHOWINFO_SCALE2 * bweight) );
  sparam->bspeed_max = htonl( (long)(SHOWINFO_SCALE2 * bspeed_max) );
  sparam->baccel_max = htonl( (long)(SHOWINFO_SCALE2 * baccel_max ) );
  sparam->dprate = htonl( (long)(SHOWINFO_SCALE2 * dprate) );
  sparam->kprate = htonl( (long)(SHOWINFO_SCALE2 * kprate) );
  sparam->kmargin = htonl( (long)(SHOWINFO_SCALE2 * kmargin) );
  sparam->ctlradius = htonl( (long)(SHOWINFO_SCALE2 * ctlradius) );
  sparam->ctlradius_width = htonl( (long)(SHOWINFO_SCALE2 * ctlradius_width) );
  sparam->maxp = htonl( (long)(SHOWINFO_SCALE2 * maxp) );
  sparam->minp = htonl( (long)(SHOWINFO_SCALE2 * minp) );
  sparam->maxm = htonl( (long)(SHOWINFO_SCALE2 * maxm) );
  sparam->minm = htonl( (long)(SHOWINFO_SCALE2 * minm) );
  sparam->maxnm = htonl( (long)(SHOWINFO_SCALE2 * maxnm) );
  sparam->minnm = htonl( (long)(SHOWINFO_SCALE2 * minnm) );
  sparam->maxn = htonl( (long)(SHOWINFO_SCALE2 * maxn) );
  sparam->minn = htonl( (long)(SHOWINFO_SCALE2 * minn) );
  sparam->visangle = htonl( (long)(SHOWINFO_SCALE2 * visangle) );
  sparam->visdist = htonl( (long)(SHOWINFO_SCALE2 * visdist) );
  sparam->windir = htonl( (long)(SHOWINFO_SCALE2 * windir) );
  sparam->winforce = htonl( (long)(SHOWINFO_SCALE2 * winforce) );
  sparam->winang = htonl( (long)(SHOWINFO_SCALE2 * winang) );
  sparam->winrand = htonl( (long)(SHOWINFO_SCALE2 * winrand) );
  sparam->kickable_area = htonl( (long)(SHOWINFO_SCALE2 * kickable_area) );
  sparam->catch_area_l = htonl( (long)(SHOWINFO_SCALE2 * catch_area_l) );
  sparam->catch_area_w = htonl( (long)(SHOWINFO_SCALE2 * catch_area_w) );
  sparam->catch_prob = htonl( (long)(SHOWINFO_SCALE2 * catch_prob) );
  sparam->goalie_max_moves = htons( (short) goalie_max_moves );                 
  sparam->ckmargin = htonl( (long)(SHOWINFO_SCALE2 * ckmargin) );
  sparam->offside_area = htonl( (long)(SHOWINFO_SCALE2 * offside_area) );
  sparam->win_no = htons( (short) win_no);
  sparam->win_random = htons( (short) win_random) ;
  sparam->say_cnt_max = htons( (short) say_cnt_max) ;
  sparam->SayCoachMsgSize = htons( (short) SayCoachMsgSize) ;
  sparam->clang_win_size = htons( (short) clang_win_size );
  sparam->clang_define_win = htons( (short) clang_define_win );
  sparam->clang_meta_win = htons( (short) clang_meta_win );
  sparam->clang_advice_win = htons( (short) clang_advice_win );
  sparam->clang_info_win = htons( (short) clang_info_win );
  sparam->clang_mess_delay = htons( (short) clang_mess_delay );
  sparam->clang_mess_per_cycle = htons( (short) clang_mess_per_cycle );
  sparam->half_time = htons( (short) half_time) ;
  sparam->sim_st = htons( (short) sim_st) ;
  sparam->send_st = htons( (short) send_st) ;
  sparam->recv_st = htons( (short) recv_st) ;
  sparam->sb_step = htons( (short) sb_step) ;
  sparam->lcm_st = htons( (short) lcm_st) ;                        
  sparam->SayMsgSize = htons( (short) SayMsgSize) ;
  sparam->hear_max = htons( (short) hear_max) ;
  sparam->hear_inc = htons( (short) hear_inc) ;
  sparam->hear_decay = htons( (short) hear_decay) ;
  sparam->cban_cycle = htons( (short) cban_cycle) ;
  sparam->slow_down_factor = htons( (short) slow_down_factor) ;                          
  sparam->useoffside = htons( (short) useoffside) ;
  sparam->kickoffoffside = htons( (short) kickoffoffside) ;
  sparam->offside_kick_margin = htonl( (long)(SHOWINFO_SCALE2 * offside_kick_margin) );
  sparam->audio_dist = htonl( (long)(SHOWINFO_SCALE2 * audio_dist) );
  sparam->dist_qstep = htonl( (long)(SHOWINFO_SCALE2 * dist_qstep) );
  sparam->land_qstep = htonl( (long)(SHOWINFO_SCALE2 * land_qstep) );
#ifdef NEW_QSTEP
  sparam->dir_qstep = htonl( (long)(SHOWINFO_SCALE2 * dir_qstep) );
  sparam->dist_qstep_l = htonl( (long)(SHOWINFO_SCALE2 * dist_qstep_l) );
  sparam->dist_qstep_r = htonl( (long)(SHOWINFO_SCALE2 * dist_qstep_r) );
  sparam->land_qstep_l = htonl( (long)(SHOWINFO_SCALE2 * land_qstep_l) );
  sparam->land_qstep_r = htonl( (long)(SHOWINFO_SCALE2 * land_qstep_r) );
  sparam->dir_qstep_l = htonl( (long)(SHOWINFO_SCALE2 * dir_qstep_l) );
  sparam->dir_qstep_r = htonl( (long)(SHOWINFO_SCALE2 * dir_qstep_r) );
#else
  sparam->dir_qstep = htonl( (long)(SHOWINFO_SCALE2 * -1) );
  sparam->dist_qstep_l = htonl( (long)(SHOWINFO_SCALE2 * -1) );
  sparam->dist_qstep_r = htonl( (long)(SHOWINFO_SCALE2 * -1) );
  sparam->land_qstep_l = htonl( (long)(SHOWINFO_SCALE2 * -1) );
  sparam->land_qstep_r = htonl( (long)(SHOWINFO_SCALE2 * -1) );
  sparam->dir_qstep_l = htonl( (long)(SHOWINFO_SCALE2 * -1) );
  sparam->dir_qstep_r = htonl( (long)(SHOWINFO_SCALE2 * -1) );
#endif    
  sparam->CoachMode = htons( (short) CoachMode) ;
  sparam->CwRMode = htons( (short) CwRMode) ;
  sparam->old_hear = htons( (short) old_hear) ;
  sparam->sv_st = htons( (short) sv_st) ;

  sparam->synch_mode   = htons( (short)synch_mode);//pfr:SYNCH
  sparam->synch_offset = htons( (short)synch_offset);//pfr:SYNCH
  sparam->synch_micro_sleep = htons( (short)synch_micro_sleep);//pfr:SYNCH

  sparam->start_goal_l = htons( (short)start_goal_l );
  sparam->start_goal_r = htons( (short)start_goal_r );

  sparam->fullstate_l = htons( (short)fullstate_l );
  sparam->fullstate_r = htons( (short)fullstate_r );

  sparam->drop_time = htons( (short) drop_time) ;

  sparam->slowness_on_top_for_left_team = htonl( (long)(SHOWINFO_SCALE2 * slowness_on_top_for_left_team) );
  sparam->slowness_on_top_for_right_team = htonl( (long)(SHOWINFO_SCALE2 * slowness_on_top_for_left_team) );

  sparam->ka_length = htonl( (long)(SHOWINFO_SCALE2 * ka_length) );
  sparam->ka_width = htonl( (long)(SHOWINFO_SCALE2 * ka_width) );
  //sparam->kaway = htons( (short) kaway);

  sparam->point_to_ban =  htons( (short)point_to_ban );
  sparam->point_to_duration =  htons( (short)point_to_duration );
}

void ServerParam::toString(CString &to)
{
    CString tmp;
    to = "server_params\n";

    tmp.Format("gwidth : %.3f\n", gwidth);
    to += tmp;
    tmp.Format("inertia_moment : %.4f\n", inertia_moment);
    to += tmp;
    tmp.Format("psize : %.3f\n", psize);
    to += tmp;
    tmp.Format("pdecay : %.4f\n", pdecay);
    to += tmp;
    tmp.Format("prand : %.4f\n", prand);
    to += tmp;
    tmp.Format("pweight : %.3f\n", pweight);
    to += tmp;
    tmp.Format("pspeed_max : %.4f\n", pspeed_max);
    to += tmp;
    tmp.Format("paccel_max : %.4f\n", paccel_max);
    to += tmp;
    tmp.Format("stamina_max : %.3f\n", stamina_max);
    to += tmp;
    tmp.Format("stamina_inc : %.4f\n", stamina_inc);
    to += tmp;
    tmp.Format("recover_init : %.4f\n", recover_init);
    to += tmp;
    tmp.Format("recover_dthr : %.4f\n", recover_dthr);
    to += tmp;
    tmp.Format("recover_min : %.4f\n", recover_min);
    to += tmp;
    tmp.Format("recover_dec %.4f\n", recover_dec);
    to += tmp;
    tmp.Format("effort_init : %.4f\n", effort_init);
    to += tmp;
    tmp.Format("effort_dthr : %.4f\n", effort_dthr);
    to += tmp;
    tmp.Format("effort_min : %.4f\n", effort_min);
    to += tmp;
    tmp.Format("effort_dec : %.4f\n", effort_dec);
    to += tmp;
    tmp.Format("effort_ithr : %.4f\n", effort_ithr);
    to += tmp;
    tmp.Format("effort_inc : %.4f\n", effort_inc);
    to += tmp;
    tmp.Format("kick_rand : %.4f\n", kick_rand);
    to += tmp;
    tmp.Format("team_actuator_noise : %d\n", team_actuator_noise);
    to += tmp;
    tmp.Format("prand_factor_l : %.4f\n", prand_factor_l);
    to += tmp;
    tmp.Format("prand_factor_r : %.4f\n", prand_factor_r);
    to += tmp;
    tmp.Format("kick_rand_factor_l : %.4f\n", kick_rand_factor_l);
    to += tmp;
    tmp.Format("kick_rand_factor_r : %.4f\n", kick_rand_factor_r);
    to += tmp;
    tmp.Format("bsize : %.4f\n", bsize);
    to += tmp;
    tmp.Format("bdecay : %.4f\n", bdecay);
    to += tmp;
    tmp.Format("brand : %.4f\n", brand);
    to += tmp;
    tmp.Format("bweight : %.4f\n", bweight);
    to += tmp;
    tmp.Format("bspeed_max : %.4f\n", bspeed_max);
    to += tmp;
    tmp.Format("baccel_max : %.4f\n", baccel_max);
    to += tmp;
    tmp.Format("dprate : %.5f\n", dprate);
    to += tmp;
    tmp.Format("kprate : %.5f\n", kprate);
    to += tmp;
    tmp.Format("kmargin : %.4f\n", kmargin);
    to += tmp;
    tmp.Format("ctlradius : %.4f\n", ctlradius);
    to += tmp;
    tmp.Format("ctlradius_width : %.4f\n", ctlradius_width);
    to += tmp;
    tmp.Format("maxp : %.3f\n", maxp);
    to += tmp;
    tmp.Format("minp : %.3f\n", minp);
    to += tmp;
    tmp.Format("maxm : %.3f\n", maxm);
    to += tmp;
    tmp.Format("minm : %.3f\n", minm);
    to += tmp;
    tmp.Format("maxnm : %.3f\n", maxnm);
    to += tmp;
    tmp.Format("minnm : %.3f\n", minnm);
    to += tmp;
    tmp.Format("maxn : %.3f\n", maxn);
    to += tmp;
    tmp.Format("minn : %.3f\n", minn);
    to += tmp;
    tmp.Format("visangle : %.3f\n", visangle);
    to += tmp;
    tmp.Format("visdisd : %.3f\n", visdist);
    to += tmp;
    tmp.Format("windir : %.3f\n", windir);
    to += tmp;
    tmp.Format("winforce : %.3f\n", winforce);
    to += tmp;
    tmp.Format("winang : %.4f\n", winang);
    to += tmp;
    tmp.Format("winrand : %.4f\n", winrand);
    to += tmp;
    tmp.Format("kickable_area\n", kickable_area);
    to += tmp;
    tmp.Format("catch_area_l : %.3f\n", catch_area_l);
    to += tmp;
    tmp.Format("catch_area_w : %.3f\n", catch_area_w);
    to += tmp;
    tmp.Format("catch_prob : %.4f\n", catch_prob);
    to += tmp;
    tmp.Format("goalie_max_moves : %d\n", goalie_max_moves);
    to += tmp;
    tmp.Format("ckmargin : %.3f\n", ckmargin);
    to += tmp;
    tmp.Format("offside_area : %.4f\n", offside_area);
    to += tmp;
    tmp.Format("win_no : %d\n", win_no);
    to += tmp;
    tmp.Format("win_random : %d\n", win_random);
    to += tmp;
    tmp.Format("say_cnt_max : %d\n", say_cnt_max);
    to += tmp;
    tmp.Format("SayCoachMsgSize : %d\n", SayCoachMsgSize);
    to += tmp;
    tmp.Format("clang_win_size : %d\n", clang_win_size);
    to += tmp;
    tmp.Format("clang_define_win : %d\n", clang_define_win);
    to += tmp;
    tmp.Format("clang_meta_win : %d\n", clang_meta_win);
    to += tmp;
    tmp.Format("clang_advice_win : %d\n", clang_advice_win);
    to += tmp;
    tmp.Format("clang_info_win : %d\n", clang_info_win);
    to += tmp;
    tmp.Format("clang_mess_delay : %d\n", clang_mess_delay);
    to += tmp;
    tmp.Format("clang_mess_per_cycle : %d\n", clang_mess_per_cycle);
    to += tmp;
    tmp.Format("half_time : %d\n", half_time);
    to += tmp;
    tmp.Format("sim_st : %d\n", sim_st);
    to += tmp;
    tmp.Format("send_st : %d\n", send_st);
    to += tmp;
    tmp.Format("recv_st : %d\n", recv_st);
    to += tmp;
    tmp.Format("sb_step : %d\n", sb_step);
    to += tmp;
    tmp.Format("lcm_st : %d\n", lcm_st);
    to += tmp;
    tmp.Format("SayMsgSize : %d\n", SayMsgSize);
    to += tmp;
    tmp.Format("hear_max : %d\n", hear_max);
    to += tmp;
    tmp.Format("hear_inc : %d\n", hear_inc);
    to += tmp;
    tmp.Format("hear_decay : %d\n", hear_decay);
    to += tmp;
    tmp.Format("cban_cycle : %d\n", cban_cycle);
    to += tmp;
    tmp.Format("slow_down_factor : %d\n", slow_down_factor);
    to += tmp;
    tmp.Format("useoffside : %d\n", useoffside);
    to += tmp;
    tmp.Format("kickoffoffside : %d\n", kickoffoffside);
    to += tmp;
    tmp.Format("offside_kick_margin : %.4f\n", offside_kick_margin);
    to += tmp;
    tmp.Format("audio_dist : %.3f\n", audio_dist);
    to += tmp;
    tmp.Format("dist_qstep : %.4f\n", dist_qstep);
    to += tmp;
    tmp.Format("land_qstep : %.4f\n", land_qstep);
    to += tmp;
    tmp.Format("dir_qstep : %.4f\n", dir_qstep);
    to += tmp;
    tmp.Format("dist_qstep_l : %.4f\n", dist_qstep_l);
    to += tmp;
    tmp.Format("dist_qstep_r : %.4f\n", dist_qstep_r);
    to += tmp;
    tmp.Format("land_qstep_l : %.4f\n", land_qstep_l);
    to += tmp;
    tmp.Format("land_qstep_r : %.4f\n", land_qstep_r);
    to += tmp;
    tmp.Format("dir_qstep_l : %.4f\n", dir_qstep_l);
    to += tmp;
    tmp.Format("dir_qstep_r : %.4f\n", dir_qstep_r);
    to += tmp;
    tmp.Format("CoachMode : %d\n", CoachMode);
    to += tmp;
    tmp.Format("CwRMode : %d\n", CwRMode);
    to += tmp;
    tmp.Format("old_hear : %d\n", old_hear);
    to += tmp;
    tmp.Format("sv_st : %d\n", sv_st);
    to += tmp;

  // spare variables which are to be used for paramenter added in the future
    tmp.Format("slowness_on_top_for_left_team : %.4f\n", slowness_on_top_for_left_team);
    to += tmp;
    tmp.Format("slowness_on_top_for_right_team : %.4f\n", slowness_on_top_for_right_team);
    to += tmp;
    tmp.Format("ka_length : %.5f\n", ka_length);
    to += tmp;
    tmp.Format("ka_width : %.5f\n", ka_width);
    to += tmp;
//  double sparedouble5;
//  double sparedouble6;
//  double sparedouble7;
//  double sparedouble8;
//  double sparedouble9;
//  double sparedouble10;
    tmp.Format("start_goal_l : %d\n", start_goal_l);
    to += tmp;
    tmp.Format("start_goal_r : %d\n", start_goal_r);
    to += tmp;
    tmp.Format("fullstate_l : %d\n", fullstate_l);
    to += tmp;
    tmp.Format("fullstate_r : %d\n", fullstate_r);
    to += tmp;
    tmp.Format("drop_time : %d\n", drop_time);
    to += tmp;
    tmp.Format("sync_mode : %d\n", synch_mode);
    to += tmp;
    tmp.Format("synch_offsed : %d\n", synch_offset);
    to += tmp;
    tmp.Format("synch_micro_sleep : %d\n", synch_micro_sleep);
    to += tmp;
    tmp.Format("point_to_ban : %d\n", point_to_ban);
    to += tmp;
    tmp.Format("point_to_duration : %d\n", point_to_duration);
    to += tmp;

/*
    // extra params
    double M_tackle_dist;
    double M_tackle_back_dist;
    double M_tackle_width;
    double M_tackle_exponent;
    int M_tackle_cycles;
    double M_tackle_power_rate;
*/
}
