
#ifndef PARAMS_H
#define PARAMS_H

#include "upgrade.h"

#ifndef PI
#define PI  3.1415926535
#endif

#define LEFT_TEAM   1
#define BALL        0
#define RIGHT_TEAM  -1

#define COLOR_PINK              RGB(213, 117, 117)
#define COLOR_LIGHTGREEN		RGB(20, 150, 20)
#define COLOR_DARKGREEN			RGB(10, 120, 10)
#define COLOR_BLACK				RGB(0, 0, 0)
#define COLOR_WHITE				RGB(255, 255, 255)
#define COLOR_RED				RGB(255, 0, 0)
#define COLOR_YELLOW            RGB(252, 231, 31)
#define COLOR_LIGHTBLUE			RGB(55, 255, 255)
#define COLOR_BLUE				RGB(0, 0, 255)
#define COLOR_GREEN				RGB(51, 255, 0)
#define COLOR_PURPLE			RGB(196, 0, 204)
#define COLOR_LILAC 			RGB(213, 132, 224)
#define COLOR_VIOLET            RGB(135, 0, 204)
#define COLOR_WVIOLET           RGB(255, 180, 255)

#define COLOR_BALL_LOCUS        RGB(200, 215, 215)
#define COLOR_PLAYER_LOCUS2     RGB(220, 135, 250)

//#define TOP_MARGIN				0 //5.0
#define TOP_MARGIN				1.0
//#define PITCH_MARGIN4 //2.0
#define PITCH_MARGIN			5.0

#define PITCH_LENGTH 			105.0
#define PITCH_WIDTH 	 		68.0
#define CENTER_CIRCLE_R			9.15
#define PENALTY_CIRCLE_R		9.15
#define CIRCLE_ARC				7.1
#define PENALTY_AREA_LENGTH		16.5
#define PENALTY_AREA_WIDTH		40.32
#define GOAL_AREA_LENGTH		5.5
#define GOAL_AREA_WIDTH			18.32
#define GOAL_DEPTH				2.44
#define GOAL_WIDTH				14.02
#define GOAL_POST_R     0.06
#define PENALTY_SPOT_DIST		11.0
#define CORNER_ARC_R			1.0
#define PLAYER_SIZE				0.3
#define BALL_SIZE				0.085
#define KICKABLE_MARGIN			0.7
// in meters as all above
#define FONT_SIZE_METER 1.7


#define PLAYMODE_STRINGS {"before_kick_off",\
    "time_over",\
    "play_on",\
    "kick_off_l",\
    "kick_off_r",\
    "kick_in_l",\
    "kick_in_r",\
    "free_kick_l",\
    "free_kick_r",\
    "corner_kick_l",\
    "corner_kick_r",\
    "goal_kick_l",\
    "goal_kick_r",\
    "goal_l",\
    "goal_r",\
    "drop_ball",\
    "offside_l",\
    "offside_r",\
    		"penalty_kick_l",\
			"penalty_kick_r",\
			"first_half_over",\
			"pause",\
			"human_judge",\
			"foul_charge_l",\
			"foul_charge_r",\
			"foul_push_l",\
			"foul_push_r",\
			"foul_multiple_attack_l",\
			"foul_multiple_attack_r",\
			"foul_ballout_l",\
			"foul_ballout_r",\
      "back_pass_l", \
      "back_pass_r", \
      "free_kick_fault_l", \
      "free_kick_fault_r", \
      "catch_fault_l", \
      "cacth_fault_r", \
      "indirect_free_kick_l", \
      "indirect_free_kick_r",\
      "penalty_setup_l", \
      "penalty_setup_r",\
      "penalty_ready_l",\
      "penalty_ready_r", \
      "penalty_taken_l", \
      "penalty_taken_r", \
      "penalty_miss_l", \
      "penalty_miss_r", \
      "penalty_score_l", \
      "penalty_score_r", \
      "unknown", \
      "unknown", \
      "unknown", \
      "unknown", \
      "unknown", \
      "unknown", \
      "unknown", \
      "unknown" \
    }

enum PlayMode {
    PM_BEFORE_KICK_OFF,
    PM_TIME_OVER,
    PM_PLAY_ON,
    PM_KICK_OFF_L,
    PM_KICK_OFF_R,
    PM_KICK_IN_L,
    PM_KICK_IN_R,
    PM_FREE_KICK_L,
    PM_FREE_KICK_R,
    PM_CORNER_KICK_L,
    PM_CORNER_KICK_R,
    PM_GOAL_KICK_L,
    PM_GOAL_KICK_R,
    PM_GOAL_L,
    PM_GOAL_R,
    PM_DROP_BALL,
    PM_OFFSIDE_L,
    PM_OFFSIDE_R,
    PM_PENALTY_KICK_L,
    PM_PENALTY_KICK_R,
    PM_FIRST_HALF_OVER,
    PM_PAUSE,
    PM_HUMAN_JUDGE,
    PM_FOUL_CHARGE_L,
    PM_FOUL_CHARGE_R,
    PM_FOUL_PUSH_L,
    PM_FOUL_PUSH_R,
    PM_FOUL_MULTIPLE_ATTACK_L,
    PM_FOUL_MULTIPLE_ATTACK_R,
    PM_FOUL_BALL_OUT_L,
    PM_FOUL_BALL_OUT_R,
    PM_BACK_PASS_L,
    PM_BACK_PASS_R,
    PM_FREE_KICK_FAULT_L,
    PM_FREE_KICK_FAULT_R,
    PM_CATCH_FAULT_L,
    PM_CATCH_FAULT_R,
    PM_INDIRECT_FREE_KICK_L,
    PM_INDIRECT_FREE_KICK_R,
    PM_PENALTY_SETUP_L,
    PM_PENALTY_SETUP_R,
    PM_PENALTY_READY_L,
    PM_PENALTY_READY_R,
    PM_PENALTY_TAKEN_L,
    PM_PENALTY_TAKEN_R,
    PM_PENALTY_MISS_L,
    PM_PENALTY_MISS_R,
    PM_PENALTY_SCORE_L,
    PM_PENALTY_SCORE_R,
    PM_MAX
};

#define HALF_TIME       21
#define TIME_UP         22
#define EXTEND          23
#define FOUL_L          50
#define FOUL_R          60



struct PlayerParam {
    PlayerParam();
    void convert(player_params_t* pparam);
    void toStruct(player_params_t* pparam);

    int player_types;
    int subs_max;
    int pt_max;
    
    double player_speed_max_delta_min;
    double player_speed_max_delta_max;
    double stamina_inc_max_delta_factor;
    
    double player_decay_delta_min;
    double player_decay_delta_max;
    double inertia_moment_delta_factor;

    double dash_power_rate_delta_min;
    double dash_power_rate_delta_max;
    double player_size_delta_factor;

    double kickable_margin_delta_min;
    double kickable_margin_delta_max;
    double kick_rand_delta_factor;

    double extra_stamina_delta_min;
    double extra_stamina_delta_max;
    double effort_max_delta_factor;
    double effort_min_delta_factor;

    int random_seed;

    double new_dash_power_rate_delta_min;
    double new_dash_power_rate_delta_max;
    double new_stamina_inc_max_delta_factor;  

    double sparedouble5;
    double sparedouble6;
    double sparedouble7;
    double sparedouble8;
    double sparedouble9;
    double sparedouble10;

  int spareint1;
  int spareint2;
  int spareint3;
  int spareint4;
  int spareint5;
  int spareint6;
  int spareint7;
  int spareint8;
  int spareint9;
  int spareint10;
};

struct PlayerType {
    PlayerType();
    void convert(player_type_t* ptinfo);
    void toStruct(player_type_t* ptinfo);
    void setDefaultParam();
    void toString(CString &to);

    int id;
    double player_speed_max;
    double stamina_inc_max;
    double player_decay;
    double inertia_moment;
    double dash_power_rate;
    double player_size;
    double kickable_margin;
    double kick_rand;
    double extra_stamina;
    double effort_max;
    double effort_min;

  // spare variables which are to be used for paramenter added in the future    
    double sparedouble1;
    double sparedouble2;
    double sparedouble3;
    double sparedouble4;
    double sparedouble5;
    double sparedouble6;
    double sparedouble7;
    double sparedouble8;
    double sparedouble9;
    double sparedouble10;

};

struct ServerParam {
    ServerParam();
    void convert(server_params_t* sparam);
    void convert(server_params_t2 *sparam);
    void toStruct(server_params_t* sparam);
    void toString(CString &to);
    void setDefaultParam();
    //void toString(CString &to);

    double gwidth ;					/* goal width */
    double inertia_moment ;			/* intertia moment for turn */
    double psize ;					/* player size */
    double pdecay ;					/* player decay */
    double prand ;					/* player rand */
    double pweight ;					/* player weight */
    double pspeed_max ;				/* player speed max */
    // th 6.3.00
    double paccel_max ;				/* player acceleration max */
    //
    double stamina_max ;				/* player stamina max */
    double stamina_inc ;				/* player stamina inc */
    double recover_init ;			/* player recovery init */
    double recover_dthr ;			/* player recovery decriment threshold */
    double recover_min ;				/* player recovery min */
    double recover_dec ;				/* player recovery decriment */
    double effort_init ;				/* player dash effort init */
    double effort_dthr ;				/* player dash effort decriment threshold */
    double effort_min ;				/* player dash effrot min */
    double effort_dec ;				/* player dash effort decriment */
    double effort_ithr ;				/* player dash effort incriment threshold */
    double effort_inc ;				/* player dash effort incriment */
    // pfr 8/14/00: for RC2000 evaluation
    double kick_rand;                                /* noise added directly to kicks */
    int team_actuator_noise;                        /* flag whether to use team specific actuator noise */
    double prand_factor_l;                           /* factor to multiple prand for left team */
    double prand_factor_r;                           /* factor to multiple prand for right team */
    double kick_rand_factor_l;                       /* factor to multiple kick_rand for left team */
    double kick_rand_factor_r;                       /* factor to multiple kick_rand for right team */

    double bsize ;					/* ball size */
    double bdecay ;					/* ball decay */
    double brand ;					/* ball rand */
    double bweight ;					/* ball weight */
    double bspeed_max ;				/* ball speed max */
    // th 6.3.00
    double baccel_max;				/* ball acceleration max */
    //
    double dprate ;					/* dash power rate */
    double kprate ;					/* kick power rate */
    double kmargin ;					/* kickable margin */
    double ctlradius ;				/* control radius */
    double ctlradius_width ;			/* (control radius) - (plyaer size) */
    double maxp ;					/* max power */
    double minp ;					/* min power */
    double maxm ;					/* max moment */
    double minm ;					/* min moment */
    double maxnm ;					/* max neck moment */
    double minnm ;					/* min neck moment */
    double maxn ;					/* max neck angle */
    double minn ;					/* min neck angle */
    double visangle ;				/* visible angle */
    double visdist ;					/* visible distance */
    double windir ;					/* wind direction */
    double winforce ;				/* wind force */
    double winang ;					/* wind angle for rand */
    double winrand ;					/* wind force for force */
    double kickable_area ;			/* kickable_area */
    double catch_area_l ;			/* goalie catchable area length */
    double catch_area_w ;			/* goalie catchable area width */
    double catch_prob ;				/* goalie catchable possibility */
    int   goalie_max_moves;                 /* goalie max moves after a catch */	
    double ckmargin ;				/* corner kick margin */
    double offside_area ;			/* offside active area size */
    int win_no ;					/* wind factor is none */
    int win_random ;				/* wind factor is random */
    int say_cnt_max ;				/* max count of coach SAY */
    int SayCoachMsgSize ;				/* max length of coach SAY */
    int clang_win_size;
    int clang_define_win;
    int clang_meta_win;
    int clang_advice_win;
    int clang_info_win;
    int clang_mess_delay;
    int clang_mess_per_cycle;
    int half_time ;					/* half time */
    int sim_st ;					/* simulator step interval msec */
    int send_st ;					/* udp send step interval msec */
    int recv_st ;					/* udp recv step interval msec */
    int sb_step ;					/* sense_body interval step msec */
    int lcm_st ;		                        /* lcm of all the above steps msec */
    int SayMsgSize ;				/* string size of say message */
    int hear_max ;					/* player hear_capacity_max */
    int hear_inc ;					/* player hear_capacity_inc */
    int hear_decay ;				/* player hear_capacity_decay */
    int cban_cycle ;				/* goalie catch ban cycle */
    int slow_down_factor ;                          /* factor to slow down simulator and send intervals */
    int useoffside ;				/* flag for using off side rule */
    int kickoffoffside ;			/* flag for permit kick off offside */
    double offside_kick_margin ;		/* offside kick margin */
    double audio_dist ;				/* audio cut off distance */
    double dist_qstep ;				/* quantize step of distance */
    double land_qstep ;				/* quantize step of distance for landmark */
    double dir_qstep ;				/* quantize step of direction */
    double dist_qstep_l ;			/* team right quantize step of distance */
    double dist_qstep_r ;			/* team left quantize step of distance */
    double land_qstep_l ;			/* team right quantize step of distance for landmark */
    double land_qstep_r ;			/* team left quantize step of distance for landmark */
    double dir_qstep_l ;				/* team left quantize step of direction */
    double dir_qstep_r ;				/* team right quantize step of direction */
    int CoachMode ;				/* coach mode */
    int CwRMode ;					/* coach with referee mode */
    int old_hear ;					/* old format for hear command (coach) */
    int sv_st ;					/* online coach's look interval step */


  // spare variables which are to be used for paramenter added in the future
  double slowness_on_top_for_left_team;
  double slowness_on_top_for_right_team;
  double ka_length;
  double ka_width;
  double sparedouble5;
  double sparedouble6;
  double sparedouble7;
  double sparedouble8;
  double sparedouble9;
  double sparedouble10;

  int start_goal_l;
  int start_goal_r;
  int fullstate_l;
  int fullstate_r;
  int drop_time;
  int synch_mode;
  int synch_offset;
  int synch_micro_sleep;
  int point_to_ban;
  int point_to_duration;



    // extra params
    double M_tackle_dist;
    double M_tackle_back_dist;
    double M_tackle_width;
    double M_tackle_exponent;
    int M_tackle_cycles;
    double M_tackle_power_rate;


};

#endif

