
#ifndef TYPE_H
#define TYPE_H

#define SHOWINFO_SCALE		16.0
#define SHOWINFO_SCALE2		65536.0

#define MAX_PLAYER 11

#define	NO_INFO		0
#define	SHOW_MODE	1
#define	MSG_MODE	2
#define DRAW_MODE	3
#define	BLANK_MODE	4
#define	PM_MODE		5
#define	TEAM_MODE	6
#define PT_MODE		7
#define	PARAM_MODE	8
#define PPARAM_MODE	9


#define DISABLE			0x0000
#define STAND			0x0001
#define KICK			0x0002
#define KICK_FAULT		0x0004
#define GOALIE			0x0008
#define CATCH2			0x0010
#define CATCH_FAULT		0x0020
#define BALL_TO_PLAYER	0x0040
#define PLAYER_TO_BALL	0x0080
#define DISCARD			0x0100
// [I.Noda:00/05/13] added for 3D viewer/commentator/small league
#define LOST			0x0200
#define BALL_COLLIDE		0x0400 // player collided with the ball
#define	PLAYER_COLLIDE		0x0800 // player collided with another player
#define TACKLE       0x1000
#define TACKLE_FAULT 0x2000
#define BACK_PASS 0x4000
#define FREE_KICK_FAULT 0x8000


#define	MSG_BOARD	1
#define	LOG_BOARD	2


typedef struct {
	short	enable ;
	short	side ;
	short	unum ;
	short	angle ;
	short	x ;
	short	y ;
} pos_t ;

typedef struct {
	char	name[16] ;
	short	score ;
} team_t ;

typedef struct {
	char	pmode ;
	team_t	team[2] ;
	pos_t	pos[2*MAX_PLAYER+1] ;
	short	time ;
} showinfo_t ;

typedef	struct {
	short	board ;
	char	message[2048] ;
} msginfo_t ;

typedef struct {
	short	mode ;
	union {
		showinfo_t	show ;
		msginfo_t	msg ;
	} body ;
} dispinfo_t ;

typedef struct displist {
	unsigned long	shost ;
        int				sport ;
        int 		version ;
	struct displist *next ;
} displist_t ;

typedef struct {
  long x;
  long y;
  long deltax;
  long deltay;
} ball_t;

typedef struct {
  short mode;
  short type;
  long x;
  long y;
  long deltax;
  long deltay;
  long body_angle;
  long head_angle;
  long view_width;
  short view_quality;
  long stamina;
  long effort;
  long recovery;
  short kick_count;
  short dash_count;
  short turn_count;
  short say_count;
  short tneck_count;
  short catch_count;
  short move_count;
  short chg_view_count;
} player_t;

typedef struct {
  char		pmode ;
  team_t	team[2] ;
  ball_t	ball;
  player_t	pos[MAX_PLAYER * 2] ;
  short		time ;
} showinfo_t2 ;  

typedef struct {
  ball_t	ball;
  player_t	pos[MAX_PLAYER * 2] ;
  short		time ;
} short_showinfo_t2 ;  

typedef struct {
    short id;
    long player_speed_max;
    long stamina_inc_max;
    long player_decay;
    long inertia_moment;
    long dash_power_rate;
    long player_size;
    long kickable_margin;
    long kick_rand;
    long extra_stamina;
    long effort_max;
    long effort_min;

  // spare variables which are to be used for paramenter added in the future    
    long sparelong1;
    long sparelong2;
    long sparelong3;
    long sparelong4;
    long sparelong5;
    long sparelong6;
    long sparelong7;
    long sparelong8;
    long sparelong9;
    long sparelong10;
} player_type_t;

typedef struct
{
    long gwidth ;					/* goal width */
    long inertia_moment ;			/* intertia moment for turn */
    long psize ;					/* player size */
    long pdecay ;					/* player decay */
    long prand ;					/* player rand */
    long pweight ;					/* player weight */
    long pspeed_max ;				/* player speed max */
    // th 6.3.00
    long paccel_max ;				/* player acceleration max */
    //
    long stamina_max ;				/* player stamina max */
    long stamina_inc ;				/* player stamina inc */
    long recover_init ;			/* player recovery init */
    long recover_dthr ;			/* player recovery decriment threshold */
    long recover_min ;				/* player recovery min */
    long recover_dec ;				/* player recovery decriment */
    long effort_init ;				/* player dash effort init */
    long effort_dthr ;				/* player dash effort decriment threshold */
    long effort_min ;				/* player dash effrot min */
    long effort_dec ;				/* player dash effort decriment */
    long effort_ithr ;				/* player dash effort incriment threshold */
    long effort_inc ;				/* player dash effort incriment */
    // pfr 8/14/00: for RC2000 evaluation
    long kick_rand;                                /* noise added directly to kicks */
    short team_actuator_noise;                        /* flag whether to use team specific actuator noise */
    long prand_factor_l;                           /* factor to multiple prand for left team */
    long prand_factor_r;                           /* factor to multiple prand for right team */
    long kick_rand_factor_l;                       /* factor to multiple kick_rand for left team */
    long kick_rand_factor_r;                       /* factor to multiple kick_rand for right team */

    long bsize ;					/* ball size */
    long bdecay ;					/* ball decay */
    long brand ;					/* ball rand */
    long bweight ;					/* ball weight */
    long bspeed_max ;				/* ball speed max */
    // th 6.3.00
    long baccel_max;				/* ball acceleration max */
    //
    long dprate ;					/* dash power rate */
    long kprate ;					/* kick power rate */
    long kmargin ;					/* kickable margin */
    long ctlradius ;				/* control radius */
    long ctlradius_width ;			/* (control radius) - (plyaer size) */
    long maxp ;					/* max power */
    long minp ;					/* min power */
    long maxm ;					/* max moment */
    long minm ;					/* min moment */
    long maxnm ;					/* max neck moment */
    long minnm ;					/* min neck moment */
    long maxn ;					/* max neck angle */
    long minn ;					/* min neck angle */
    long visangle ;				/* visible angle */
    long visdist ;					/* visible distance */
    long windir ;					/* wind direction */
    long winforce ;				/* wind force */
    long winang ;					/* wind angle for rand */
    long winrand ;					/* wind force for force */
    long kickable_area ;			/* kickable_area */
    long catch_area_l ;			/* goalie catchable area length */
    long catch_area_w ;			/* goalie catchable area width */
    long catch_prob ;				/* goalie catchable possibility */
    short   goalie_max_moves;                 /* goalie max moves after a catch */	
    long ckmargin ;				/* corner kick margin */
    long offside_area ;			/* offside active area size */
    short win_no ;					/* wind factor is none */
    short win_random ;				/* wind factor is random */
    short say_cnt_max ;				/* max count of coach SAY */
    short SayCoachMsgSize ;				/* max length of coach SAY */
    short clang_win_size;
    short clang_define_win;
    short clang_meta_win;
    short clang_advice_win;
    short clang_info_win;
    short clang_mess_delay;
    short clang_mess_per_cycle;
    short half_time ;					/* half time */
    short sim_st ;					/* simulator step interval msec */
    short send_st ;					/* udp send step interval msec */
    short recv_st ;					/* udp recv step interval msec */
    short sb_step ;					/* sense_body interval step msec */
    short lcm_st ;		                        /* lcm of all the above steps msec */
    short SayMsgSize ;				/* string size of say message */
    short hear_max ;					/* player hear_capacity_max */
    short hear_inc ;					/* player hear_capacity_inc */
    short hear_decay ;				/* player hear_capacity_decay */
    short cban_cycle ;				/* goalie catch ban cycle */
    short slow_down_factor ;                          /* factor to slow down simulator and send intervals */
    short useoffside ;				/* flag for using off side rule */
    short kickoffoffside ;			/* flag for permit kick off offside */
    long offside_kick_margin ;		/* offside kick margin */
    long audio_dist ;				/* audio cut off distance */
    long dist_qstep ;				/* quantize step of distance */
    long land_qstep ;				/* quantize step of distance for landmark */
    long dir_qstep ;				/* quantize step of direction */
    long dist_qstep_l ;			/* team right quantize step of distance */
    long dist_qstep_r ;			/* team left quantize step of distance */
    long land_qstep_l ;			/* team right quantize step of distance for landmark */
    long land_qstep_r ;			/* team left quantize step of distance for landmark */
    long dir_qstep_l ;				/* team left quantize step of direction */
    long dir_qstep_r ;				/* team right quantize step of direction */
    short CoachMode ;				/* coach mode */
    short CwRMode ;					/* coach with referee mode */
    short old_hear ;					/* old format for hear command (coach) */
    short sv_st ;					/* online coach's look interval step */


  // spare variables which are to be used for paramenter added in the future
  long slowness_on_top_for_left_team;
  long slowness_on_top_for_right_team;
  long ka_length;
  long ka_width;
  long sparelong5;
  long sparelong6;
  long sparelong7;
  long sparelong8;
  long sparelong9;
  long sparelong10;

  short start_goal_l;
  short start_goal_r;
  short fullstate_l;
  short fullstate_r;
  short drop_time;
  short synch_mode;
  short synch_offset;
  short synch_micro_sleep;
  short point_to_ban;
  short point_to_duration;
  
} server_params_t;

typedef struct
{
    long gwidth ;					/* goal width */
    long inertia_moment ;			/* intertia moment for turn */
    long psize ;					/* player size */
    long pdecay ;					/* player decay */
    long prand ;					/* player rand */
    long pweight ;					/* player weight */
    long pspeed_max ;				/* player speed max */
    // th 6.3.00
    long paccel_max ;				/* player acceleration max */
    //
    long stamina_max ;				/* player stamina max */
    long stamina_inc ;				/* player stamina inc */
    long recover_init ;			/* player recovery init */
    long recover_dthr ;			/* player recovery decriment threshold */
    long recover_min ;				/* player recovery min */
    long recover_dec ;				/* player recovery decriment */
    long effort_init ;				/* player dash effort init */
    long effort_dthr ;				/* player dash effort decriment threshold */
    long effort_min ;				/* player dash effrot min */
    long effort_dec ;				/* player dash effort decriment */
    long effort_ithr ;				/* player dash effort incriment threshold */
    long effort_inc ;				/* player dash effort incriment */
    // pfr 8/14/00: for RC2000 evaluation
    long kick_rand;                                /* noise added directly to kicks */
    short team_actuator_noise;                        /* flag whether to use team specific actuator noise */
    long prand_factor_l;                           /* factor to multiple prand for left team */
    long prand_factor_r;                           /* factor to multiple prand for right team */
    long kick_rand_factor_l;                       /* factor to multiple kick_rand for left team */
    long kick_rand_factor_r;                       /* factor to multiple kick_rand for right team */

    long bsize ;					/* ball size */
    long bdecay ;					/* ball decay */
    long brand ;					/* ball rand */
    long bweight ;					/* ball weight */
    long bspeed_max ;				/* ball speed max */
    // th 6.3.00
    long baccel_max;				/* ball acceleration max */
    //
    long dprate ;					/* dash power rate */
    long kprate ;					/* kick power rate */
    long kmargin ;					/* kickable margin */
    long ctlradius ;				/* control radius */
    long ctlradius_width ;			/* (control radius) - (plyaer size) */
    long maxp ;					/* max power */
    long minp ;					/* min power */
    long maxm ;					/* max moment */
    long minm ;					/* min moment */
    long maxnm ;					/* max neck moment */
    long minnm ;					/* min neck moment */
    long maxn ;					/* max neck angle */
    long minn ;					/* min neck angle */
    long visangle ;				/* visible angle */
    long visdist ;					/* visible distance */
    long windir ;					/* wind direction */
    long winforce ;				/* wind force */
    long winang ;					/* wind angle for rand */
    long winrand ;					/* wind force for force */
    long kickable_area ;			/* kickable_area */
    long catch_area_l ;			/* goalie catchable area length */
    long catch_area_w ;			/* goalie catchable area width */
    long catch_prob ;				/* goalie catchable possibility */
    short   goalie_max_moves;                 /* goalie max moves after a catch */	
    long ckmargin ;				/* corner kick margin */
    long offside_area ;			/* offside active area size */
    short win_no ;					/* wind factor is none */
    short win_random ;				/* wind factor is random */
    short say_cnt_max ;				/* max count of coach SAY */
    short SayCoachMsgSize ;				/* max length of coach SAY */
    short clang_win_size;
    short clang_define_win;
    short clang_meta_win;
    short clang_advice_win;
    short clang_info_win;
    short clang_mess_delay;
    short clang_mess_per_cycle;
    short half_time ;					/* half time */
    short sim_st ;					/* simulator step interval msec */
    short send_st ;					/* udp send step interval msec */
    short recv_st ;					/* udp recv step interval msec */
    short sb_step ;					/* sense_body interval step msec */
    short lcm_st ;		                        /* lcm of all the above steps msec */
    short SayMsgSize ;				/* string size of say message */
    short hear_max ;					/* player hear_capacity_max */
    short hear_inc ;					/* player hear_capacity_inc */
    short hear_decay ;				/* player hear_capacity_decay */
    short cban_cycle ;				/* goalie catch ban cycle */
    short slow_down_factor ;                          /* factor to slow down simulator and send intervals */
    short useoffside ;				/* flag for using off side rule */
    short kickoffoffside ;			/* flag for permit kick off offside */
    long offside_kick_margin ;		/* offside kick margin */
    long audio_dist ;				/* audio cut off distance */
    long dist_qstep ;				/* quantize step of distance */
    long land_qstep ;				/* quantize step of distance for landmark */
    long dir_qstep ;				/* quantize step of direction */
    long dist_qstep_l ;			/* team right quantize step of distance */
    long dist_qstep_r ;			/* team left quantize step of distance */
    long land_qstep_l ;			/* team right quantize step of distance for landmark */
    long land_qstep_r ;			/* team left quantize step of distance for landmark */
    long dir_qstep_l ;				/* team left quantize step of direction */
    long dir_qstep_r ;				/* team right quantize step of direction */
    short CoachMode ;				/* coach mode */
    short CwRMode ;					/* coach with referee mode */
    short old_hear ;					/* old format for hear command (coach) */
    short sv_st ;					/* online coach's look interval step */


  // spare variables which are to be used for paramenter added in the future
  long slowness_on_top_for_left_team;
  long slowness_on_top_for_right_team;
  long ka_length;
  long ka_width;
  long sparelong5;
  long sparelong6;
  long sparelong7;
  long sparelong8;
  long sparelong9;
  long sparelong10;

  short start_goal_l;
  short start_goal_r;
  short fullstate_l;
  short fullstate_r;
  short drop_time;
  short synch_mode;
  short synch_offset;
  short synch_micro_sleep;
  short point_to_ban;
  short point_to_duration;

  short pen_before_setup_wait;
  short pen_setup_wait;
  short pen_ready_wait;
  short pen_taken_wait;
  short pen_nr_kicks;
  short pen_max_extra_kicks;
  long pen_dist_x;
  short pen_random_winner;
  long pen_max_goalie_dist_x;
  short pen_allow_mult_kicks;
  
} server_params_t2;

typedef struct {
    short player_types;
    short subs_max;
    short pt_max;
    
    long player_speed_max_delta_min;
    long player_speed_max_delta_max;
    long stamina_inc_max_delta_factor;
    
    long player_decay_delta_min;
    long player_decay_delta_max;
    long inertia_moment_delta_factor;

    long dash_power_rate_delta_min;
    long dash_power_rate_delta_max;
    long player_size_delta_factor;

    long kickable_margin_delta_min;
    long kickable_margin_delta_max;
    long kick_rand_delta_factor;

    long extra_stamina_delta_min;
    long extra_stamina_delta_max;
    long effort_max_delta_factor;
    long effort_min_delta_factor;

    long random_seed;

    long new_dash_power_rate_delta_min;
    long new_dash_power_rate_delta_max;
    long new_stamina_inc_max_delta_factor;  

    long sparelong5;
    long sparelong6;
    long sparelong7;
    long sparelong8;
    long sparelong9;
    long sparelong10;

  short spareshort1;
  short spareshort2;
  short spareshort3;
  short spareshort4;
  short spareshort5;
  short spareshort6;
  short spareshort7;
  short spareshort8;
  short spareshort9;
  short spareshort10;

} player_params_t;


typedef struct {
  short mode;
  union {
      showinfo_t2 		show;
      msginfo_t 		msg;
      player_type_t		ptinfo;
      server_params_t		sparams;
      player_params_t		pparams;
  } body;
} dispinfo_t2 ;



inline
double nltohd(const long &ld)
{
    return (double)((long)ntohl(ld)) / SHOWINFO_SCALE2;
}



#endif

