#!/bin/sh
#
# Copyright 2012 K.K.DNAFORM
# This file is part of idr_paraclu program.
# Idr_paraclu is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by 
# the Free Software Foundation, any later version.
#
# Idr_paraclu is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Foobar. If not, see <http://www.gnu.org/licenses/>.
#
# FILE:
#	install.sh
#
# USAGE:
#	./install.sh
#
# DESCRIPTION:
#	Compiling and installing a set of idr_paraclu programs.
#
# REVISION:
#	2012.12.03	Ohmiya	New scripts
#####################################################################
CURDIR=`pwd`

## ----------------------------------------
## Installing idr_paraclu programs
## ----------------------------------------
BIN_DIRECTORY="/usr/local/bin"
echo -n "Install directory : [/usr/local/bin] "
read ANSWER
if [ "$ANSWER" = "" ]; then
	BIN_DIRECTORY="/usr/local/bin"
else
	BIN_DIRECTORY=$ANSWER
fi
while [ ! -d $BIN_DIRECTORY ]
do
	echo -n "$BIN_DIRECTORY is not a directory. Please input another : [/usr/local/bin] "
	read ANSWER
	if [ "$ANSWER" = "" ]; then
		BIN_DIRECTORY="/usr/local/bin"
	else
		BIN_DIRECTORY=$ANSWER
	fi
done

g++ -O3 -I./ -o automatedClustering automatedClustering.cc
cp automatedClustering ${BIN_DIRECTORY}/.
cp make_ctss3.sh ${BIN_DIRECTORY}/.
g++ -O3 -Wall -W -o paraclu-mod-tpm paraclu.cc
cp paraclu-mod-tpm ${BIN_DIRECTORY}/.
cp paraclu-cut.sh ${BIN_DIRECTORY}/.
cp makeCluster.sh ${BIN_DIRECTORY}/.
cp intersectBED2.sh ${BIN_DIRECTORY}/.
cp convertIDRtoBED2.pl ${BIN_DIRECTORY}/.
cp removeSimilarCluster.pl ${BIN_DIRECTORY}/.

## ----------------------------------------
## Installing modified BEDtools
## ----------------------------------------
tar xvjf BEDTools-Version-2.12.0-OutputOverlap.tar.bz2
cd BEDTools-Version-2.12.0-OutputOverlap
make clean
make
cp ./bin/intersectBed ${BIN_DIRECTORY}/intersectBedOhmiya
cp ./bin/windowBed ${BIN_DIRECTORY}/windowBedOhmiya
cp ./bin/mergeBed ${BIN_DIRECTORY}/mergeBedOhmiya
cd ..

## ----------------------------------------
## Installing modified groupBy
## ----------------------------------------
tar xvjf arq5x-filo-a93f95b-OutputOverlap.tar.bz2
cd arq5x-filo-a93f95b-OutputOverlap
make clean
make
cp ./bin/groupByOrg ${BIN_DIRECTORY}/.
cd ..

exit 0



