#!/usr/bin/ruby
# -*- encoding: utf-8; -*-

##
## RedDog/Utility
##
## http://sourceforge.jp/projects/reddog/
##
## (C)2009 hiratsuka
##

## 2010-02-01: scribble 3 (fixed syslog format)



##
## Usage
##
## Add "require 'rdutil'" to your reddog.rb and call following class methods.
##

## Syslog ##

# Send syslog message content 'Bow! Wow!' to udp/514@localhost
# with tag 'RedDog', facility 'local0' and priority 'info'.
#
# RDUtil::syslog('localhost', 514, 'local0', 'info', 'RedDog', 'Bow! Wow!')

# Almost the same as above, but the message is followed
# by unique id to aboid de-duplication.
# Udp port number is fixed to 514, facility to 'local0', priority to 'info'.
# All exceptions are ignored.
#
# RDUtil::bark('localhost', 'RedDog', 'Bow! Wow!')



# --------
require 'socket'
require 'date'

class RDUtil
  @@uid = rand(1024)
  FACILITIES = {
    'kern'   =>   0, 'user'   =>   8, 'mail'   =>  16, 'daemon' =>  24,
    'auth'   =>  32, 'syslog' =>  40, 'lpr'    =>  48, 'news'   =>  56,
    'uucp'   =>  64, 'cron'   => 120,
    'local0' => 128, 'local1' => 136, 'local2' => 144, 'local3' => 152,
    'local4' => 160, 'local5' => 168, 'local6' => 176, 'local7' => 184
  }
  PRIORITIES = {
    'emerg'   => 0, 'alert'  => 1, 'crit' => 2, 'err'   => 3,
    'warning' => 4, 'notice' => 5, 'info' => 6, 'debug' => 7
  }
  def RDUtil::syslog(host, port, facility, priority, tag, content)
    udp = UDPSocket.open()
    n = udp.send('<' + (FACILITIES[facility] + PRIORITIES[priority]).to_s + '>' + DateTime::now.strftime("%b %d %H:%M:%S ") + tag + ': ' + content, 0, host, port)
    udp.close
    n
  end
  def RDUtil::bark(host, tag, content)
    begin
      syslog(host, 514, 'local0', 'info', tag, content + ' uid=' + sprintf('%04d', @@uid = (@@uid + 1) % 1024))
    rescue => ex
      ex
    end
  end
end
