#!/usr/bin/ruby
# -*- encoding: utf-8; -*-

##
## RedDog
##
## http://sourceforge.jp/projects/reddog/
##
## (C)2009 hiratsuka
##

## 2009-12-24: scribble 2
## 2010-02-01: scribble 3 (rdutil.rb has been updated)



##
## Configuration (write your code here)
##

# name of the target log file
filename = ARGV[0]

# name after rotation (nil: do not watch)
filename_rotated = filename + '.old'

# code block which processes newly added lines
block_newline = proc {|line_str|
  if line_str.match(/error/i)
    print(line_str + "\n")
  end
}

# code block to be run at certain interval
block_heartbeat = proc {
  print "RedDog is watching \"#{filename.split('\\')[-1]}\"\n"
}


# --------
DEBUG = false
interval = 1                    # sec / loop
heartbeat_interval = 10 * 60    # loops
bufsize  = 10                   # KB
file_open_error_limit = 3       # loops
counter = 0
counter_file_open_error = 0
file = nil
file_rotated = nil
file = File.open(filename, 'rb')
ptr = file.stat.size
loop do
  if counter % (heartbeat_interval) == 0
    block_heartbeat.call()
  end
  counter += 1
  if file.closed? == false
    file.close
  end
  if file_rotated != nil && file_rotated.closed? == false
    file_rotated.close
  end
  sleep(interval)
  begin
    file = File.open(filename, 'rb')
  rescue => ex
    counter_file_open_error += 1
    if DEBUG == true || counter_file_open_error == file_open_error_limit
      raise ex
    end
    next
  end
  counter_file_open_error = 0
  filesize = file.stat.size
  if ptr == filesize
    next
  elsif ptr > filesize
    if filename_rotated != nil
      counter_file_rotated_open_error = 0
      begin
        file_rotated = File.open(filename_rotated, 'rb')
      rescue => ex
        if DEBUG == true
          raise ex
        end
        counter_file_rotated_open_error = 1
      end
      if counter_file_rotated_open_error == 0
        filesize_rotated = file_rotated.stat.size
        while ptr < filesize_rotated
          file_rotated.pos = ptr
          buf_rotated = file_rotated.read(bufsize * 1024).gsub(/\r\n?/,"\n").force_encoding('utf-8')
          buf_rotated.split("\n").each(&block_newline)
          ptr = file_rotated.tell
        end
      end
    end
    ptr = 0
  end
  while ptr < filesize
    file.pos = ptr
    buf = file.read(bufsize * 1024).gsub(/\r\n?/,"\n").force_encoding('utf-8')
    ptr = file.tell
    n = 0
    if (m = buf.match(/[^\n]+\z/)) != nil
      n = m.to_s.bytesize
      buf = buf[0..(-1 - n)]
      ptr -= n
    end
    buf.split("\n").each(&block_newline)
    if ptr + n == filesize
      break
    end
  end
end
