/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.server.nexaweb.subscriber;

import java.io.Serializable;

import jp.co.fujitsu.reffi.server.messaging.AbstractMessageReceiver;

import com.nexaweb.messaging.MessageListener;
import com.nexaweb.server.services.ServiceManager;
import com.nexaweb.util.XmlSerializable;
import com.nexaweb.xml.Document;
import com.nexaweb.xml.Element;

/**
 * <p>[概 要]</p>
 * サーバメッセージリスナー基底クラス。
 * <p>[詳 細]</p>
 * <p>[備 考]</p>
 * 
 * @author Project Reffi
 */
abstract public class ProxyMessageSubscriber extends AbstractMessageReceiver {
	/**
	 * <p>[概 要]</p>
	 * メッセージ受信処理
	 * <p>[詳 細]</p>
	 * クライアントから受信したメッセージを処理します。
	 * <p>[備 考]</p>
	 * 本メソッドは処理の共通化を目指すもので、各実装リスナーがonMessageメソッドを実装せず本メソッドにて実装をすることを強く推奨します。
	 * 
	 * @param topic トピック
	 * @param object オブジェクト
	 */
	abstract protected void onSubscribeMessage(String topic, Serializable object);

	/**
	 * <p>[概 要]</p>
	 * メッセージ受信処理
	 * <p>[詳 細]</p>
	 * クライアントから受信したメッセージを処理します。
	 * <p>[備 考]</p>
	 * 本メソッドは処理の共通化を目指すもので、各実装リスナーがonMessageメソッドを実装せず本メソッドにて実装をすることを強く推奨します。
	 * 
	 * @param topic トピック
	 * @param object オブジェクト
	 */
	abstract protected void onSubscribeMessage(String topic, XmlSerializable object);

	/**
	 * <p>[概 要]</p>
	 * メッセージ受信処理
	 * <p>[詳 細]</p>
	 * クライアントから受信したメッセージを処理します。
	 * <p>[備 考]</p>
	 * 本メソッドは処理の共通化を目指すもので、各実装リスナーがonMessageメソッドを実装せず本メソッドにて実装をすることを強く推奨します。
	 * 
	 * @param topic トピック
	 * @param string オブジェクト
	 */
	abstract protected void onSubscribeMessage(String topic, String string);

	@Override
	public final void start(String topic) {
		// サブスクライブ管理オブジェクトと連携が必要
		MessageListener messageListener = new MessageListener() {
			public final void onMessage(String topic, Serializable obj) {
				onSubscribe(topic, obj);
			}

			public final void onMessage(String topic, XmlSerializable obj) {
				onSubscribe(topic, obj);
			}

			public final void onMessage(String topic, byte[] bytes) {
				throw new RuntimeException("not implemented.");
			}

			public final void onMessage(String topic, Document document) {
				throw new RuntimeException("not implemented.");
			}

			public final void onMessage(String topic, Element element) {
				throw new RuntimeException("not implemented.");
			}

			public final void onMessage(String topic, String string) {
				onSubscribe(topic, string);
			}
		};
		ServiceManager.getMessagingService().subscribe(topic, messageListener);
	}
	
	/**
	 * <p>[概 要]</p>
	 * メッセージ受信共通処理
	 * <p>[詳 細]</p>
	 * クライアントから受信したメッセージの共通処理を実行します。
	 * <p>[備 考]</p>
	 * 
	 * @param topic トピック
	 * @param object 受信メッセージ
	 */
	public final void onSubscribe(String topic, Serializable object) {
		try {
			handleInitialize();
			onSubscribeMessage(topic, object);
		} catch (Exception e) {
			trap(e);
		} finally {
			handleFinalize();
		}
	}

	/**
	 * <p>[概 要]</p>
	 * メッセージ受信共通処理
	 * <p>[詳 細]</p>
	 * クライアントから受信したメッセージの共通処理を実行します。
	 * <p>[備 考]</p>
	 * 
	 * @param topic トピック
	 * @param object 受信メッセージ
	 */
	public final void onSubscribe(String topic, XmlSerializable object) {
		try {
			handleInitialize();
			onSubscribeMessage(topic, object);
		} catch (Exception e) {
			trap(e);
		} finally {
			handleFinalize();
		}
	}

	/**
	 * <p>[概 要]</p>
	 * メッセージ受信共通処理
	 * <p>[詳 細]</p>
	 * クライアントから受信したメッセージの共通処理を実行します。
	 * <p>[備 考]</p>
	 * 
	 * @param topic トピック
	 * @param string 受信メッセージ
	 */
	public final void onSubscribe(String topic, String string) {
		try {
			handleInitialize();
			onSubscribeMessage(topic, string);
		} catch (Exception e) {
			trap(e);
		} finally {
			handleFinalize();
		}
	}
}
