/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.common.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

/**
 * <p>[概 要]</p>
 * リソースファイルユーティリティクラス
 * <p>[詳 細]</p>
 * <p>[備 考]</p>
 * 
 * @author Project Reffi
 */
public enum ResourceUtil {
	/** インスタンス */
	instance;
	/** 取得リソース設定、プロパティファイルのみを対象 */
	private static final ResourceBundle.Control RESOURCE_CONTROL = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
	/** リソースマップ */
	private Map<String, Properties> _resourceMap = new Hashtable<String, Properties>();
	
	/**
	 * <p>[概 要]</p>
	 * プロパティファイル読み込み
	 * <p>[詳 細]</p>
	 * 指定されたパスのプロパティファイルを読み込みます。
	 * <p>[備 考]</p>
	 * 
	 * @param resourcePath　リソースパス
	 * @return プロパティ
	 */
	public Properties asProperties(String resourcePath) {
		if (this._resourceMap.containsKey(resourcePath)) {
			return this._resourceMap.get(resourcePath);
		}
		ResourceBundle bundle = ResourceBundle.getBundle(resourcePath, RESOURCE_CONTROL);
		Properties messages = new Properties();
		Enumeration<String> keys = bundle.getKeys();
		while (keys.hasMoreElements()) {
			String key = keys.nextElement();
			String value = bundle.getString(key);
			messages.put(key, value);
		}
		this._resourceMap.put(resourcePath, messages);
		return messages;
	}
}
