/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.server.util;

import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jp.co.fujitsu.reffi.common.exception.CoreLogicException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.MutableConfiguration;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.svg.PDFTranscoder;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public enum FopUtil {
    instance;


    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void convertFO2PDF(File fo, File pdf, String configPath) throws CoreLogicException {
        FileOutputStream out = null;
        try {
            FopFactory fopFactory = FopFactory.newInstance();
            fopFactory.setUserConfig(this.convertConfiguration(configPath));
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            out = new FileOutputStream(pdf);
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StreamSource src = new StreamSource(fo);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (FileNotFoundException e) {
            try {
                throw new CoreLogicException("EFC9002", (Throwable)e);
                catch (Exception e2) {
                    throw new CoreLogicException("EFC9001", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void convertXML2FO(File xml, File xslt, File fo) throws CoreLogicException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fo);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(xslt));
            StreamSource src = new StreamSource(xml);
            StreamResult res = new StreamResult(out);
            transformer.transform(src, res);
        }
        catch (FileNotFoundException e) {
            try {
                throw new CoreLogicException("EFC9002", (Throwable)e);
                catch (Exception e2) {
                    throw new CoreLogicException("EFC9001", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private Configuration convertConfiguration(String configPath) throws ConfigurationException, SAXException, IOException {
        File configFile = new File(configPath);
        String configRootPath = configFile.getParentFile().toURI().toString();
        DefaultConfiguration userConfig = new DefaultConfiguration(new DefaultConfigurationBuilder().buildFromFile(configFile));
        MutableConfiguration[] renderers = userConfig.getMutableChild("renderers").getMutableChildren();
        for (int r = 0; r < renderers.length; ++r) {
            MutableConfiguration[] fonts = renderers[r].getMutableChild("fonts").getMutableChildren("font");
            for (int i = 0; i < fonts.length; ++i) {
                String metrics = configRootPath + "/" + fonts[i].getAttribute("metrics-url");
                fonts[i].setAttribute("metrics-url", metrics);
                String embed = configRootPath + "/" + fonts[i].getAttribute("embed-url");
                fonts[i].setAttribute("embed-url", embed);
            }
        }
        return userConfig;
    }

    public void convertXML2PDF(File xml, File xslt, File pdf, String configPath) throws CoreLogicException {
        FileOutputStream out = null;
        try {
            FopFactory fopFactory = FopFactory.newInstance();
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            fopFactory.setUserConfig(this.convertConfiguration(configPath));
            out = new FileOutputStream(pdf);
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(xslt));
            StreamSource src = new StreamSource(xml);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (Exception e) {
            try {
                throw new CoreLogicException("EFC9001", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public void convertObj2XML(Object obj, File xml) throws CoreLogicException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(xml);
            XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(out));
            encoder.writeObject(obj);
            encoder.close();
        }
        catch (IOException e) {
            try {
                throw new CoreLogicException("EFC9001", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void convertObj2PDF(Object obj, File xslt, File pdf, String configPath) throws CoreLogicException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        FileOutputStream out = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(byteArrayOutputStream));
            encoder.writeObject(obj);
            encoder.close();
            FopFactory fopFactory = FopFactory.newInstance();
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            fopFactory.setUserConfig(this.convertConfiguration(configPath));
            out = new FileOutputStream(pdf);
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(xslt));
            StreamSource src = new StreamSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (FileNotFoundException e) {
            try {
                throw new CoreLogicException("EFC9002", (Throwable)e);
                catch (Exception e2) {
                    throw new CoreLogicException("EFC9001", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        IOUtils.closeQuietly((OutputStream)out);
    }

    public void convertDOM2PDF(Document foDom, File pdf, String configPath) throws CoreLogicException {
        FileOutputStream out = null;
        try {
            FopFactory fopFactory = FopFactory.newInstance();
            fopFactory.setUserConfig(this.convertConfiguration(configPath));
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            out = new FileOutputStream(pdf);
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            DOMSource src = new DOMSource(foDom);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (Exception e) {
            try {
                throw new CoreLogicException("EFC9001", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void convertSVG2PDF(File svg, File pdf) throws CoreLogicException {
        FileInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new FileInputStream(svg);
            out = new BufferedOutputStream(new FileOutputStream(pdf));
            TranscoderInput input = new TranscoderInput((InputStream)in);
            PDFTranscoder transcoder = new PDFTranscoder();
            TranscoderOutput output = new TranscoderOutput((OutputStream)out);
            transcoder.transcode(input, output);
        }
        catch (FileNotFoundException e) {
            try {
                throw new CoreLogicException("EFC9002", (Throwable)e);
                catch (Exception e2) {
                    throw new CoreLogicException("EFC9001", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }
}

