/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.controller;

import java.awt.Component;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import jp.co.fujitsu.reffi.client.swing.action.AbstractAction;
import jp.co.fujitsu.reffi.client.swing.controller.AbstractController;
import jp.co.fujitsu.reffi.client.swing.util.ComponentSearchUtil;

public class EventBinder {
    private Map<String, Map<Class<? extends EventListener>, Map<String, Class<? extends AbstractAction>>>> bindInfo;
    private AbstractController controller;

    public Map<String, Map<Class<? extends EventListener>, Map<String, Class<? extends AbstractAction>>>> getBindInfo() {
        return this.bindInfo;
    }

    public void setBindInfo(Map<String, Map<Class<? extends EventListener>, Map<String, Class<? extends AbstractAction>>>> bindInfo) {
        this.bindInfo = bindInfo;
    }

    public AbstractController getController() {
        return this.controller;
    }

    public void setController(AbstractController controller) {
        this.controller = controller;
    }

    public EventBinder(AbstractController controller) {
        this.controller = controller;
        this.bindInfo = new HashMap<String, Map<Class<? extends EventListener>, Map<String, Class<? extends AbstractAction>>>>();
    }

    public void addEventBinding(String componentName, String listenerFqcn, String eventType, String actionFqcn) throws Exception {
        Class<?> listenerType = Class.forName(listenerFqcn);
        this.addEventBinding(componentName, listenerType, eventType, actionFqcn);
    }

    public void addEventBinding(String componentName, Class<? extends EventListener> listenerType, String eventType, String actionFqcn) throws Exception {
        Class<?> actionClass = Class.forName(actionFqcn);
        this.addEventBinding(componentName, listenerType, eventType, actionClass);
    }

    public void addEventBinding(String componentName, Class<? extends EventListener> listenerType, String eventType, Class<? extends AbstractAction> actionClass) {
        Map<Object, Object> listenerTypeMap = null;
        if (this.bindInfo.containsKey(componentName)) {
            listenerTypeMap = this.bindInfo.get(componentName);
        } else {
            listenerTypeMap = new HashMap();
            this.bindInfo.put(componentName, listenerTypeMap);
        }
        Map<String, Class<? extends AbstractAction>> eventTypeMap = null;
        if (listenerTypeMap.containsKey(listenerType)) {
            eventTypeMap = (Map)listenerTypeMap.get(listenerType);
        } else {
            eventTypeMap = new HashMap();
            listenerTypeMap.put(listenerType, eventTypeMap);
        }
        eventTypeMap.put(eventType, actionClass);
    }

    public Map<Class<? extends EventListener>, Map<String, Class<? extends AbstractAction>>> getListenerTypeMap(String componentName) {
        return this.bindInfo.get(componentName);
    }

    public List<Class<? extends EventListener>> getListenerTypes(String componentName) {
        ArrayList<Class<? extends EventListener>> ret = new ArrayList<Class<? extends EventListener>>();
        Map<Class<? extends EventListener>, Map<String, Class<? extends AbstractAction>>> listenerTypeMap = this.bindInfo.get(componentName);
        if (listenerTypeMap != null) {
            Set<Class<? extends EventListener>> keys = listenerTypeMap.keySet();
            for (Class<? extends EventListener> listener : keys) {
                ret.add(listener);
            }
        }
        return ret;
    }

    public List<String> getEventTypes(String componentName, Class<? extends EventListener> listenerType) {
        Map<String, Class<? extends AbstractAction>> eventTypeMap;
        ArrayList<String> ret = new ArrayList<String>();
        Map<Class<? extends EventListener>, Map<String, Class<? extends AbstractAction>>> listenerTypeMap = this.bindInfo.get(componentName);
        if (listenerTypeMap != null && (eventTypeMap = listenerTypeMap.get(listenerType)) != null) {
            Set<String> keys = eventTypeMap.keySet();
            for (String eventType : keys) {
                ret.add(eventType);
            }
        }
        return ret;
    }

    public Class<? extends AbstractAction> getActionClass(String componentName, Class<? extends EventListener> listenerType, String eventType) {
        Map<String, Class<? extends AbstractAction>> eventTypeMap;
        Class<? extends AbstractAction> ret = null;
        Map<Class<? extends EventListener>, Map<String, Class<? extends AbstractAction>>> listenerTypeMap = this.bindInfo.get(componentName);
        if (listenerTypeMap != null && (eventTypeMap = listenerTypeMap.get(listenerType)) != null) {
            ret = eventTypeMap.get(eventType);
        }
        return ret;
    }

    public boolean isEventBinding(String componentName) {
        return this.bindInfo.containsKey(componentName);
    }

    public void addEventBindingImmediately(String componentName, Class<? extends EventListener> listenerType, String eventType, Class<? extends AbstractAction> actionClass) {
        Component c = ComponentSearchUtil.searchComponentByNameFromAllWindow(componentName);
        if (c == null) {
            return;
        }
        this.addEventBindingImmediately(c, listenerType, eventType, actionClass);
    }

    public void addEventBindingImmediately(Component component, Class<? extends EventListener> listenerType, String eventType, Class<? extends AbstractAction> actionClass) {
        this.addEventBinding(component.getName(), listenerType, eventType, actionClass);
        ArrayList<String> eventTypes = new ArrayList<String>();
        eventTypes.add(eventType);
        this.controller.addListener(component, listenerType, eventTypes);
    }

    public void removeEventBinding(String componentName) {
        this.bindInfo.remove(componentName);
    }

    public void removeEventBinding(String componentName, Class<? extends EventListener> listenerType) {
        Map<Class<? extends EventListener>, Map<String, Class<? extends AbstractAction>>> listenerTypeMap = this.bindInfo.get(componentName);
        listenerTypeMap.remove(listenerType);
    }

    public void removeEventBinding(String componentName, Class<? extends EventListener> listenerType, String eventType) {
        Map<Class<? extends EventListener>, Map<String, Class<? extends AbstractAction>>> listenerTypeMap = this.bindInfo.get(componentName);
        Map<String, Class<? extends AbstractAction>> eventTypeMap = listenerTypeMap.get(listenerType);
        eventTypeMap.remove(eventType);
    }

    public void removeEventBindingImmediately(Component component, Class listenerType, String eventType, EventListener listener) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String componentName = component.getName();
        this.removeEventBinding(componentName, listenerType, eventType);
        Field listenerListField = JComponent.class.getDeclaredField("listenerList");
        listenerListField.setAccessible(true);
        EventListenerList listenerList = (EventListenerList)listenerListField.get(component);
        listenerList.remove(listenerType, listener);
    }
}

