/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.model;

import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;
import jp.co.fujitsu.reffi.client.swing.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.swing.manager.JMSSubscribeCoreManager;
import jp.co.fujitsu.reffi.client.swing.model.BaseModel;

public class JMSSubscribeCore
extends BaseModel
implements MessageListener {
    private String identifier;
    private boolean unsubscribe;
    private Hashtable<String, String> environment;
    private TopicConnection topicConnection;
    private TopicSession topicSession;
    private Topic topic;
    private String topicName;
    private TopicSubscriber subscriber;
    private String connectionFactoryName = "ConnectionFactory";
    private String clientId;
    private boolean durable;
    private String durableSubscriberName;
    private boolean fireSuccessEventImmediately;

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public boolean isUnsubscribe() {
        return this.unsubscribe;
    }

    public void setUnsubscribe(boolean unsubscribe) {
        this.unsubscribe = unsubscribe;
    }

    public Hashtable<String, String> getEnvironment() {
        if (this.environment == null) {
            this.environment = this.getController().getClientConfig().getDefaultJmsEnvironment();
        }
        return this.environment;
    }

    public void setEnvironment(Hashtable<String, String> environment) {
        this.environment = environment;
    }

    public TopicConnection getTopicConnection() {
        return this.topicConnection;
    }

    public void setTopicConnection(TopicConnection topicConnection) {
        this.topicConnection = topicConnection;
    }

    public TopicSession getTopicSession() {
        return this.topicSession;
    }

    public void setTopicSession(TopicSession topicSession) {
        this.topicSession = topicSession;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public TopicSubscriber getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(TopicSubscriber subscriber) {
        this.subscriber = subscriber;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public String getDurableSubscriberName() {
        return this.durableSubscriberName;
    }

    public void setDurableSubscriberName(String durableSubscriberName) {
        this.durableSubscriberName = durableSubscriberName;
    }

    public boolean isFireSuccessEventImmediately() {
        return this.fireSuccessEventImmediately;
    }

    public void setFireSuccessEventImmediately(boolean fireSuccessEventImmediately) {
        this.fireSuccessEventImmediately = fireSuccessEventImmediately;
    }

    @Override
    protected void mainproc() throws NamingException, JMSException {
        if (!this.isUnsubscribe()) {
            JMSSubscribeCoreManager.getInstance().subscribe(this.getTopicName(), this);
            if (this.isFireSuccessEventImmediately()) {
                ModelProcessEvent evt = new ModelProcessEvent(this);
                evt.setResult(null);
                this.fireModelSuccess(evt);
            }
        } else {
            JMSSubscribeCoreManager.getInstance().unsubscribe(this.getTopicName(), this.getIdentifier());
            ModelProcessEvent evt = new ModelProcessEvent(this);
            evt.setResult(null);
            this.fireModelSuccess(evt);
            this.fireModelFinished(new ModelProcessEvent(this));
        }
    }

    public final void onMessage(Message msg) {
        this.setResult(msg);
        this.postSubscribe(msg);
        ModelProcessEvent successEvent = new ModelProcessEvent(this);
        successEvent.setResult(msg);
        this.fireModelSuccess(successEvent);
    }

    protected void postSubscribe(Message msg) {
    }

    public final void onUnsubscribe() {
        this.postUnsubscribe();
        ModelProcessEvent finishedEvent = new ModelProcessEvent(this);
        this.fireModelFinished(finishedEvent);
    }

    protected void postUnsubscribe() {
    }
}

