/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.server.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractModel
implements Serializable {
    private static final long serialVersionUID = 4900328223908816747L;
    private Map<Object, Object> _request = new HashMap<Object, Object>();
    private Object _response;

    public Map<Object, Object> getRequest() {
        return this._request;
    }

    public void setRequest(Map<Object, Object> request) {
        this._request = request;
    }

    public Object getRequestParameter(Object key) {
        if (this._request.containsKey(key)) {
            return this._request.get(key);
        }
        return null;
    }

    public <T> T getRequestParameter(Object key, Class<T> clazz) {
        try {
            Object ret = this.getRequestParameter(key);
            return clazz.cast(ret);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Object getResponse() {
        return this._response;
    }

    public void setResponse(Object response) {
        this._response = response;
    }

    public void run() throws Exception {
        try {
            if (!this.preProcess()) {
                return;
            }
            this.mainProcess();
            this.postProcess();
        }
        catch (Exception e) {
            throw this.trap(e);
        }
        finally {
            this.finalProcess();
        }
    }

    protected boolean preProcess() throws Exception {
        return true;
    }

    protected void mainProcess() throws Exception {
    }

    protected void postProcess() throws Exception {
    }

    protected void finalProcess() {
    }

    protected Exception trap(Exception e) {
        return e;
    }
}

