/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.nexaweb.logconsumer;

import com.nexaweb.util.LogEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import jp.co.fujitsu.reffi.client.nexaweb.controller.ClientConfig;
import jp.co.fujitsu.reffi.client.nexaweb.logconsumer.LogConsumerAdapter;

public class FileLogConsumer
extends LogConsumerAdapter {
    private String directoryPath;
    private int maxFileExist;
    private long maxFileSize;
    private int maxBackupIndex;
    private String prefix;
    private String suffix;
    private String encoding = "UTF-8";
    private Writer writer;

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public int getMaxFileExist() {
        return this.maxFileExist;
    }

    public void setMaxFileExist(int maxFileExist) {
        this.maxFileExist = maxFileExist;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void setMaxBackupIndex(int maxBackupIndex) {
        this.maxBackupIndex = maxBackupIndex;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void init(Object obj) {
        super.init(obj);
        if (obj instanceof ClientConfig) {
            ClientConfig config = (ClientConfig)obj;
            String directory = config.getLogFileDir();
            String directoryPath = System.getProperty("user.home") + File.separator + directory;
            if (!new File(directoryPath).isDirectory()) {
                new File(directoryPath).mkdirs();
            }
            this.setDirectoryPath(directoryPath);
            String encoding = config.getLogFileCharset();
            this.setEncoding(encoding);
            int maxFileExist = config.getLogFileMaxExist();
            this.setMaxFileExist(maxFileExist);
            long maxFileSize = config.getLogFileMaxSize();
            this.setMaxFileSize(maxFileSize);
            int maxBackupIndex = config.getLogFileMaxBackupIndex();
            this.setMaxBackupIndex(maxBackupIndex);
            String prefix = config.getLogFileNamePrefix();
            this.setPrefix(prefix);
            String suffix = config.getLogFileNameSuffix();
            this.setSuffix(suffix);
        }
    }

    public void log(LogEvent evt) {
        try {
            OutputStreamWriter writer;
            File logFile = new File(this.logFilePath());
            if (logFile.length() > this.getMaxFileSize()) {
                this.rotateBySize(logFile);
            }
            if (!logFile.exists()) {
                if (this.getWriter() != null) {
                    this.closeWriter();
                }
                logFile.createNewFile();
                this.rotateByMaxExist();
                writer = this.createWriter(logFile);
                this.setWriter(writer);
            } else if (this.getWriter() == null) {
                writer = this.createWriter(logFile);
                this.setWriter(writer);
            }
            String log = this.createLogString(evt) + System.getProperty("line.separator");
            this.getWriter().write(log, 0, log.length());
            this.getWriter().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void rotateBySize(File logFile) throws IOException {
        int maxBackupIndex = this.getMaxBackupIndex();
        if (maxBackupIndex > 0) {
            File target;
            this.closeWriter();
            File file = new File(this.logFilePath() + '.' + maxBackupIndex);
            if (file.exists()) {
                file.delete();
            }
            for (int i = maxBackupIndex - 1; i >= 1; --i) {
                file = new File(this.logFilePath() + "." + i);
                if (!file.exists()) continue;
                target = new File(this.logFilePath() + '.' + (i + 1));
                file.renameTo(target);
            }
            target = new File(this.logFilePath() + "." + 1);
            file = new File(this.logFilePath());
            file.renameTo(target);
        }
    }

    protected void rotateByMaxExist() {
        File logDir = new File(this.getDirectoryPath());
        File[] logFiles = logDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                boolean ret = false;
                if (filename.startsWith(FileLogConsumer.this.getPrefix())) {
                    ret = true;
                }
                return ret;
            }
        });
        int over = logFiles.length - this.getMaxFileExist();
        if (over > 0) {
            Arrays.sort(logFiles, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    Long l1 = new Long(o1.lastModified());
                    Long l2 = new Long(o2.lastModified());
                    return l1.compareTo(l2);
                }
            });
            for (int i = 0; i < over; ++i) {
                logFiles[i].delete();
            }
        }
    }

    protected OutputStreamWriter createWriter(File logFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(logFile, true);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, this.getEncoding());
        return osw;
    }

    protected void closeWriter() throws IOException {
        if (this.getWriter() == null) {
            return;
        }
        this.getWriter().close();
        this.setWriter(null);
    }

    protected String logFileName() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String yyyymmdd = sdf.format(date);
        String filename = this.getPrefix() + yyyymmdd + this.getSuffix();
        return filename;
    }

    protected String logFilePath() {
        return this.getDirectoryPath() + File.separator + this.logFileName();
    }
}

