/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.co.fujitsu.reffi.client.swing.controller.ClientConfig;
import jp.co.fujitsu.reffi.client.swing.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.swing.model.AbstractHTTPCore;

public class HTTPRequestCore
extends AbstractHTTPCore {
    public static final String HTTP_URL_PREFIX = "http.url.prefix";
    public static final String OBJECT = "OBJECT";
    public static final String BINARY = "BINARY";
    public static final String PLAIN = "PLAIN";
    private String requestUrl;
    private String requestMethod = "POST";
    private String responseType = "OBJECT";
    private Map<String, String> urlParameters;
    private int responseCode;

    public String getRequestUrl() {
        if (!this.requestUrl.startsWith("http") && !this.requestUrl.startsWith("https")) {
            ClientConfig config = this.getController().getClientConfig();
            String prefix = config.getDefaultHttpEnvironment().get(HTTP_URL_PREFIX);
            return prefix + this.requestUrl;
        }
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public Map<String, String> getUrlParameters() {
        return this.urlParameters;
    }

    public void setUrlParameters(Map<String, String> urlParameters) {
        this.urlParameters = urlParameters;
    }

    public void addUrlParamteter(String key, String value) {
        this.urlParameters.put(key, value);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public HTTPRequestCore() {
        this.setUrlParameters(new HashMap<String, String>());
    }

    @Override
    protected void mainproc() throws IOException {
        URLConnection httpConn = this.createConnection();
        ((HttpURLConnection)httpConn).setRequestMethod(this.getRequestMethod());
        if (this.isSendCookie()) {
            String cookies = this.createCookieString();
            httpConn.setRequestProperty("Cookie", cookies.toString());
        }
        Object result = null;
        if (OBJECT.equals(this.getResponseType())) {
            this.createPostParameter(httpConn);
            result = this.createObjectResult(httpConn);
        } else if (!BINARY.equals(this.getResponseType()) && PLAIN.equals(this.getResponseType())) {
            result = this.createPlainResult(httpConn);
        }
        this.setResult(result);
    }

    protected URLConnection createConnection() throws IOException {
        URLConnection ret = null;
        URL url = new URL(this.getRequestUrl());
        ret = url.openConnection();
        return ret;
    }

    protected void createPostParameter(URLConnection httpConn) throws IOException {
        httpConn.setDoOutput(true);
        PrintWriter writer = null;
        Object reader = null;
        writer = new PrintWriter(httpConn.getOutputStream());
        Map<String, String> urlParameters = this.getUrlParameters();
        Set<String> keys = urlParameters.keySet();
        Iterator<String> it = keys.iterator();
        StringBuilder sb = new StringBuilder("");
        while (it.hasNext()) {
            String key = it.next();
            String value = urlParameters.get(key);
            value = URLEncoder.encode(value, "UTF-8");
            sb.append(key + "=" + value + "&");
        }
        writer.print(sb.toString());
        writer.close();
    }

    protected Object createObjectResult(URLConnection httpConn) throws IOException {
        ObjectInputStream ois = null;
        ois = new ObjectInputStream(httpConn.getInputStream());
        Object result = null;
        try {
            result = ois.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected String createPlainResult(URLConnection httpConn) throws IOException {
        InputStream is = httpConn.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder("");
        String line = null;
        while ((line = br.readLine()) != null) {
            sb = sb.append(line);
        }
        return sb.toString();
    }

    @Override
    protected void postproc() throws Exception {
        ModelProcessEvent successEvent = new ModelProcessEvent(this);
        successEvent.setResult(this.getResult());
        this.fireModelSuccess(successEvent);
        this.fireModelFinished(new ModelProcessEvent(this));
    }
}

