/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.server.messaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.fujitsu.reffi.server.messaging.AbstractMessageReceiver;

public enum ReceiverManager {
    instance;

    private Map<String, List<AbstractMessageReceiver>> _receiverMap = new HashMap<String, List<AbstractMessageReceiver>>();

    public synchronized List<AbstractMessageReceiver> getReceivers(String name) {
        if (this._receiverMap.containsKey(name)) {
            return this._receiverMap.get(name);
        }
        return null;
    }

    public synchronized void addReceiver(String topic, AbstractMessageReceiver messageReceiver) {
        List<AbstractMessageReceiver> messageReceivers = this.getReceivers(topic);
        if (messageReceivers == null) {
            messageReceivers = new ArrayList<AbstractMessageReceiver>();
        }
        if (!messageReceivers.contains(messageReceiver)) {
            messageReceivers.add(messageReceiver);
            messageReceiver.start(topic);
        }
        this._receiverMap.put(topic, messageReceivers);
    }
}

