/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.server.web.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.commons.lang.StringUtils;

/**
 * <p>[概 要]</p>
 * 文字コードフィルタークラス。
 * <p>[詳 細]</p>
 * <p>[備 考]</p>
 *
 * @author Project Reffi
 */
public class EncodingFilter implements Filter {
	/** リクエスト文字コード設定パラメータ名 */
	public static final String PARAM_REQUEST_ENCODING = "requestEncoding";
	/** レスポンス文字コード設定パラメータ名 */
	public static final String PARAM_RESPONSE_ENCODING = "responseEncoding";
	/** リクエスト文字コード */
	private String _requestEncoding;
	/** レスポンス文字コード */
	private String _responseEncoding;

	@Override
	public void destroy() {
		this._requestEncoding = null;
		this._responseEncoding = null;
	}

	@Override
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
		if (StringUtils.isNotEmpty(this._requestEncoding)) {
			request.setCharacterEncoding(this._requestEncoding);
		}
		filterChain.doFilter(request, response);
		if (StringUtils.isNotEmpty(this._responseEncoding)) {
			response.setCharacterEncoding(this._responseEncoding);
		}
	}

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
		String requestEncoding = filterConfig.getInitParameter(PARAM_REQUEST_ENCODING);
		if (StringUtils.isNotEmpty(requestEncoding)) {
			this._requestEncoding = requestEncoding;
		}
		String responseEncoding = filterConfig.getInitParameter(PARAM_RESPONSE_ENCODING);
		if (StringUtils.isNotEmpty(responseEncoding)) {
			this._responseEncoding = responseEncoding;
		}
	}
}
