unit APIWindow;

interface

uses
  Windows,
  Messages,
  APIUtils;

//--------------- TMinForm -------------------------------
type
TMinForm = class(TObject)
private
  FHandle: HWND;
  FParent: HWND;
  FClassName:string;
  FExStyle: DWORD;
  FStyle: DWORD;
  FCaption: string;
  FPosX: integer;
  FPosY: integer;
  FColor: COLORREF;
  FWidth:integer;
  FHeight:integer;
  FClientWidth:integer;
  FClientHeight:integer;
  FIcon: HICON;

  FOnInitDialog: TNotifyMessage;
  FOnCommand: TNotifyMessage;
  FOnDestroy: TNotifyMessage;
  FOnCreate: TNotifyMessage;

  procedure SetCaption(value: string);
  procedure SetPosX(value: integer);
  procedure SetPosY(value: integer);
  function GetWidth: integer;
  procedure SetWidth(value: integer);
  function GetHeight: integer;
  procedure SetHeight(value: integer);
  function GetClientWidth: integer;
  procedure SetClientWidth(value: integer);
  function GetClientHeight: integer;
  procedure SetClientHeight(value: integer);
  procedure SetColor(value: COLORREF);
  procedure SetIcon(value:HICON);
  function GetVisible: Boolean;
  procedure SetVisible(value: Boolean);
protected
  procedure APIClassParams(var WC:TWndClass); virtual;
  procedure InitWidthHeight;
  procedure Paint(var Message: TWmPaint); message WM_PAINT;
public
  constructor Create(hParent:HWND);virtual;
  destructor Destroy; override;
  procedure Close;
  procedure Center;
  procedure DoCreate;virtual;

  property Parent: HWND read FParent;
  property Handle: HWND read FHandle write FHandle;
  property Style: DWORD read FStyle write FStyle;
  property Caption: string read FCaption write SetCaption;
  property PosX:integer read FPosX write SetPosX;
  property PosY:integer read FPosY write SetPosY;
  property Width: integer read GetWidth write SetWidth;
  property Height: integer read GetHeight write SetHeight;
  property ClientWidth: integer read GetClientWidth write SetClientWidth;
  property ClientHeight: integer read GetClientHeight write SetClientHeight;
  property Color: COLORREF read FColor write SetColor;
  property Icon: HICON read FIcon write SetIcon;

  property OnInitDialog: TNotifyMessage
                         read FOnInitDialog write FOnInitDialog;
  property OnCommand: TNotifyMessage
                         read FOnCommand write FOnCommand;
  property OnDestroy: TNotifyMessage
                         read FOnDestroy write FOnDestroy;
  property OnCreate :TNotifyMessage
                         read FOnCreate write FOnCreate;
  property Visible: Boolean
                         read GetVisible write SetVisible;
end;

implementation

{---------------------------------------------------------------------
             Custom Window Procedure
----------------------------------------------------------------------}
function CustomWndProc(hWindow: HWND; Msg: UINT; WParam: WPARAM;
                            LParam: LPARAM): LRESULT; stdcall;
var
  WPMsg: TMessage;
  Wnd: TMinForm;
  pCS: PCreateStruct;
begin

   Result := 0;

   if Msg = WM_NCCREATE then begin
     pCS := Pointer(LParam);
     SetProp(hWindow,'NSM2',integer(pCS^.lpCreateParams));
     TMinForm(pCS^.lpCreateParams).FHandle := hWindow;
   end;

   WPMsg.Msg := Msg;
   WPMsg.WParam := WParam;
   WPMsg.LParam := LParam;
   WPMsg.Result := 0;

   Wnd := TMinForm(GetProp(hWindow,'NSM2'));

   case Msg of

{------------------  WM_DESTROY  --------------------------------}

     WM_DESTROY: begin
       if Assigned(Wnd) then begin
         Wnd.Dispatch(WPMsg);
         Wnd.Free;
       end;
     end;

{---------  ̃bZ[WIuWFNg Dispatch  ----}
   else begin
       if Assigned(Wnd) then Wnd.Dispatch(WPMsg);
       if WPMsg.Result = 0 then
         Result := DefWindowProc( hWindow, Msg, wParam, lParam )
       else Result := WPMsg.Result;
     end;

   end; // case

end;

//--------------- TMinForm -------------------------------
constructor TMinForm.Create(hParent:HWND);
begin
  FHandle := 0;
  FParent := hParent;
  FColor := clrBtnFace;
  FExStyle := WS_EX_TOOLWINDOW;
  FStyle := WS_POPUP or WS_VISIBLE or WS_CAPTION or WS_SYSMENU or WS_DLGFRAME;
  FClassName := Self.ClassName;
  FCaption := 'Regnessem';
  DoCreate;
end;

destructor TMinForm.Destroy;
begin
  RemoveProp(FHandle,'NSM2');
  inherited Destroy;
end;

procedure TMinForm.APIClassParams(var WC:TWndClass);
begin
  WC.lpszClassName   := PChar(FClassName);
  WC.lpfnWndProc     := @CustomWndProc;
  WC.style           := CS_VREDRAW or CS_HREDRAW;
  WC.hInstance       := hInstance;
  WC.hIcon           := 0;
  WC.hCursor         := LoadCursor(0,IDC_ARROW);
  WC.hbrBackground   := ( COLOR_BTNFACE+1 );
  WC.lpszMenuName    := nil;
  WC.cbClsExtra      := 0;
  WC.cbWndExtra      := 0;
end;

procedure TMinForm.DoCreate;
var
  WC: TWndClass;
begin
  APIClassParams(WC);
  RegisterClass(WC);

  FHandle := CreateWindowEx(FExStyle,
                            PChar(FClassName),
                            PChar(FCaption),
                            FStyle,
                            CW_USEDEFAULT,
                            0,
                            CW_USEDEFAULT,
                            0,
                            FParent,
                            0,
                            hInstance,
                            self);
  ShowWindow(FHandle,SW_HIDE);
  UpDateWindow(FHandle);
end;

procedure TMinForm.SetCaption(value: string);
begin
  FCaption := value;
  if FHandle <> 0 then
    SetWindowText(FHandle,PChar(value));
end;

procedure TMinForm.SetPosX(value: integer);
var
  pt: TPoint;
begin
  FPosX := value;
  if FHandle <> 0 then begin
    pt.x := value;
    pt.y := FPosY;
    ClientToScreen(FParent,pt);
    ChangeWindowPos(FHandle,pt.x,pt.y);
  end;
end;

procedure TMinForm.SetPosY(value: integer);
var
  pt: TPoint;
begin
  FPosY := value;
  if FHandle <> 0 then begin
    pt.x := FPosX;
    pt.y := value;
    ClientToScreen(FParent,pt);
    ChangeWindowPos(FHandle,pt.x,pt.y);
  end;
end;

function TMinForm.GetWidth: integer;
var
  r: TRect;
begin
  if FHandle  = 0 then
    result := FWidth
  else begin
    GetWindowRect(FHandle,r);
    result := r.Right-r.Left;
  end;
end;

procedure TMinForm.SetWidth(value: integer);
var
  r: TRect;
begin
  if FHandle = 0 then
    FWidth := value
  else begin
    GetWindowRect(FHandle,r);
    ChangeWindowSize(FHandle,value,(r.Bottom-r.Top));
  end;
end;

function TMinForm.GetHeight: integer;
var
  r: TRect;
begin
  if FHandle = 0 then
    result := FHeight
  else begin
    GetWindowRect(FHandle,r);
    result := r.Bottom-r.Top;
  end;
end;

procedure TMinForm.SetHeight(value: integer);
var
  r: TRect;
begin
  if FHandle = 0 then
    FHeight := value
  else begin
    GetWindowRect(FHandle,r);
    ChangeWindowSize(FHandle,(r.Right-r.Left),value);
  end;
end;

function TMinForm.GetClientWidth: integer;
var
  r: TRect;
begin
  if FHandle = 0  then
    result := FClientWidth
  else begin
    GetClientRect(FHandle,r);
    result := r.Right;
  end;
end;

procedure TMinForm.SetClientWidth(value: integer);
begin
  if FHandle = 0 then
    FClientWidth := value
  else
    ChangeWindowSize(FHandle,(value+Width-ClientWidth),Height);
end;

function TMinForm.GetClientHeight: integer;
var
  r: TRect;
begin
  if FHandle = 0 then
    result := FClientHeight
  else begin
    GetClientRect(FHandle,r);
    result := r.Bottom;
  end;
end;

procedure TMinForm.SetClientHeight(value: integer);
begin
  if FHandle = 0 then
    FClientHeight := value
  else
    ChangeWindowSize(FHandle,Width,(value+Height-ClientHeight));
end;

procedure TMinForm.InitWidthHeight;
begin
  ChangeWindowSize(FHandle,100,100);
  if FClientWidth <> 0 then
    SetClientWidth(FClientWidth)
  else
    if FWidth <> 0 then SetWidth(FWidth);

  if FClientHeight <> 0 then
    SetClientHeight(FClientHeight)
  else
    if FHeight <> 0 then SetHeight(FHeight);
end;

procedure TMinForm.SetColor(value: COLORREF);
begin
  if  FColor = value then Exit;
  FColor := value;
  if FHandle <> 0 then InvalidateRect(FHandle,nil,true);
end;

procedure TMinForm.SetIcon(value:HICON);
begin
  FIcon := value;
  if FHandle <> 0 then SetClassLong(FHandle,GCL_HICON,value);
end;

procedure TMinForm.Paint(var Message: TWmPaint);
var
  ps: TPaintStruct;
begin
  BeginPaint(Handle, ps);
  EndPaint(Handle, ps);
end;

procedure TMinForm.Close;
begin
  DestroyWindow(FHandle);
end;

procedure TMinForm.Center;
begin
  CenterWindow(FHandle);
end;

function TMinForm.GetVisible: Boolean;
begin
  result := IsWindowVisible(FHandle);
end;

procedure TMinForm.SetVisible(value: Boolean);
begin
   if value then
      ShowWindow(FHandle,SW_SHOW)
   else
      ShowWindow(FHandle,SW_HIDE);
end;

end.