unit UNsmInfo;

interface

uses
  Windows, UNsmConsts, UNsmTypes;

type
  TNsmInfoBase = class(TObject)
  private
    FInitInfo: TNsmPluginInitInfo;
  public
    constructor Create(AInitInfo: TNsmPluginInitInfo); virtual;
    property InitInfo: TNsmPluginInitInfo read FInitInfo;
  end;

  // 낢ȏȒPɎ擾邽߃NX
  // "System/`/GetInfo" T[rX̃bp[֐
  TNsmGetInfo = class(TNsmInfoBase)
  private
    FGetPluginInfo: HNsmService;
    FGetConnectionInfo: HNsmService;
    FGetConnectionMemberInfo: HNsmService;
    FGetConnectionGroupInfo: HNsmService;
    FGetSessionInfo: HNsmService;
    FGetSessionMemberInfo: HNsmService;

    function NsmInfoToWideString(ANsmInfo: TNsmInfo; Len: Integer): WideString;
  public
    constructor Create(AInitInfo: TNsmPluginInitInfo); override;

    function GetPluginInfo(ModuleName: String; InfoKey: Integer): String;
    function GetConnectionInfo(Handle: HNsmConnection; InfoKey: Integer): WideString;
    function GetConnectionInfoInt(Handle: HNsmConnection;InfoKey: Integer): Integer;
    function GetMemberInfo(Handle: HNsmConnection; Account: String; InfoKey: Integer; ListKind: Integer = NMLK_FORWARDLIST): WideString;
    function GetMemberInfoInt(Handle: HNsmConnection; Account: String; InfoKey: Integer; ListKind: Integer = NMLK_FORWARDLIST): Integer;
    function GetGroupInfo(Handle: HNsmConnection; GroupID, InfoKey: Integer): WideString;
    function GetGroupInfoInt(Handle: HNsmConnection; GroupID, InfoKey: Integer): Integer;
    function GetGroupInfoBool(Handle: HNsmConnection; GroupID, InfoKey: Integer): Boolean;
    function GetSessionInfo(Handle: HNsmSession; InfoKey: Integer): WideString;
    function GetSessionInfoInt(Handle: HNsmSession; InfoKey: Integer): Integer;
    function GetSessionMemberInfo(Handle: HNsmSession; Account: String; InfoKey: Integer): WideString;
    function GetSessionMemberInfoInt(Handle: HNsmSession; Account: String; InfoKey: Integer): Integer;
  end;

  // 낢ȏȒPɐݒ肷邽߃NX
  // "System/`/SetInfo" T[rX̃bp[֐
  TNsmSetInfo = class(TNsmInfoBase)
  private
    FSetConnectionInfo: HNsmService;
    FSetConnectionMemberInfo: HNsmService;
    FSetConnectionGroupInfo: HNsmService;
    FSetSessionInfo: HNsmService;
    FSetSessionMemberInfo: HNsmService;
    function WideStringToNsmInfo(S: PWideString): TNsmInfo;
  public
    constructor Create(AInitInfo: TNsmPluginInitInfo); override;

    procedure SetConnectionInfo(Handle: HNsmConnection; InfoKey: Integer; Value: WideString); overload;
    procedure SetConnectionInfo(Handle: HNsmConnection; InfoKey: Integer; Value: Integer); overload;
    procedure SetMemberInfo(Handle: HNsmConnection; Account: String; InfoKey: Integer; Value: WideString; ListKind: Integer; Flags: Integer = 0); overload;
    procedure SetMemberInfo(Handle: HNsmConnection; Account: String; InfoKey, Value: Integer; ListKind: Integer; Flags: Integer = 0); overload;
    procedure SetGroupInfo(Handle: HNsmConnection; GroupID, InfoKey: Integer; Value: WideString; Flags: Integer = 0); overload;
    procedure SetGroupInfo(Handle: HNsmConnection; GroupID, InfoKey, Value: Integer; Flags: Integer = 0); overload;
    procedure SetGroupInfo(Handle: HNsmConnection; GroupID, InfoKey: Integer; Value: Boolean; Flags: Integer = 0); overload;
    procedure SetSessionInfo(Handle: HNsmSession; InfoKey: Integer; Value: WideString); overload;
    procedure SetSessionInfo(Handle: HNsmSession; InfoKey: Integer; Value: Integer); overload;
    procedure SetSessionMemberInfo(Handle: HNsmSession; Account: String; InfoKey: Integer; Value: WideString); overload;
    procedure SetSessionMemberInfo(Handle: HNsmSession; Account: String; InfoKey, Value: Integer); overload;
  end;

implementation

const
  MY_BUFFERSIZE = 512;

// TNsmInfoBase -----------------------------------------------------------------

constructor TNsmInfoBase.Create(AInitInfo: TNsmPluginInitInfo);
begin
  FInitInfo := AInitInfo;
end;

// TNsmGetInfo -----------------------------------------------------------------

constructor TNsmGetInfo.Create(AInitInfo: TNsmPluginInitInfo);
begin
  inherited;
  FGetPluginInfo := InitInfo.GetService(NMS_SYSTEM_GETPLUGININFO);
  FGetConnectionInfo := InitInfo.GetService(NMS_SYSTEM_CONNECTION_GETINFO);
  FGetConnectionMemberInfo := InitInfo.GetService(NMS_SYSTEM_CONNECTION_MEMBERS_GETINFO);
  FGetConnectionGroupInfo := InitInfo.GetService(NMS_SYSTEM_CONNECTION_GROUPS_GETINFO);
  FGetSessionInfo := InitInfo.GetService(NMS_SYSTEM_SESSION_GETINFO);
  FGetSessionMemberInfo := InitInfo.GetService(NMS_SYSTEM_SESSION_MEMBERS_GETINFO);
end;

// TNsmInfo -> WideString
function TNsmGetInfo.NsmInfoToWideString(ANsmInfo: TNsmInfo;
  Len: Integer): WideString;
begin
  Result := '';
  if (Len > 0) and (ANsmInfo.nType = NMIT_WIDESTRING) then
  begin
    Result := WideString(PWideChar(ANsmInfo.lpBuffer));
    SetLength(Result, (Len - 2) div 2);
  end else
  if (Len > 0) and (ANsmInfo.nType = NMIT_STRING) then
  begin
    Result := WideString(String(PChar(ANsmInfo.lpBuffer)));
  end;
end;

function TNsmGetInfo.GetPluginInfo(ModuleName: String; InfoKey: Integer): String;
var
  PlugInfo: TNsmPluginInfo;
  Buff: PChar;
begin
  Result := '';
  GetMem(Buff, MY_BUFFERSIZE);
  try
    with PlugInfo do
    begin
      cbSize  := SizeOf(TNsmPluginInfo);
      lpModuleName := PChar(ModuleName);
      nInfoNo := InfoKey;
      lpBuffer := Buff;
      nBufferSize := MY_BUFFERSIZE;
    end;
    InitInfo.CallService(FGetPluginInfo, Cardinal(@PlugInfo), 0);
    Result := Buff;
  finally
    FreeMem(Buff, MY_BUFFERSIZE);
  end;
end;

// RlNV̕𓾂
function TNsmGetInfo.GetConnectionInfo(Handle: HNsmConnection;
  InfoKey: Integer): WideString;
var
  NsmInfo: TNsmInfo;
  CInfo: TNsmConnectionInfo;
  Buff: Pointer;
  Len: Integer;
begin
  Result := '';
  GetMem(Buff, MY_BUFFERSIZE);
  try
    with NsmInfo do
    begin
      lpBuffer := Buff;
      nBufferSize := MY_BUFFERSIZE;
    end;
    with CInfo do
    begin
      cbSize := SizeOf(TNsmConnectionInfo);
      nInfoKey := InfoKey;
      lpInfo := @NsmInfo;
    end;
    Len := FInitInfo.CallService(FGetConnectionInfo, Handle, Cardinal(@CInfo));
    Result := NsmInfoToWideString(NsmInfo, Len);
  finally
    FreeMem(Buff, MY_BUFFERSIZE);
  end;
end;

// RlNV̐l𓾂
function TNsmGetInfo.GetConnectionInfoInt(Handle: HNsmConnection;
  InfoKey: Integer): Integer;
var
  NsmInfo: TNsmInfo;
  CInfo: TNsmConnectionInfo;
begin
  Result := 0;
  with NsmInfo do
  begin
    lpBuffer := @Result;
    nBufferSize := SizeOf(Integer);
  end;
  with CInfo do
  begin
    cbSize := SizeOf(TNsmConnectionInfo);
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
  end;
  FInitInfo.CallService(FGetConnectionInfo, Handle, Cardinal(@CInfo));
end;

// o̕𓾂
function TNsmGetInfo.GetMemberInfo(Handle: HNsmConnection;
  Account: String; InfoKey: Integer; ListKind: Integer = NMLK_FORWARDLIST): WideString;
var
  NsmInfo: TNsmInfo;
  MInfo: TNsmMemberInfo;
  Buff: Pointer;
  Len: Integer;
begin
  Result := '';
  GetMem(Buff, MY_BUFFERSIZE);
  try
    with NsmInfo do
    begin
      lpBuffer := Buff;
      nBufferSize := MY_BUFFERSIZE;
    end;
    with MInfo do
    begin
      cbSize := SizeOf(TNsmMemberInfo);
      nListKind := ListKind;
      lpAccount := PChar(Account);
      nInfoKey := InfoKey;
      lpInfo := @NsmInfo;
    end;

    Len := FInitInfo.CallService(FGetConnectionMemberInfo, Handle, Cardinal(@MInfo));
    Result := NsmInfoToWideString(NsmInfo, Len);
  finally
    FreeMem(Buff, MY_BUFFERSIZE);
  end;
end;

// o̐l𓾂
function TNsmGetInfo.GetMemberInfoInt(Handle: HNsmConnection;
  Account: String; InfoKey: Integer; ListKind: Integer = NMLK_FORWARDLIST): Integer;
var
  NsmInfo: TNsmInfo;
  MInfo: TNsmMemberInfo;
begin
  Result := 0;
  with NsmInfo do
  begin
    lpBuffer := @Result;
    nBufferSize := SizeOf(Integer);
  end;
  with MInfo do
  begin
    cbSize := SizeOf(TNsmMemberInfo);
    nListKind := ListKind;
    lpAccount := PChar(Account);
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
  end;
  FInitInfo.CallService(FGetConnectionMemberInfo, Handle, Cardinal(@MInfo));
end;

function TNsmGetInfo.GetGroupInfo(Handle: HNsmConnection;
  GroupID, InfoKey: Integer): WideString;
var
  NsmInfo: TNsmInfo;
  GInfo: TNsmGroupInfo;
  Buff: Pointer;
  Len: Integer;
begin
  Result := '';
  GetMem(Buff, MY_BUFFERSIZE);
  try
    with NsmInfo do
    begin
      lpBuffer := Buff;
      nBufferSize := MY_BUFFERSIZE;
    end;
    with GInfo do
    begin
      cbSize := SizeOf(TNsmGroupInfo);
      nGroupID := GroupID;
      nInfoKey := InfoKey;
      lpInfo := @NsmInfo;
    end;

    Len := FInitInfo.CallService(FGetConnectionGroupInfo, Handle, Cardinal(@GInfo));
    Result := NsmInfoToWideString(NsmInfo, Len);
  finally
    FreeMem(Buff, MY_BUFFERSIZE);
  end;
end;

function TNsmGetInfo.GetGroupInfoInt(Handle: HNsmConnection;
  GroupID, InfoKey: Integer): Integer;
var
  NsmInfo: TNsmInfo;
  GInfo: TNsmGroupInfo;
begin
  Result := 0;
  with NsmInfo do
  begin
    lpBuffer := @Result;
    nBufferSize := SizeOf(Integer);
  end;
  with GInfo do
  begin
    cbSize := SizeOf(TNsmGroupInfo);
    nGroupID := GroupID;
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
  end;
  FInitInfo.CallService(FGetConnectionGroupInfo, Handle, Cardinal(@GInfo));
end;

function TNsmGetInfo.GetGroupInfoBool(Handle: HNsmConnection;
  GroupID, InfoKey: Integer): Boolean;
var
  NsmInfo: TNsmInfo;
  GInfo: TNsmGroupInfo;
begin
  Result := False;
  with NsmInfo do
  begin
    lpBuffer := @Result;
    nBufferSize := SizeOf(Boolean);
  end;
  with GInfo do
  begin
    cbSize := SizeOf(TNsmGroupInfo);
    nGroupID := GroupID;
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
  end;
  FInitInfo.CallService(FGetConnectionGroupInfo, Handle, Cardinal(@GInfo));
end;

// ZbV̕𓾂
function TNsmGetInfo.GetSessionInfo(Handle: HNsmSession;
  InfoKey: Integer): WideString;
var
  NsmInfo: TNsmInfo;
  SInfo: TNsmSessionInfo;
  Buff: Pointer;
  Len: Integer;
begin
  Result := '';
  GetMem(Buff, MY_BUFFERSIZE);
  try
    with NsmInfo do
    begin
      lpBuffer := Buff;
      nBufferSize := MY_BUFFERSIZE;
    end;
    with SInfo do
    begin
      cbSize := SizeOf(TNsmSessionInfo);
      nInfoKey := InfoKey;
      lpInfo := @NsmInfo;
    end;
    Len := FInitInfo.CallService(FGetSessionInfo, Handle, Cardinal(@SInfo));
    Result := NsmInfoToWideString(NsmInfo, Len);
  finally
    FreeMem(Buff, MY_BUFFERSIZE);
  end;
end;

// ZbV̐l𓾂
function TNsmGetInfo.GetSessionInfoInt(Handle: HNsmSession;
  InfoKey: Integer): Integer;
var
  NsmInfo: TNsmInfo;
  SInfo: TNsmSessionInfo;
begin
  Result := 0;
  with NsmInfo do
  begin
    lpBuffer := @Result;
    nBufferSize := SizeOf(Integer);
  end;
  with SInfo do
  begin
    cbSize := SizeOf(TNsmSessionInfo);
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
  end;
  FInitInfo.CallService(FGetSessionInfo, Handle, Cardinal(@SInfo));
end;

// ZbVQo̕𓾂
function TNsmGetInfo.GetSessionMemberInfo(Handle: HNsmSession;
  Account: String; InfoKey: Integer): WideString;
var
  NsmInfo: TNsmInfo;
  MInfo: TNsmMemberInfo;
  Buff: Pointer;
  Len: Integer;
begin
  Result := '';
  GetMem(Buff, MY_BUFFERSIZE);
  try
    with NsmInfo do
    begin
      lpBuffer := Buff;
      nBufferSize := MY_BUFFERSIZE;
    end;
    with MInfo do
    begin
      cbSize := SizeOf(TNsmMemberInfo);
      lpAccount := PChar(Account);
      nInfoKey := InfoKey;
      lpInfo := @NsmInfo;
    end;

    Len := FInitInfo.CallService(FGetSessionMemberInfo, Handle, Cardinal(@MInfo));
    Result := NsmInfoToWideString(NsmInfo, Len);
  finally
    FreeMem(Buff, MY_BUFFERSIZE);
  end;
end;

// ZbVQo̐l𓾂
function TNsmGetInfo.GetSessionMemberInfoInt(Handle: HNsmSession;
  Account: String; InfoKey: Integer): Integer;
var
  NsmInfo: TNsmInfo;
  MInfo: TNsmMemberInfo;
begin
  Result := 0;
  with NsmInfo do
  begin
    lpBuffer := @Result;
    nBufferSize := SizeOf(Integer);
  end;
  with MInfo do
  begin
    cbSize := SizeOf(TNsmMemberInfo);
    lpAccount := PChar(Account);
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
  end;
  FInitInfo.CallService(FGetSessionMemberInfo, Handle, Cardinal(@MInfo));
end;

// TNsmSetInfo -----------------------------------------------------------------

constructor TNsmSetInfo.Create(AInitInfo: TNsmPluginInitInfo);
begin
  inherited;
  FSetConnectionInfo := InitInfo.GetService(NMS_SYSTEM_CONNECTION_SETINFO);
  FSetConnectionMemberInfo := InitInfo.GetService(NMS_SYSTEM_CONNECTION_MEMBERS_SETINFO);
  FSetConnectionGroupInfo := InitInfo.GetService(NMS_SYSTEM_CONNECTION_GROUPS_SETINFO);
  FSetSessionInfo := InitInfo.GetService(NMS_SYSTEM_SESSION_SETINFO);
  FSetSessionMemberInfo := InitInfo.GetService(NMS_SYSTEM_SESSION_MEMBERS_SETINFO);
end;

function TNsmSetInfo.WideStringToNsmInfo(S: PWideString): TNsmInfo;
begin
  with Result do
  begin
    nType := NMIT_WIDESTRING;
    lpBuffer := Pointer(PWideChar(S^));
    nBufferSize := Length(S^) * 2 + 2;     // ^[~l[^̒Yꂸ
  end;
end;

procedure TNsmSetInfo.SetConnectionInfo(Handle: HNsmConnection;
  InfoKey: Integer; Value: WideString);
var
  NsmInfo: TNsmInfo;
  CInfo: TNsmConnectionInfo;
begin
  NsmInfo := WideStringToNsmInfo(@Value);
  with CInfo do
  begin
    cbSize := SizeOf(TNsmConnectionInfo);
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
  end;
  FInitInfo.CallService(FSetConnectionInfo, Handle, Cardinal(@CInfo));
end;

procedure TNsmSetInfo.SetConnectionInfo(Handle: HNsmConnection;
  InfoKey: Integer; Value: Integer);
var
  NsmInfo: TNsmInfo;
  CInfo: TNsmConnectionInfo;
begin
  with NsmInfo do
  begin
    nType := NMIT_INTEGER;
    lpBuffer := @Value;
    nBufferSize := SizeOf(Integer);
  end;
  with CInfo do
  begin
    cbSize := SizeOf(TNsmConnectionInfo);
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
  end;
  FInitInfo.CallService(FSetConnectionInfo, Handle, Cardinal(@CInfo));
end;

procedure TNsmSetInfo.SetMemberInfo(Handle: HNsmConnection; Account: String;
  InfoKey: Integer; Value: WideString; ListKind: Integer; Flags: Integer = 0);
var
  NsmInfo: TNsmInfo;
  MInfo: TNsmMemberInfo;
begin
  NsmInfo := WideStringToNsmInfo(@Value);
  with MInfo do
  begin
    cbSize := SizeOf(TNsmMemberInfo);
    nListKind := ListKind;
    lpAccount := PChar(Account);
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
    nFlags := Flags;
  end;
  FInitInfo.CallService(FSetConnectionMemberInfo, Handle, Cardinal(@MInfo));
end;

procedure TNsmSetInfo.SetMemberInfo(Handle: HNsmConnection; Account: String;
  InfoKey, Value: Integer; ListKind: Integer; Flags: Integer = 0);
var
  NsmInfo: TNsmInfo;
  MInfo: TNsmMemberInfo;
begin
  with NsmInfo do
  begin
    nType := NMIT_INTEGER;
    lpBuffer := @Value;
    nBufferSize := SizeOf(Integer);
  end;
  with MInfo do
  begin
    cbSize := SizeOf(TNsmMemberInfo);
    nListKind := ListKind;
    lpAccount := PChar(Account);
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
    nFlags := Flags;    
  end;
  FInitInfo.CallService(FSetConnectionMemberInfo, Handle, Cardinal(@MInfo));
end;

procedure TNsmSetInfo.SetGroupInfo(Handle: HNsmConnection; GroupID,
  InfoKey: Integer; Value: WideString; Flags: Integer = 0);
var
  NsmInfo: TNsmInfo;
  GInfo: TNsmGroupInfo;
begin
  NsmInfo := WideStringToNsmInfo(@Value);
  with GInfo do
  begin
    cbSize := SizeOf(TNsmGroupInfo);
    nGroupID := GroupID;
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
    nFlags := Flags;
  end;
  FInitInfo.CallService(FSetConnectionGroupInfo, Handle, Cardinal(@GInfo));
end;

procedure TNsmSetInfo.SetGroupInfo(Handle: HNsmConnection; GroupID, InfoKey,
  Value: Integer; Flags: Integer = 0);
var
  NsmInfo: TNsmInfo;
  GInfo: TNsmGroupInfo;
begin
  with NsmInfo do
  begin
    nType := NMIT_INTEGER;
    lpBuffer := @Value;
    nBufferSize := SizeOf(Integer);
  end;
  with GInfo do
  begin
    cbSize := SizeOf(TNsmGroupInfo);
    nGroupID := GroupID;
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
    nFlags := Flags;
  end;
  FInitInfo.CallService(FSetConnectionGroupInfo, Handle, Cardinal(@GInfo));
end;

procedure TNsmSetInfo.SetGroupInfo(Handle: HNsmConnection; GroupID,
  InfoKey: Integer; Value: Boolean; Flags: Integer = 0);
var
  NsmInfo: TNsmInfo;
  GInfo: TNsmGroupInfo;
begin
  with NsmInfo do
  begin
    nType := NMIT_BOOL;
    lpBuffer := @Value;
    nBufferSize := SizeOf(Boolean);
  end;
  with GInfo do
  begin
    cbSize := SizeOf(TNsmGroupInfo);
    nGroupID := GroupID;
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
    nFlags := Flags;
  end;
  FInitInfo.CallService(FSetConnectionGroupInfo, Handle, Cardinal(@GInfo));
end;

procedure TNsmSetInfo.SetSessionInfo(Handle: HNsmSession; InfoKey: Integer;
  Value: WideString);
var
  NsmInfo: TNsmInfo;
  SInfo: TNsmSessionInfo;
begin
  NsmInfo := WideStringToNsmInfo(@Value);
  with SInfo do
  begin
    cbSize := SizeOf(TNsmSessionInfo);
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
  end;
  FInitInfo.CallService(FSetSessionInfo, Handle, Cardinal(@SInfo));
end;

procedure TNsmSetInfo.SetSessionInfo(Handle: HNsmSession; InfoKey: Integer;
  Value: Integer);
var
  NsmInfo: TNsmInfo;
  SInfo: TNsmSessionInfo;
begin
  with NsmInfo do
  begin
    nType := NMIT_INTEGER;
    lpBuffer := @Value;
    nBufferSize := SizeOf(Integer);
  end;
  with SInfo do
  begin
    cbSize := SizeOf(TNsmSessionInfo);
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
  end;
  FInitInfo.CallService(FSetSessionInfo, Handle, Cardinal(@SInfo));
end;

procedure TNsmSetInfo.SetSessionMemberInfo(Handle: HNsmSession; Account: String;
  InfoKey: Integer; Value: WideString);
var
  NsmInfo: TNsmInfo;
  MInfo: TNsmMemberInfo;
begin
  NsmInfo := WideStringToNsmInfo(@Value);
  with MInfo do
  begin
    cbSize := SizeOf(TNsmMemberInfo);
    lpAccount := PChar(Account);
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
  end;
  FInitInfo.CallService(FSetSessionMemberInfo, Handle, Cardinal(@MInfo));
end;

procedure TNsmSetInfo.SetSessionMemberInfo(Handle: HNsmSession; Account: String;
  InfoKey, Value: Integer);
var
  NsmInfo: TNsmInfo;
  MInfo: TNsmMemberInfo;
begin
  with NsmInfo do
  begin
    nType := NMIT_INTEGER;
    lpBuffer := @Value;
    nBufferSize := SizeOf(Integer);
  end;
  with MInfo do
  begin
    cbSize := SizeOf(TNsmMemberInfo);
    lpAccount := PChar(Account);
    nInfoKey := InfoKey;
    lpInfo := @NsmInfo;
  end;
  FInitInfo.CallService(FSetSessionMemberInfo, Handle, Cardinal(@MInfo));
end;

end.
